#include <stdio.h>
#include <process.h>
#include "utype.h"
#include "lists.h"
#include "cmdline.h"
#include "winmode.h"

#define TEMPFILE "$$$CC386.TMP"

extern int prm_winmode ;
extern int prm_debug ;
extern int prm_crtdll ;
extern char *prm_searchpath ;

char *winflags[4] = { "/NCI /32 /PE /CON ", "/NCI /32 /PE /WIN ", 
         "/NCI /32 /PE /BDL ", "/NCI /32 " } ;
char *winc0[4] = { "c0Xwin.obj","cowin.obj","codwin.obj","cod0s.obj"} ;

LIST *objlist,*asmlist,*liblist,*reslist,*rclist ;
static char outputfile[256] ;

static void InsertFile(LIST **r, char *name, char *ext)
{

   char buf[256],*newbuffer ;
   strcpy(buf,name) ;
   if (!outputfile[0]) {
      strcpy(outputfile,name) ;
      StripExt(outputfile) ;
      AddExt(outputfile,".EXE") ;
   }
   if (ext) {
      StripExt(buf) ;
      AddExt(buf,ext) ;
   }
      newbuffer = (char *) malloc(strlen(buf) + 1);
      if (!newbuffer)
         return ;
      strcpy(newbuffer,buf);

  /* Insert file */
      while (*r)
         r = &(*r)->link;
      *r = malloc(sizeof(LIST));
      if (!r)
         return ;
      (*r)->link = 0;
      (*r)->data = newbuffer;
}
int InsertExternalFile(char *name)
{
   if (HasExt(name,".ASM")) {
      InsertFile(&objlist,name,".OBJ") ;
      InsertFile(&asmlist,name,0) ;
      return 1 ;                           // compiler shouldn't process it
   } else if (HasExt(name,".LIB")) {
      InsertFile(&liblist,name,0) ;
      return 1 ;
   } else if (HasExt(name,".RC")) {
      InsertFile(&reslist,name,".RES") ;
      InsertFile(&rclist,name,0) ;
      return 1 ;
   } else if (HasExt(name,".RES")) {
      InsertFile(&reslist,name,0) ;
      return 1 ;
   } else if (HasExt(name,".obj")) {
      InsertFile(&objlist,name,0) ;
      return 1 ;
   }

   InsertFile(&objlist,name,".OBJ") ;
   return 0 ; // compiler should process it
}
void InsertOutputFile(char *name)
{
   strcpy(outputfile,name) ;
}
int RunExternalFiles(void)
{
   char args[1024] ;
   int rv ;
   while (asmlist) {
      rv = spawnlp(P_WAIT,"nasm.exe","nasm","-fobj",asmlist->data,0) ;
      if (rv)
         return rv ;
      asmlist = asmlist->link ;
   }
   if (prm_searchpath)
      sprintf(args,"-i%s",prm_searchpath) ;
   else
      args[0] = 0 ;
   while (rclist) {
      rv = spawnlp(P_WAIT,"xrc.exe","xrc","-r",args,rclist->data,0) ;
      if (rv)
         return rv ;
      rclist = rclist->link ;
   }
   if (objlist) {
      FILE *fil = fopen(TEMPFILE,"w") ;
      if (!fil)
         return 1 ;
      strcpy(args,winflags[prm_winmode]) ;
      if (prm_debug)
         strcat(args," /DEB") ;
      fprintf(fil,"  %s",winc0[prm_winmode]) ;
      while (objlist) {
         fprintf(fil," %s",objlist->data) ;
         objlist = objlist->link ;
      }
      fprintf(fil,"\n") ;
      fprintf(fil,"  %s\n  \n",outputfile) ; // no libs
      while (liblist) {
         fprintf(fil," %s",liblist->data) ;
         objlist = liblist->link ;
      }
      if (prm_crtdll)
         fprintf(fil," climp crtdll\n") ;
      else if (prm_winmode == DOS)
         fprintf(fil," cldos\n") ;
      else
         fprintf(fil," climp clwin\n") ;
      while (reslist) {
         fprintf(fil," %s",reslist->data) ;
         reslist = reslist->link ;
      }
      fprintf(fil,"\n  \n") ;
      fclose(fil) ;
      rv = spawnlp(P_WAIT,"valx.exe","valx.exe",args,"@"TEMPFILE,0) ;
      if (rv)
         return rv ;

//      unlink(TEMPFILE) ;
   }
   return 0 ;
}