/*  stdio.h

    Definitions for stream input/output.

*/

#ifndef __STDIO_H
#define __STDIO_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

typedef long    fpos_t;

#define FILTOK	0x444c
#define STACKPAD 512

/*  "flags" bits definitions
*/
#define _F_RDWR 0x0003                  /* Read/write flag       */
#define _F_READ 0x0001                  /* Read only file        */
#define _F_WRIT 0x0002                  /* Write only file       */
#define _F_BUF  0x0004                  /* Malloc'ed Buffer data */
#define _F_LBUF 0x0008                  /* line-buffered file    */
#define _F_ERR  0x0010                  /* Error indicator       */
#define _F_EOF  0x0020                  /* End of file indicator */
#define _F_BIN  0x0040                  /* Binary file indicator */
#define _F_IN   0x0080                  /* Data is incoming      */
#define _F_OUT  0x0100                  /* Data is outgoing      */
#define _F_TERM 0x0200                  /* File is a terminal    */
#define _F_SKIPLF 0x400			/* Need to skip next LF  */
#define _F_APPEND 0x800			/* Need to ignore seeks  */
#define _F_BUFFEREDSTRING 0x1000       /* it is not an actual file */

/* End-of-file constant definition
*/
#define EOF (-1)            /* End of file indicator */

/* Default buffer size use by "setbuf" function
*/
#define BUFSIZ  512         /* Buffer size for stdio */

/* Size of an arry large enough to hold a temporary file name string
*/
#define L_ctermid   5       /* CON: plus null byte */
#define P_tmpdir    ""      /* temporary directory */
#define L_tmpnam    13      /* tmpnam buffer size */

/* Constants to be used as 3rd argument for "fseek" function
*/
#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

/* Number of unique file names that shall be generated by "tmpnam" function
*/
#define TMP_MAX     0xFFFF

#define _NFILE_ 40 /* SHOULD BE SAME AS IN IO.H */
/* Definition of the control structure for streams
*/
typedef struct  {
        int             level;          /* fill/empty level of buffer */
        unsigned        flags;          /* File status flags          */
        int             fd;             /* File descriptor            */
        unsigned char   hold;           /* Ungetc char if no buffer   */
        int             bsize;          /* Buffer size                */
        unsigned char   *buffer;   /* Data transfer buffer       */
        unsigned char   *curp;     /* Current active pointer     */
        unsigned        istemp;         /* Temporary file indicator   */
        short           token;          /* Used for validity checking */
}       FILE;                           /* This is the FILE object    */

/* Number of files that can be open simultaneously
*/
#define FOPEN_MAX (_NFILE_ - 2) /* (_NFILE_ - stdaux & stdprn) */

#define FILENAME_MAX 80

/* Standard I/O predefined streams
*/

extern  unsigned     _nfile;
FILE *   RTL_NORM __getStream(int stream) ;

#define _IOFBF  1
#define _IOLBF  2
#define _IONBF  4

#define stdin   __stdin
#define stdout  __stdout
#define stderr  __stderr
#define stdaux  __stdaux /* these two not supported now */
#define stdprn  __stdprn

extern FILE * __stdin ;
extern FILE * __stdout ;
extern FILE * __stderr ;
extern FILE * __stdaux ;
extern FILE * __stdprn ;


#ifdef __cplusplus
extern "C" {
#endif
void      RTL_NORM clearerr(FILE *__stream);
int       RTL_NORM fclose(FILE *__stream);
int       RTL_NORM fflush(FILE *__stream);
int       RTL_NORM fgetc(FILE *__stream);
int       RTL_NORM fgetpos(FILE *__stream, fpos_t *__pos);
char   *  RTL_NORM fgets(char *__s, int __n, FILE *__stream);
FILE   *  RTL_NORM fopen(const char *__path, const char *__mode);
int       RTL_NORM fprintf(FILE *__stream, const char *__format, ...);
int       RTL_NORM fputc(int __c, FILE *__stream);
int       RTL_NORM fputs(const char *__s, FILE *__stream);
size_t    RTL_NORM fread(void *__ptr, size_t __size, size_t __n,
                     FILE *__stream);
FILE   *  RTL_NORM freopen(const char *__path, const char *__mode,
                            FILE *__stream);
int       RTL_NORM fscanf(FILE *__stream, const char *__format, ...);
int       RTL_NORM fseek(FILE *__stream, long __offset, int __whence);
int       RTL_NORM fsetpos(FILE *__stream, const fpos_t *__pos);
long      RTL_NORM ftell(FILE *__stream);
size_t    RTL_NORM fwrite(const void *__ptr, size_t __size, size_t __n,
                      FILE *__stream);
char   *  RTL_NORM gets(char *__s);
void      RTL_NORM perror(const char *__s);
int       RTL_NORM printf(const char *__format, ...);
int       RTL_NORM puts(const char *__s);
int       RTL_NORM remove(const char *__path);
int       RTL_NORM rename(const char *__oldname,const char *__newname);
void      RTL_NORM rewind(FILE *__stream);
int               scanf(const char *__format, ...);
void              setbuf(FILE *__stream, char *__buf);
int       RTL_NORM setvbuf(FILE *__stream, char *__buf,
                                   int __type, size_t __size);
int       RTL_NORM sprintf(char *__buffer, const char *__format, ...);
int       RTL_NORM sscanf(const char *__buffer,
                                  const char *__format, ...);
char   *  RTL_NORM strerror(int __errnum);
FILE   *  RTL_NORM tmpfile(void);
char   *  RTL_NORM tmpnam(char *__s);
int       RTL_NORM ungetc(int __c, FILE *__stream);
int       RTL_NORM vfprintf(FILE *__stream, const char *__format,
                                    void *__arglist);
int       RTL_NORM vfscanf(FILE *__stream, const char *__format,
                                   void *__arglist);
int       RTL_NORM vprintf(const char *__format, void *__arglist);
int       RTL_NORM vscanf(const char *__format, void *__arglist);
int       RTL_NORM vsprintf(char *__buffer, const char *__format,
                                    void *__arglist);
int       RTL_NORM vsscanf(const char *__buffer, const char *__format,
                                   void *__arglist);
int       RTL_NORM unlink(const char *__path);
int       RTL_NORM getc(FILE *__fp);

int       RTL_NORM getchar(void);
int       RTL_NORM putchar(const int __c);

int       RTL_NORM putc(const int __c, FILE *__fp);
int       RTL_NORM feof(FILE *__fp);
int       RTL_NORM ferror(FILE *__fp);

int       RTL_NORM fcloseall(void);
FILE    * RTL_NORM fdopen(int __handle, char *__type);
int       RTL_NORM fgetchar(void);
int       RTL_NORM flushall(void);
int       RTL_NORM fputchar(int __c);
FILE    * RTL_NORM _fsopen (const char *__path, const char *__mode,
                  int __shflag);
int       RTL_NORM getw(FILE *__stream);
int       RTL_NORM putw(int __w, FILE *__stream);
int       RTL_NORM rmtmp(void);
char    * RTL_NORM _strerror(const char *__s);
char    * RTL_NORM tempnam(char *__dir, char *__pfx);

#define fileno(f)       ((f)->fd)

int       RTL_NORM _fgetc(FILE *__stream);           /* used by getc() macro */
int       RTL_NORM _fputc(int __c, FILE *__stream); /* used by putc() macro */
void      RTL_NORM _InitEasyWin(void);  /* Initialization call for Easy Windows */

#ifdef __cplusplus
};
#endif

/*  The following macros provide for common functions */

#define ferror(f)   ((f)->flags & _F_ERR)
#define feof(f)     ((f)->flags & _F_EOF)

/*
 * the following four macros are somewhat problematic as they will
 * ignore line buffering...
 */
#ifdef OLD
#define getc(f) \
  ((--((f)->level) > 0) ? (unsigned char)(*(f)->curp++) : \
    _fgetc (f))

#define putc(c,f) \
  ((++((f)->level) < 0) ? (unsigned char)(*(f)->curp++=(c)) : \
    _fputc ((c),f))
#endif
#define getc(f) fgetc(f)
#define putc(c,f) fputc((c),f)
#define getchar()  getc(stdin)
#define putchar(c) putc((c), stdout)

#define ungetc(c,f) ungetc((c),f)   /* traditionally a macro */


#endif  /* __STDIO_H */