/*  string.h

    Definitions for memory and string functions.

*/

#ifndef __STRING_H
#define __STRING_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#if !defined(NULL)
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#ifdef __cplusplus
extern "C" {
#endif

int          _RTL_INTRINS memcmp(const void *__s1,
                                       const void *__s2, size_t __n);
void *       _RTL_INTRINS memcpy(void *__dest, const void *__src,
                                       size_t __n);
void *       _RTL_INTRINS memmove(void *__dest, const void *__src,
                                        size_t __n);
void *       _RTL_INTRINS memset(void *__s, int __c, size_t __n);
char *       _RTL_INTRINS strcat(char *__dest, const char *__src);
int          _RTL_INTRINS strcmp(const char *__s1, const char *__s2);
char *       _RTL_INTRINS strcpy(char *__dest, const char *__src);
size_t       _RTL_NORM strcspn(const char *__s1, const char *__s2);
char *       _RTL_NORM strdup(const char *string);
char *       _RTL_NORM strerror(int __errnum);
size_t       _RTL_INTRINS strlen(const char *__s);
char *       _RTL_INTRINS strncat(char *__dest, const char *__src,
                                        size_t __maxlen);
int          _RTL_INTRINS strncmp(const char *__s1, const char *__s2,
                                        size_t __maxlen);
char *       _RTL_INTRINS strncpy(char *__dest, const char *__src,
                                        size_t __maxlen);
size_t       _RTL_NORM strspn(const char *__s1, const char *__s2);
char *       _RTL_NORM strtok(char *__s1, const char *__s2);
char *       _RTL_NORM _strerror(const char *__s);


void *       _RTL_INTRINS memchr(const void *__s, int __c, size_t __n);
char *       _RTL_INTRINS strchr(const char * __s, int __c);
char *       _RTL_INTRINS strrchr(const char *__s, int __c);
char *       _RTL_NORM strpbrk(const char *__s1, const char *__s2);
char *       _RTL_NORM strstr(const char *__s1, const char *__s2);

int          _RTL_NORM _lstrcoll(const char *__s1, const char *__s2);
size_t       _RTL_NORM _lstrxfrm(char *__s1, const char *__s2,
                                            size_t __n );
int          _RTL_NORM strcoll(const char *__s1, const char *__s2);
size_t       _RTL_NORM strxfrm(char *__s1, const char *__s2,
                                          size_t __n );

#if defined(__USELOCALES__)
#define  strupr   _lstrupr
#define  strlwr   _lstrlwr
#define  strcoll  _lstrcoll
#define  strxfrm  _lstrxfrm
#endif  /* __USELOCALES__ */

//#if !defined(__STDC__)
char *       _RTL_NORM strupr(char * __s);
char *       _RTL_NORM strlwr(char * __s);
int          _RTL_NORM strnicmp(const char *__s1, const char *__s2, size_t __n);
int          _RTL_NORM stricmp(const char *__s1, const char *__s2);
#define  strcmpi(x,y)  stricmp(x,y)
#define  strncmpi(x,y) strnicmp(x,y)
//#endif /* __STDC__ */

#ifdef __cplusplus
};
#endif

#endif  /* __STRING_H */