	SECTION _TEXT CLASS=CODE USE32
	SECTION _DATA CLASS=DATA USE32
	SECTION _BSS  CLASS=BSS USE32
	SECTION _CONST  CLASS=CONST USE32
	SECTION _STRING  CLASS=STRING USE32
	SECTION cstartup CLASS=INITDATA USE32
	SECTION crundown CLASS=EXITDATA USE32
	SECTION cppinit  CLASS=CPPINIT USE32
	SECTION cppexit  CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
;
; Line 21:	{
;
_conio_init:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 0CH
	PUSH	ESI
	MOV	ESI,DWORD _the_info
;
; Line 26:		dpmi_alloc_descriptors(&realdata,1);
;
	PUSH	BYTE 01H
	PUSH	DWORD _realdata
	CALL	_dpmi_alloc_descriptors
	ADD	ESP,BYTE 08H
;
; Line 27:		dpmi_set_sel_base(realdata,0x0);
;
	PUSH	BYTE 00H
	MOVZX	EAX,WORD [_realdata]
	PUSH	EAX
	CALL	_dpmi_set_sel_base
	ADD	ESP,BYTE 08H
;
; Line 28:		dpmi_set_sel_limit(realdata,0xF0000);
;
	PUSH	DWORD 0F0000H
	MOVZX	EAX,WORD [_realdata]
	PUSH	EAX
	CALL	_dpmi_set_sel_limit
	ADD	ESP,BYTE 08H
;
; Line 29:		asm push fs
;
	PUSH	FS
;
; Line 30:		asm mov fs,[realdata]
;
	MOV	FS,WORD [_realdata]
;
; Line 31:		asm mov al,fs:[0x449]
;
	MOV	AL,BYTE [FS:0449H]
;
; Line 32:		asm mov [mode],al
;
	MOV	BYTE [EBP+0FFFFFFF7H],AL
;
; Line 33:		asm mov ax,fs:[0x450]
;
	MOV	AX,WORD [FS:0450H]
;
; Line 34:		asm mov [curs],ax
;
	MOV	WORD [EBP+0FFFFFFF8H],AX
;
; Line 35:		asm pop fs
;
	POP	FS
;
; Line 36:		textini(mode);
;
	MOVZX	EAX,BYTE [EBP+0FFFFFFF7H]
	PUSH	EAX
	CALL	_textini
	POP	ECX
;
; Line 37:		the_info.curx = curs & 0xff;
;
	MOVZX	AX,BYTE [EBP+0FFFFFFF8H]
	MOV	BYTE [ESI+09H],AL
;
; Line 38:		the_info.cury = curs >> 8;
;
	MOVZX	EAX,WORD [EBP+0FFFFFFF8H]
	SAR	EAX,08H
	MOV	BYTE [ESI+0AH],AL
;
; Line 39:	  pos = screenbase + the_info.screenwidth * the_info.screenheight * 2 - 1;
;
	MOVZX	EAX,BYTE [ESI+08H]
	MOVZX	ECX,BYTE [ESI+07H]
	IMUL	EAX,ECX
	SHL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	DEC	EAX
	MOV	DWORD [EBP+0FFFFFFFCH],EAX
;
; Line 40:		asm push fs;
;
	PUSH	FS
;
; Line 41:		asm mov fs,[realdata];
;
	MOV	FS,WORD [_realdata]
;
; Line 42:		asm mov ecx,[pos];
;
	MOV	ECX,DWORD [EBP+0FFFFFFFCH]
;
; Line 43:		asm mov al,fs:[ecx]
;
	MOV	AL,BYTE [FS:ECX]
;
; Line 44:		asm mov [atr],al
;
	MOV	BYTE [EBP+0FFFFFFFBH],AL
;
; Line 45:	  asm pop fs
;
	POP	FS
;
; Line 46:		the_info.normattr = the_info.attribute = atr;
;
	MOV	AL,BYTE [EBP+0FFFFFFFBH]
	MOV	BYTE [ESI+04H],AL
	MOV	BYTE [ESI+05H],AL
;
; Line 49:	}
;
	POP	ESI
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 51:	{
;
_conio_rundown:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 034H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP+0FFFFFFCCH]
	MOV	EDI,DWORD _the_info
;
; Line 54:		the_info.attribute = the_info.normattr;
;
	MOV	AL,BYTE [EDI+05H]
	MOV	BYTE [EDI+04H],AL
;
; Line 55:		regs.b.ah = 0x2;
;
	MOV	BYTE [ESI+01DH],02H
;
; Line 56:		regs.b.bh = 0;
;
	MOV	BYTE [ESI+011H],00H
;
; Line 57:	  regs.b.dh = the_info.cury+the_info.wintop;
;
	MOV	AL,BYTE [EDI+0AH]
	ADD	AL,BYTE [EDI+01H]
	MOV	BYTE [ESI+015H],AL
;
; Line 58:	  regs.b.dl = the_info.curx+the_info.winleft;
;
	MOV	AL,BYTE [EDI+09H]
	ADD	AL,BYTE [EDI+00H]
	MOV	BYTE [ESI+014H],AL
;
; Line 59:		regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 60:		regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 61:		regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 62:		dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 63:		dpmi_free_selector(realdata);
;
	MOVZX	EAX,WORD [_realdata]
	PUSH	EAX
	CALL	_dpmi_free_selector
	POP	ECX
;
; Line 64:	}
;
	POP	EDI
	POP	ESI
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_getch]
;
; Line 66:	{
;
_getch:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 034H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP+0FFFFFFCCH]
	MOV	EDI,DWORD _the_info
;
; Line 68:		if (ungetchar) {
;
	CMP	DWORD [_ungetchar],BYTE 00H
	JE	SHORT	L_1
;
; Line 69:			rv = ungetchar;
;
	MOV	EBX,DWORD [_ungetchar]
;
; Line 70:			ungetchar = 0;
;
	MOV	DWORD [_ungetchar],00H
;
; Line 71:		}
;
	JMP	L_2
L_1:
;
; Line 74:		  regs.b.ah = 0x2;
;
	MOV	BYTE [ESI+01DH],02H
;
; Line 75:		  regs.b.bh = 0;
;
	MOV	BYTE [ESI+011H],00H
;
; Line 76:	    regs.b.dh = the_info.cury+the_info.wintop;
;
	MOV	AL,BYTE [EDI+0AH]
	ADD	AL,BYTE [EDI+01H]
	MOV	BYTE [ESI+015H],AL
;
; Line 77:	    regs.b.dl = the_info.curx+the_info.winleft;
;
	MOV	AL,BYTE [EDI+09H]
	ADD	AL,BYTE [EDI+00H]
	MOV	BYTE [ESI+014H],AL
;
; Line 78:		  regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 79:		  regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 80:		  regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 81:		  dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 82:			regs.b.ah = 0x0;
;
	MOV	BYTE [ESI+01DH],00H
;
; Line 83:			regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 84:			regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 85:			regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 86:			dpmi_simulate_real_interrupt(0x16,&regs);
;
	PUSH	ESI
	PUSH	BYTE 016H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 87:			rv = regs.h.ax;
;
	MOVZX	EAX,WORD [ESI+01CH]
	MOV	EBX,EAX
;
; Line 88:			if (rv & 0xff)
;
	MOVZX	EAX,BL
	TEST	EAX,EAX
	JE	SHORT	L_3
;
; Line 89:				rv &= 0xff;
;
	MOVZX	EBX,BL
L_3:
;
; Line 91:		}
;
L_2:
;
; Line 92:		return rv;
;
	MOV	EAX,EBX
L_5:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_kbhit]
;
; Line 95:	{
;
_kbhit:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 034H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP+0FFFFFFCCH]
	MOV	EDI,DWORD _the_info
;
; Line 97:		regs.b.ah = 0x2;
;
	MOV	BYTE [ESI+01DH],02H
;
; Line 98:		regs.b.bh = 0;
;
	MOV	BYTE [ESI+011H],00H
;
; Line 99:	  regs.b.dh = the_info.cury+the_info.wintop;
;
	MOV	AL,BYTE [EDI+0AH]
	ADD	AL,BYTE [EDI+01H]
	MOV	BYTE [ESI+015H],AL
;
; Line 100:	  regs.b.dl = the_info.curx+the_info.winleft;
;
	MOV	AL,BYTE [EDI+09H]
	ADD	AL,BYTE [EDI+00H]
	MOV	BYTE [ESI+014H],AL
;
; Line 101:		regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 102:		regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 103:		regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 104:		dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 105:		regs.b.ah = 0x1;
;
	MOV	BYTE [ESI+01DH],01H
;
; Line 106:		regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 107:		regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 108:		regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 109:		dpmi_simulate_real_interrupt(0x16,&regs);
;
	PUSH	ESI
	PUSH	BYTE 016H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 110:		return !(regs.h.flags & 0x40);
;
	MOVZX	EAX,WORD [ESI+020H]
	AND	EAX,BYTE 040H
	SETE	AL
	MOVZX	EAX,AL
L_6:
	POP	EDI
	POP	ESI
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 113:	{
;
_biosmode:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 034H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP+0FFFFFFCCH]
	MOV	EDI,DWORD [EBP+08H]
;
; Line 115:		int newmode = mode;
;
	MOV	EBX,EDI
;
; Line 116:		if (newmode == C4350)
;
	CMP	EBX,BYTE 040H
	JNE	SHORT	L_7
;
; Line 117:			newmode = 3;
;
	MOV	EBX,03H
L_7:
;
; Line 118:		regs.b.ah = 0x0;
;
	MOV	BYTE [ESI+01DH],00H
;
; Line 119:		regs.b.al = newmode;
;
	MOV	BYTE [ESI+01CH],BL
;
; Line 120:		regs.h.flags = 0x72;
;
	MOV	WORD [ESI+020H],072H
;
; Line 121:		regs.h.ss = 0;
;
	MOV	WORD [ESI+030H],00H
;
; Line 122:		regs.h.sp = 0;
;
	MOV	WORD [ESI+02EH],00H
;
; Line 123:		dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 124:		if (mode == C4350) {
;
	CMP	EDI,BYTE 040H
	JNE	NEAR	L_9
;
; Line 125:			regs.h.ax = 0x1112;
;
	MOV	WORD [ESI+01CH],01112H
;
; Line 126:			regs.b.bl = 0;
;
	MOV	BYTE [ESI+010H],00H
;
; Line 127:			dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 128:			regs.h.ax = 0x1103;
;
	MOV	WORD [ESI+01CH],01103H
;
; Line 129:			regs.b.bl = 0;
;
	MOV	BYTE [ESI+010H],00H
;
; Line 130:			dpmi_simulate_real_interrupt(0x10,&regs);
;
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	_dpmi_simulate_real_interrupt
	ADD	ESP,BYTE 08H
;
; Line 131:		}
;
L_9:
;
; Line 132:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_inportb]
;
; Line 134:	{
;
_inportb:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 135:		asm  mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 136:		asm  in al,dx;
;
	IN	AL,DX
;
; Line 137:		asm  movzx eax,al;
;
	MOVZX	EAX,AL
;
; Line 138:		return _EAX;
;
L_11:
	POP	EBP
	RET
[GLOBAL	_inport]
;
; Line 141:	{
;
_inport:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 142:		asm  mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 143:		asm  in ax,dx;
;
	IN	AX,DX
;
; Line 144:		asm  movzx eax,ax;
;
	MOVZX	EAX,AX
;
; Line 145:		return _EAX;
;
L_12:
	POP	EBP
	RET
[GLOBAL	_inp]
;
; Line 148:	{
;
_inp:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 149:		asm  mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 150:		asm  in ax,dx;
;
	IN	AX,DX
;
; Line 151:		asm  movsx eax,ax;
;
	MOVSX	EAX,AX
;
; Line 152:		return _EAX;
;
L_13:
	POP	EBP
	RET
[GLOBAL	_inpw]
;
; Line 155:	{
;
_inpw:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 156:		asm  mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 157:		asm  in ax,dx;
;
	IN	AX,DX
;
; Line 158:		asm  movzx eax,ax;
;
	MOVZX	EAX,AX
;
; Line 159:		return _EAX;
;
L_14:
	POP	EBP
	RET
[GLOBAL	_outportb]
;
; Line 162:	{
;
_outportb:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 163:		asm mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 164:		asm mov al,[__value];
;
	MOV	AL,BYTE [EBP+0CH]
;
; Line 165:		asm out dx,al;
;
	OUT	DX,AL
;
; Line 166:	}
;
	POP	EBP
	RET
[GLOBAL	_outport]
;
; Line 168:	{
;
_outport:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 169:		asm mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 170:		asm mov ax,word ptr [__value];
;
	MOV	AX,WORD [EBP+0CH]
;
; Line 171:		asm out dx,ax;
;
	OUT	DX,AX
;
; Line 172:	}
;
	POP	EBP
	RET
[GLOBAL	_outp]
;
; Line 174:	{
;
_outp:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 175:		asm mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 176:		asm mov al,byte ptr [__value];
;
	MOV	AL,BYTE [EBP+0CH]
;
; Line 177:		asm out dx,al;
;
	OUT	DX,AL
;
; Line 178:		return __value;
;
	MOV	EAX,DWORD [EBP+0CH]
L_15:
	POP	EBP
	RET
[GLOBAL	_outpw]
;
; Line 181:	{
;
_outpw:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 182:		asm mov edx,[__portid];
;
	MOV	EDX,DWORD [EBP+08H]
;
; Line 183:		asm mov ax,word ptr [__value];
;
	MOV	AX,WORD [EBP+0CH]
;
; Line 184:		asm out dx,ax;
;
	OUT	DX,AX
;
; Line 185:		return __value;
;
	MOV	EAX,DWORD [EBP+0CH]
L_16:
	POP	EBP
	RET
;
; Line 188:	{
;
_putthechar:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
;
; Line 189:		int pos = (y *the_info.screenwidth + x)*2 + screenbase;
;
	MOVZX	EAX,BYTE [08H+_the_info]
	IMUL	EAX,DWORD [EBP+0CH]
	ADD	EAX,DWORD [EBP+08H]
	SAL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	MOV	DWORD [EBP+0FFFFFFF8H],EAX
;
; Line 190:		short value = (the_info.attribute << 8) + chr;
;
	MOVZX	EAX,BYTE [04H+_the_info]
	SAL	EAX,08H
	ADD	EAX,DWORD [EBP+010H]
	MOV	WORD [EBP+0FFFFFFFEH],AX
;
; Line 191:		asm push fs;
;
	PUSH	FS
;
; Line 192:		asm mov ax,[realdata];
;
	MOV	AX,WORD [_realdata]
;
; Line 193:		asm mov fs,ax;
;
	MOV	FS,AX
;
; Line 194:		asm mov ecx,[pos];
;
	MOV	ECX,DWORD [EBP+0FFFFFFF8H]
;
; Line 195:	  asm mov ax,[value];
;
	MOV	AX,WORD [EBP+0FFFFFFFEH]
;
; Line 196:		asm mov word ptr fs:[ecx],ax;
;
	MOV	WORD [FS:ECX],AX
;
; Line 197:		asm pop fs;
;
	POP	FS
;
; Line 198:	}
;
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 200:	{
;
_scrollup:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 0CH
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _the_info
;
; Line 203:		asm push fs;
;
	PUSH	FS
;
; Line 204:		asm mov ax,[realdata];
;
	MOV	AX,WORD [_realdata]
;
; Line 205:		asm mov fs,ax;
;
	MOV	FS,AX
	MOVZX	EAX,BYTE [ESI+01H]
	ADD	EAX,DWORD [EBP+08H]
	INC	EAX
	MOV	DWORD [EBP+0FFFFFFF4H],EAX
	JMP	L_19
L_17:
;
; Line 207:			p1 = screenbase + (y* the_info.screenwidth + the_info.winleft)*2;
;
	MOVZX	EAX,BYTE [ESI+08H]
	IMUL	EAX,DWORD [EBP+0FFFFFFF4H]
	MOVZX	ECX,BYTE [ESI+00H]
	ADD	EAX,ECX
	SAL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	MOV	DWORD [EBP+0FFFFFFF8H],EAX
;
; Line 208:			p2 = p1 + the_info.screenwidth*2;
;
	MOVZX	EAX,BYTE [ESI+08H]
	SHL	EAX,01H
	ADD	EAX,DWORD [EBP+0FFFFFFF8H]
	MOV	DWORD [EBP+0FFFFFFFCH],EAX
	MOVZX	EAX,BYTE [ESI+00H]
	MOV	EBX,EAX
	JMP	L_23
L_21:
;
; Line 210:				asm mov eax,[p1];
;
	MOV	EAX,DWORD [EBP+0FFFFFFF8H]
;
; Line 211:				asm mov ecx,[p2];
;
	MOV	ECX,DWORD [EBP+0FFFFFFFCH]
;
; Line 212:				asm mov dx,word ptr fs:[ecx];
;
	MOV	DX,WORD [FS:ECX]
;
; Line 213:				asm mov word ptr fs:[eax],dx;
;
	MOV	WORD [FS:EAX],DX
;
; Line 214:				p1+=2;
;
	ADD	DWORD [EBP+0FFFFFFF8H],BYTE 02H
;
; Line 215:				p2+=2;
;
	ADD	DWORD [EBP+0FFFFFFFCH],BYTE 02H
;
; Line 216:			}
;
;
; Line 209:			for (x=the_info.winleft; x < the_info.winright; x++) {
;
L_22:
	INC	EBX
L_23:
	MOVZX	EAX,BYTE [ESI+02H]
	CMP	EBX,EAX
	JB	NEAR	L_21
L_24:
;
; Line 217:		}
;
;
; Line 206:		for (y=ytop+1+the_info.wintop; y <the_info.winbottom; y++) {
;
L_18:
	INC	DWORD [EBP+0FFFFFFF4H]
L_19:
	MOVZX	EAX,BYTE [ESI+03H]
	CMP	DWORD [EBP+0FFFFFFF4H],EAX
	JB	NEAR	L_17
L_20:
;
; Line 218:		asm pop fs
;
	POP	FS
;
; Line 219:		y = the_info.attribute;
;
	MOVZX	EAX,BYTE [ESI+04H]
	MOV	DWORD [EBP+0FFFFFFF4H],EAX
;
; Line 220:		the_info.attribute = the_info.normattr;
;
	MOV	AL,BYTE [ESI+05H]
	MOV	BYTE [ESI+04H],AL
	MOVZX	EAX,BYTE [ESI+00H]
	MOV	EBX,EAX
	JMP	L_27
L_25:
;
; Line 222:			putthechar(x,the_info.winbottom-1,' ');
;
	PUSH	BYTE 020H
	MOVZX	EAX,BYTE [ESI+03H]
	DEC	EAX
	PUSH	EAX
	PUSH	EBX
	CALL	_putthechar
	ADD	ESP,BYTE 0CH
;
; Line 221:		for (x=the_info.winleft; x < the_info.winright; x++)
;
L_26:
	INC	EBX
L_27:
	MOVZX	EAX,BYTE [ESI+02H]
	CMP	EBX,EAX
	JB	NEAR	L_25
L_28:
;
; Line 223:		the_info.attribute = y;
;
	MOV	AL,BYTE [EBP+0FFFFFFF4H]
	MOV	BYTE [ESI+04H],AL
;
; Line 224:	}
;
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 226:	{
;
_scrolldown:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _the_info
;
; Line 229:		asm push fs;
;
	PUSH	FS
;
; Line 230:		asm mov ax,[realdata];
;
	MOV	AX,WORD [_realdata]
;
; Line 231:		asm mov fs,ax;
;
	MOV	FS,AX
	MOVZX	EAX,BYTE [ESI+03H]
	DEC	EAX
	MOV	EDI,EAX
	JMP	L_31
L_29:
;
; Line 233:			p1 = (y* the_info.screenwidth + the_info.winleft)*2 + screenbase;
;
	MOVZX	EAX,BYTE [ESI+08H]
	IMUL	EAX,EDI
	MOVZX	ECX,BYTE [ESI+00H]
	ADD	EAX,ECX
	SAL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	MOV	DWORD [EBP+0FFFFFFF8H],EAX
;
; Line 234:			p2 = p1 - the_info.screenwidth*2;
;
	MOVZX	EAX,BYTE [ESI+08H]
	SHL	EAX,01H
	MOV	ECX,DWORD [EBP+0FFFFFFF8H]
	SUB	ECX,EAX
	MOV	DWORD [EBP+0FFFFFFFCH],ECX
	MOVZX	EAX,BYTE [ESI+00H]
	MOV	EBX,EAX
	JMP	L_35
L_33:
;
; Line 236:				asm mov eax,[p1];
;
	MOV	EAX,DWORD [EBP+0FFFFFFF8H]
;
; Line 237:				asm mov ecx,[p2];
;
	MOV	ECX,DWORD [EBP+0FFFFFFFCH]
;
; Line 238:				asm mov dx,word ptr fs:[ecx];
;
	MOV	DX,WORD [FS:ECX]
;
; Line 239:				asm mov word ptr fs:[eax],dx;
;
	MOV	WORD [FS:EAX],DX
;
; Line 240:				p1+=2;
;
	ADD	DWORD [EBP+0FFFFFFF8H],BYTE 02H
;
; Line 241:				p2+=2;
;
	ADD	DWORD [EBP+0FFFFFFFCH],BYTE 02H
;
; Line 242:			}
;
;
; Line 235:			for (x=the_info.winleft; x < the_info.winright; x++) {
;
L_34:
	INC	EBX
L_35:
	MOVZX	EAX,BYTE [ESI+02H]
	CMP	EBX,EAX
	JB	NEAR	L_33
L_36:
;
; Line 243:		}
;
;
; Line 232:		for (y = the_info.winbottom-1; y>ytop+the_info.wintop; y--) {
;
L_30:
	DEC	EDI
L_31:
	MOVZX	EAX,BYTE [ESI+01H]
	ADD	EAX,DWORD [EBP+08H]
	CMP	EDI,EAX
	JG	NEAR	L_29
L_32:
;
; Line 244:		asm pop fs;
;
	POP	FS
	MOVZX	EAX,BYTE [ESI+00H]
	MOV	EBX,EAX
	JMP	L_39
L_37:
;
; Line 246:			putthechar(x,ytop - the_info.wintop,' ');
;
	PUSH	BYTE 020H
	MOVZX	EAX,BYTE [ESI+01H]
	MOV	ECX,DWORD [EBP+08H]
	SUB	ECX,EAX
	PUSH	ECX
	PUSH	EBX
	CALL	_putthechar
	ADD	ESP,BYTE 0CH
;
; Line 245:		for (x=the_info.winleft; x < the_info.winright; x++)
;
L_38:
	INC	EBX
L_39:
	MOVZX	EAX,BYTE [ESI+02H]
	CMP	EBX,EAX
	JB	NEAR	L_37
L_40:
;
; Line 247:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_clreol]
;
; Line 250:	{
;
_clreol:
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _the_info
	MOV	AL,BYTE [ESI+09H]
	ADD	AL,BYTE [ESI+00H]
	MOVZX	EAX,AL
	MOV	EBX,EAX
	JMP	L_43
L_41:
;
; Line 253:			putthechar(x,the_info.cury,' ');
;
	PUSH	BYTE 020H
	MOVZX	EAX,BYTE [ESI+0AH]
	PUSH	EAX
	PUSH	EBX
	CALL	_putthechar
	ADD	ESP,BYTE 0CH
;
; Line 252:		for (x=the_info.curx+ the_info.winleft; x < the_info.winright; x++)
;
L_42:
	INC	EBX
L_43:
	MOVZX	EAX,BYTE [ESI+02H]
	CMP	EBX,EAX
	JB	NEAR	L_41
L_44:
;
; Line 254:	}
;
	POP	ESI
	POP	EBX
	RET
[GLOBAL	_clrscr]
;
; Line 256:	{
;
_clrscr:
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD _the_info
	MOVZX	EAX,BYTE [EDI+00H]
	MOV	ESI,EAX
	JMP	L_47
L_45:
	MOVZX	EAX,BYTE [EDI+01H]
	MOV	EBX,EAX
	JMP	L_51
L_49:
;
; Line 260:				putthechar(x,y,' ');
;
	PUSH	BYTE 020H
	PUSH	EBX
	PUSH	ESI
	CALL	_putthechar
	ADD	ESP,BYTE 0CH
;
; Line 259:			for (y  = the_info.wintop; y < the_info.winbottom; y++)
;
L_50:
	INC	EBX
L_51:
	MOVZX	EAX,BYTE [EDI+03H]
	CMP	EBX,EAX
	JB	NEAR	L_49
L_52:
;
; Line 258:		for (x=the_info.winleft; x < the_info.winright; x++)
;
L_46:
	INC	ESI
L_47:
	MOVZX	EAX,BYTE [EDI+02H]
	CMP	ESI,EAX
	JB	NEAR	L_45
L_48:
;
; Line 261:		the_info.curx = 0;
;
	MOV	BYTE [EDI+09H],00H
;
; Line 262:		the_info.cury = 0;
;
	MOV	BYTE [EDI+0AH],00H
;
; Line 263:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	RET
[GLOBAL	_gotoxy]
;
; Line 265:	{
;
_gotoxy:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 266:		the_info.curx = __x;
;
	MOV	AL,BYTE [EBP+08H]
	MOV	BYTE [09H+_the_info],AL
;
; Line 267:		the_info.cury = __y;
;
	MOV	AL,BYTE [EBP+0CH]
	MOV	BYTE [0AH+_the_info],AL
;
; Line 268:	}
;
	POP	EBP
	RET
[GLOBAL	_getche]
;
; Line 270:	{
;
_getche:
	PUSH	EBX
;
; Line 271:		int inch = getch();
;
	CALL	_getch
	MOV	EBX,EAX
;
; Line 272:		putch(inch);
;
	PUSH	EBX
	CALL	_putch
	POP	ECX
;
; Line 273:		return inch;
;
	MOV	EAX,EBX
L_53:
	POP	EBX
	RET
[GLOBAL	_putch]
;
; Line 276:	{
;
_putch:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _the_info
	MOV	EBX,DWORD [EBP+08H]
;
; Line 277:		switch (__c) {
;
	CMP	EBX,DWORD 0AH
	JE	NEAR	L_60
	JG	NEAR	L_63
	CMP	EBX,DWORD 08H
	JE	NEAR	L_56
	JG	SHORT	L_64
	CMP	EBX,DWORD 07H
	JE	NEAR	L_59
	JMP	L_54
L_64:
	CMP	EBX,DWORD 09H
	JE	NEAR	L_61
	JMP	L_54
L_63:
	CMP	EBX,DWORD 07FH
	JE	SHORT	L_57
	JG	NEAR	L_54
	CMP	EBX,DWORD 0DH
	JE	SHORT	L_58
	JMP	L_54
L_56:
L_57:
;
; Line 280:				the_info.curx--;
;
	DEC	BYTE [ESI+09H]
;
; Line 281:				break;
;
	JMP	L_55
L_58:
;
; Line 283:				the_info.curx = 0;
;
	MOV	BYTE [ESI+09H],00H
;
; Line 284:				break;
;
	JMP	L_55
L_59:
;
; Line 286:				fputc(__c,(_pstreams[1]));
;
	PUSH	DWORD [04H+__pstreams]
	PUSH	EBX
	CALL	_fputc
	ADD	ESP,BYTE 08H
;
; Line 287:				break;
;
	JMP	L_55
L_60:
;
; Line 289:				the_info.curx = 0;
;
	MOV	BYTE [ESI+09H],00H
;
; Line 290:				if (++the_info.cury >= the_info.winbottom - the_info.winleft) {
;
	MOV	AL,BYTE [ESI+03H]
	SUB	AL,BYTE [ESI+00H]
	INC	BYTE [ESI+0AH]
	CMP	BYTE [ESI+0AH],AL
	JB	SHORT	L_65
;
; Line 291:					the_info.cury--;
;
	DEC	BYTE [ESI+0AH]
;
; Line 292:					scrollup(0);
;
	PUSH	BYTE 00H
	CALL	_scrollup
	POP	ECX
;
; Line 293:				}
;
L_65:
;
; Line 294:				break;
;
	JMP	L_55
L_61:
;
; Line 296:				the_info.curx += 8;
;
	ADD	BYTE [ESI+09H],BYTE 08H
;
; Line 297:				the_info.curx &= 0xf8;
;
	AND	BYTE [ESI+09H],0F8H
;
; Line 298:				if (the_info.curx >= the_info.winright - the_info.winleft) {
;
	MOV	AL,BYTE [ESI+02H]
	SUB	AL,BYTE [ESI+00H]
	CMP	BYTE [ESI+09H],AL
	JB	NEAR	L_67
;
; Line 299:					the_info.curx = 0;
;
	MOV	BYTE [ESI+09H],00H
;
; Line 300:					if (++the_info.cury >= the_info.winbottom - the_info.winleft) {
;
	MOV	AL,BYTE [ESI+03H]
	SUB	AL,BYTE [ESI+00H]
	INC	BYTE [ESI+0AH]
	CMP	BYTE [ESI+0AH],AL
	JB	SHORT	L_69
;
; Line 301:						the_info.cury--;
;
	DEC	BYTE [ESI+0AH]
;
; Line 302:						scrollup(0);
;
	PUSH	BYTE 00H
	CALL	_scrollup
	POP	ECX
;
; Line 303:					}
;
L_69:
;
; Line 304:				}
;
L_67:
;
; Line 305:				break;
;
	JMP	L_55
L_54:
;
; Line 307:				putthechar(the_info.curx + the_info.winleft,
;
	PUSH	EBX
	MOV	AL,BYTE [ESI+0AH]
	ADD	AL,BYTE [ESI+01H]
	MOVZX	EAX,AL
	PUSH	EAX
	MOV	AL,BYTE [ESI+09H]
	ADD	AL,BYTE [ESI+00H]
	MOVZX	EAX,AL
	PUSH	EAX
	CALL	_putthechar
	ADD	ESP,BYTE 0CH
;
; Line 310:				if (++the_info.curx >= the_info.winright - the_info.winleft) {
;
	MOV	AL,BYTE [ESI+02H]
	SUB	AL,BYTE [ESI+00H]
	INC	BYTE [ESI+09H]
	CMP	BYTE [ESI+09H],AL
	JB	NEAR	L_71
;
; Line 311:					the_info.curx = 0;
;
	MOV	BYTE [ESI+09H],00H
;
; Line 312:					if (++the_info.cury >= the_info.winbottom - the_info.winleft) {
;
	MOV	AL,BYTE [ESI+03H]
	SUB	AL,BYTE [ESI+00H]
	INC	BYTE [ESI+0AH]
	CMP	BYTE [ESI+0AH],AL
	JB	SHORT	L_73
;
; Line 313:						the_info.cury--;
;
	DEC	BYTE [ESI+0AH]
;
; Line 314:						scrollup(0);
;
	PUSH	BYTE 00H
	CALL	_scrollup
	POP	ECX
;
; Line 315:					}
;
L_73:
;
; Line 316:				}
;
L_71:
;
; Line 317:				break;
;
L_55:
;
; Line 319:	}
;
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_wherex]
;
; Line 321:	{
;
_wherex:
;
; Line 322:		return the_info.curx;
;
	MOVZX	EAX,BYTE [09H+_the_info]
L_75:
	RET
[GLOBAL	_wherey]
;
; Line 325:	{
;
_wherey:
;
; Line 326:		return the_info.cury;
;
	MOVZX	EAX,BYTE [0AH+_the_info]
L_76:
	RET
[GLOBAL	_delline]
;
; Line 331:	{
;
_delline:
;
; Line 332:		scrollup(the_info.cury);
;
	MOVZX	EAX,BYTE [0AH+_the_info]
	PUSH	EAX
	CALL	_scrollup
	POP	ECX
;
; Line 333:	}
;
	RET
[GLOBAL	_gettext]
;
; Line 337:	{
;
_gettext:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 0CH
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+08H]
;
; Line 339:		short *q = __destin;
;
	MOV	EAX,DWORD [EBP+018H]
	MOV	DWORD [EBP+0FFFFFFFCH],EAX
;
; Line 340:		__left += the_info.winleft;
;
	MOVZX	EAX,BYTE [_the_info]
	ADD	EDI,EAX
;
; Line 341:		__top += the_info.wintop;
;
	MOVZX	EAX,BYTE [01H+_the_info]
	ADD	DWORD [EBP+0CH],EAX
;
; Line 342:		__right += the_info.winleft;
;
	MOVZX	EAX,BYTE [_the_info]
	ADD	DWORD [EBP+010H],EAX
;
; Line 343:		__bottom += the_info.wintop;
;
	MOVZX	EAX,BYTE [01H+_the_info]
	ADD	DWORD [EBP+014H],EAX
;
; Line 344:		asm push fs
;
	PUSH	FS
;
; Line 345:		asm mov fs,[realdata]
;
	MOV	FS,WORD [_realdata]
	MOV	EBX,DWORD [EBP+0CH]
	JMP	L_79
L_77:
;
; Line 349:			pos = (y *the_info.screenwidth + __left)*2 + screenbase;
;
	MOVZX	EAX,BYTE [08H+_the_info]
	IMUL	EAX,EBX
	ADD	EAX,EDI
	SAL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	MOV	DWORD [EBP+0FFFFFFF4H],EAX
	MOV	ESI,EDI
	JMP	L_83
L_81:
;
; Line 351:				asm mov ecx,[pos];
;
	MOV	ECX,DWORD [EBP+0FFFFFFF4H]
;
; Line 352:				asm inc [pos];
;
	INC	DWORD [EBP+0FFFFFFF4H]
;
; Line 353:				asm inc [pos];
;
	INC	DWORD [EBP+0FFFFFFF4H]
;
; Line 354:				asm mov ax,word ptr fs:[ecx];
;
	MOV	AX,WORD [FS:ECX]
;
; Line 355:	        		asm mov [value],ax;
;
	MOV	WORD [EBP+0FFFFFFFAH],AX
;
; Line 356:				*q++ = value;
;
	MOV	EAX,DWORD [EBP+0FFFFFFFCH]
	ADD	DWORD [EBP+0FFFFFFFCH],BYTE 02H
	MOV	CX,WORD [EBP+0FFFFFFFAH]
	MOV	WORD [EAX+00H],CX
;
; Line 357:			}
;
;
; Line 350:			for (x= __left; x < __right; x++) {
;
L_82:
	INC	ESI
L_83:
	CMP	ESI,DWORD [EBP+010H]
	JL	NEAR	L_81
L_84:
;
; Line 358:		}
;
;
; Line 346:		for (y=__top; y < __bottom; y++) {
;
L_78:
	INC	EBX
L_79:
	CMP	EBX,DWORD [EBP+014H]
	JL	NEAR	L_77
L_80:
;
; Line 359:		asm pop fs;
;
	POP	FS
;
; Line 360:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_gettextinfo]
;
; Line 362:	{
;
_gettextinfo:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 363:		*__r = the_info;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _the_info
	LEA	EDI,[EAX+00H]
	CLD
	MOV	ECX,02H
	REP	MOVSD
	MOVSW
	MOVSB
	POP	EDI
	POP	ESI
;
; Line 364:	}
;
	POP	EBP
	RET
[GLOBAL	_highvideo]
;
; Line 366:	{
;
_highvideo:
;
; Line 367:		the_info.attribute |= 128  ;
;
	BTS	DWORD [04H+_the_info],07H
;
; Line 368:	}
;
	RET
[GLOBAL	_insline]
;
; Line 370:	{
;
_insline:
;
; Line 371:		scrolldown(the_info.cury);
;
	MOVZX	EAX,BYTE [0AH+_the_info]
	PUSH	EAX
	CALL	_scrolldown
	POP	ECX
;
; Line 372:	}
;
	RET
[GLOBAL	_lowvideo]
;
; Line 374:	{
;
_lowvideo:
;
; Line 375:		the_info.attribute &= ~128  ;
;
	BTR	DWORD [04H+_the_info],07H
;
; Line 376:	}
;
	RET
[GLOBAL	_normvideo]
;
; Line 381:	{
;
_normvideo:
;
; Line 382:		the_info.attribute = the_info.normattr;
;
	MOV	AL,BYTE [05H+_the_info]
	MOV	BYTE [04H+_the_info],AL
;
; Line 383:	}
;
	RET
[GLOBAL	_puttext]
;
; Line 387:	{
;
_puttext:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 0CH
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+08H]
;
; Line 389:		short *q = __source;
;
	MOV	EAX,DWORD [EBP+018H]
	MOV	DWORD [EBP+0FFFFFFFCH],EAX
;
; Line 390:		__left += the_info.winleft;
;
	MOVZX	EAX,BYTE [_the_info]
	ADD	EDI,EAX
;
; Line 391:		__top += the_info.wintop;
;
	MOVZX	EAX,BYTE [01H+_the_info]
	ADD	DWORD [EBP+0CH],EAX
;
; Line 392:		__right += the_info.winleft;
;
	MOVZX	EAX,BYTE [_the_info]
	ADD	DWORD [EBP+010H],EAX
;
; Line 393:		__bottom += the_info.wintop;
;
	MOVZX	EAX,BYTE [01H+_the_info]
	ADD	DWORD [EBP+014H],EAX
;
; Line 394:		asm push fs;
;
	PUSH	FS
;
; Line 395:		asm mov fs,[realdata]
;
	MOV	FS,WORD [_realdata]
	MOV	EBX,DWORD [EBP+0CH]
	JMP	L_87
L_85:
;
; Line 399:			pos = (y *the_info.screenwidth + __left)*2 + screenbase;
;
	MOVZX	EAX,BYTE [08H+_the_info]
	IMUL	EAX,EBX
	ADD	EAX,EDI
	SAL	EAX,01H
	ADD	EAX,DWORD [_screenbase]
	MOV	DWORD [EBP+0FFFFFFF4H],EAX
	MOV	ESI,EDI
	JMP	L_91
L_89:
;
; Line 401:				value = *q++;
;
	MOV	EAX,DWORD [EBP+0FFFFFFFCH]
	ADD	DWORD [EBP+0FFFFFFFCH],BYTE 02H
	MOV	AX,WORD [EAX+00H]
	MOV	WORD [EBP+0FFFFFFFAH],AX
;
; Line 402:				asm mov ecx,[pos]
;
	MOV	ECX,DWORD [EBP+0FFFFFFF4H]
;
; Line 403:				asm inc [pos]
;
	INC	DWORD [EBP+0FFFFFFF4H]
;
; Line 404:				asm inc [pos]
;
	INC	DWORD [EBP+0FFFFFFF4H]
;
; Line 405:	        		asm mov ax,[value]
;
	MOV	AX,WORD [EBP+0FFFFFFFAH]
;
; Line 406:				asm mov word ptr fs:[ecx],ax
;
	MOV	WORD [FS:ECX],AX
;
; Line 407:			}
;
;
; Line 400:			for (x= __left; x < __right; x++) {
;
L_90:
	INC	ESI
L_91:
	CMP	ESI,DWORD [EBP+010H]
	JL	NEAR	L_89
L_92:
;
; Line 408:		}
;
;
; Line 396:		for (y=__top; y < __bottom; y++) {
;
L_86:
	INC	EBX
L_87:
	CMP	EBX,DWORD [EBP+014H]
	JL	NEAR	L_85
L_88:
;
; Line 409:		asm pop fs
;
	POP	FS
;
; Line 410:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_textattr]
;
; Line 412:	{
;
_textattr:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 413:		the_info.attribute = __newattr;
;
	MOV	AL,BYTE [EBP+08H]
	MOV	BYTE [04H+_the_info],AL
;
; Line 414:	}
;
	POP	EBP
	RET
[GLOBAL	_textbackground]
;
; Line 416:	{
;
_textbackground:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 417:		the_info.attribute &= 0xf;
;
	AND	BYTE [04H+_the_info],BYTE 0FH
;
; Line 418:		the_info.attribute |= __newcolor << 4;
;
	MOV	EAX,DWORD [EBP+08H]
	SAL	EAX,04H
	OR	BYTE [04H+_the_info],AL
;
; Line 419:	}
;
	POP	EBP
	RET
[GLOBAL	_textcolor]
;
; Line 421:	{
;
_textcolor:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 422:		the_info.attribute &= 0xf0;
;
	AND	BYTE [04H+_the_info],0F0H
;
; Line 423:		the_info.attribute |= __newcolor & 0xf;
;
	MOV	EAX,DWORD [EBP+08H]
	AND	EAX,BYTE 0FH
	OR	BYTE [04H+_the_info],AL
;
; Line 424:	}
;
	POP	EBP
	RET
;
; Line 426:	{
;
_textini:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _the_info
	MOV	EBX,DWORD [EBP+08H]
	MOV	EDI,DWORD _ulline
;
; Line 427:		the_info.winleft = the_info.wintop = 0;
;
	MOV	BYTE [ESI+01H],00H
	MOV	BYTE [ESI+00H],00H
;
; Line 428:		the_info.screenheight = the_info.winbottom = 25;
;
	MOV	BYTE [ESI+03H],019H
	MOV	BYTE [ESI+07H],019H
;
; Line 429:		the_info.currmode = __newmode;
;
	MOV	BYTE [ESI+06H],BL
;
; Line 430:		screenbase = 0xb8000;
;
	MOV	DWORD [_screenbase],0B8000H
;
; Line 431:		chrheight = 16;
;
	MOV	DWORD [_chrheight],010H
;
; Line 432:		baseport = 0x3d4;
;
	MOV	DWORD [_baseport],03D4H
;
; Line 433:		ulline = 12;
;
	MOV	DWORD [EDI+00H],0CH
;
; Line 434:		switch (__newmode) {
;
	CMP	EBX,DWORD 03H
	JE	NEAR	L_99
	JG	NEAR	L_102
	CMP	EBX,DWORD 01H
	JE	NEAR	L_96
	JG	SHORT	L_103
	CMP	EBX,DWORD 00H
	JE	NEAR	L_95
	JMP	L_93
L_103:
	CMP	EBX,DWORD 02H
	JE	NEAR	L_98
	JMP	L_93
L_102:
	CMP	EBX,DWORD 040H
	JE	NEAR	L_101
	JG	NEAR	L_93
	CMP	EBX,DWORD 07H
	JE	NEAR	L_100
	JMP	L_93
L_95:
;
; Line 436:				ulline = 7;
;
	MOV	DWORD [EDI+00H],07H
L_96:
;
; Line 438:				the_info.winright = 40;
;
	MOV	BYTE [ESI+02H],028H
;
; Line 439:				the_info.screenwidth = 40;
;
	MOV	BYTE [ESI+08H],028H
;
; Line 440:				biosmode(__newmode);
;
	PUSH	EBX
	CALL	_biosmode
	POP	ECX
;
; Line 441:				break;
;
	JMP	L_94
L_93:
L_98:
;
; Line 444:				ulline = 7;
;
	MOV	DWORD [EDI+00H],07H
L_99:
;
; Line 446:				the_info.winright = 80;
;
	MOV	BYTE [ESI+02H],050H
;
; Line 447:				the_info.screenwidth = 80;
;
	MOV	BYTE [ESI+08H],050H
;
; Line 448:				break;
;
	JMP	L_94
L_100:
;
; Line 450:				the_info.winright = 80;
;
	MOV	BYTE [ESI+02H],050H
;
; Line 451:				the_info.screenwidth = 80;
;
	MOV	BYTE [ESI+08H],050H
;
; Line 452:				screenbase = 0xb0000;
;
	MOV	DWORD [_screenbase],0B0000H
;
; Line 453:				baseport = 0x3b4;
;
	MOV	DWORD [_baseport],03B4H
;
; Line 454:				break;
;
	JMP	L_94
L_101:
;
; Line 456:				the_info.winright = 80;
;
	MOV	BYTE [ESI+02H],050H
;
; Line 457:				the_info.winbottom = 50;
;
	MOV	BYTE [ESI+03H],032H
;
; Line 458:				chrheight = 8;
;
	MOV	DWORD [_chrheight],08H
;
; Line 460:				break;
;
L_94:
;
; Line 462:	}
;
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_textmode]
;
; Line 464:	{
;
_textmode:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	EBX,DWORD [EBP+08H]
	MOV	ESI,DWORD _the_info
;
; Line 465:		if (__newmode == LASTMODE)
;
	CMP	EBX,BYTE 0FFFFFFFFH
	JNE	SHORT	L_104
;
; Line 466:			__newmode = the_info.currmode;
;
	MOVZX	EAX,BYTE [ESI+06H]
	MOV	EBX,EAX
L_104:
;
; Line 467:		the_info.curx = the_info.cury = 0;
;
	MOV	BYTE [ESI+0AH],00H
	MOV	BYTE [ESI+09H],00H
;
; Line 468:		textini(__newmode);
;
	PUSH	EBX
	CALL	_textini
	POP	ECX
;
; Line 469:		biosmode(__newmode);
;
	PUSH	EBX
	CALL	_biosmode
	POP	ECX
;
; Line 470:	}
;
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_window]
;
; Line 472:	{
;
_window:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD _the_info
;
; Line 473:		the_info.winleft = __left;
;
	MOV	AL,BYTE [EBP+08H]
	MOV	BYTE [ESI+00H],AL
;
; Line 474:		the_info.winright = __right;
;
	MOV	AL,BYTE [EBP+010H]
	MOV	BYTE [ESI+02H],AL
;
; Line 475:		the_info.wintop = __top;
;
	MOV	AL,BYTE [EBP+0CH]
	MOV	BYTE [ESI+01H],AL
;
; Line 476:		the_info.winbottom = __bottom;
;
	MOV	AL,BYTE [EBP+014H]
	MOV	BYTE [ESI+03H],AL
;
; Line 477:		the_info.curx = 0;
;
	MOV	BYTE [ESI+09H],00H
;
; Line 478:		the_info.cury = 0;
;
	MOV	BYTE [ESI+0AH],00H
;
; Line 479:	}
;
	POP	ESI
	POP	EBP
	RET
[GLOBAL	__setcursortype]
;
; Line 482:	{
;
__setcursortype:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _baseport
	MOV	EBX,DWORD [EBP+08H]
;
; Line 483:		the_info.currmode = __cur_t;
;
	MOV	BYTE [06H+_the_info],BL
;
; Line 484:		switch (__cur_t) {
;
	CMP	EBX,DWORD 00H
	JE	SHORT	L_108
	CMP	EBX,DWORD 01H
	JE	NEAR	L_109
	CMP	EBX,DWORD 02H
	JE	NEAR	L_110
	JMP	L_106
L_108:
;
; Line 486:				outp(baseport,10);
;
	MOV	AL,0AH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 487:				outp(baseport+1,chrheight);
;
	MOV	EAX,DWORD [_chrheight]
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 488:				outp(baseport,11);
;
	MOV	AL,0BH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 489:				outp(baseport+1,0);
;
	MOV	AL,00H
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 490:				break;
;
	JMP	L_107
L_109:
;
; Line 492:				outp(baseport,10);
;
	MOV	AL,0AH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 493:				outp(baseport+1,0);
;
	MOV	AL,00H
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 494:				outp(baseport,11);
;
	MOV	AL,0BH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 495:				outp(baseport+1,chrheight);
;
	MOV	EAX,DWORD [_chrheight]
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 496:				break;
;
	JMP	L_107
L_110:
;
; Line 498:				outp(baseport,10);
;
	MOV	AL,0AH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 499:				outp(baseport+1,ulline-1);
;
	MOV	EAX,DWORD [_ulline]
	DEC	EAX
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 500:				outp(baseport,11);
;
	MOV	AL,0BH
	MOV	DX,WORD [ESI+00H]
	OUT	DX,AL
;
; Line 501:				outp(baseport+1,ulline);
;
	MOV	EAX,DWORD [_ulline]
	MOV	ECX,DWORD [ESI+00H]
	INC	ECX
	MOV	EDX,ECX
	OUT	DX,AL
;
; Line 502:				break;
;
L_106:
L_107:
;
; Line 504:	}
;
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_cgets]
;
; Line 506:	{
;
_cgets:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+08H]
;
; Line 507:		char *q = __str;
;
	MOV	ESI,EDI
	JMP	L_111
L_113:
;
; Line 510:			*q++ = val;
;
	MOV	EAX,ESI
	INC	ESI
	MOV	BYTE [EAX+00H],BL
L_111:
;
; Line 509:		while ((val = getche()) != '\r')
;
	CALL	_getche
	MOV	EBX,EAX
	CMP	EAX,BYTE 0DH
	JNE	SHORT	L_113
L_112:
;
; Line 511:		*q++ = 0;
;
	MOV	EAX,ESI
	INC	ESI
	MOV	BYTE [EAX+00H],00H
;
; Line 512:		return __str;
;
	MOV	EAX,EDI
L_114:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_cprintf]
;
; Line 515:	{
;
_cprintf:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,0400H
	PUSH	EBX
;
; Line 519:		argptr = (va_list)((char *)(&__format)+sizeof(__format));
;
	LEA	EBX,[EBP+08H]
	ADD	EBX,BYTE 04H
;
; Line 520:		vsprintf( buf,__format, argptr);
;
	PUSH	EBX
	PUSH	DWORD [EBP+08H]
	LEA	EAX,[EBP+0FFFFFC00H]
	PUSH	EAX
	CALL	_vsprintf
	ADD	ESP,BYTE 0CH
;
; Line 522:		cputs(buf);
;
	LEA	EAX,[EBP+0FFFFFC00H]
	PUSH	EAX
	CALL	_cputs
	POP	ECX
;
; Line 523:		return 0;
;
	MOV	EAX,00H
L_115:
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_cputs]
;
; Line 526:	{
;
_cputs:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
	JMP	L_118
L_116:
;
; Line 528:			putch(*__str);
;
	MOVSX	EAX,BYTE [ESI+00H]
	PUSH	EAX
	CALL	_putch
	POP	ECX
;
; Line 529:		}
;
;
; Line 527:		for (; *__str; __str++) {
;
L_117:
	INC	ESI
L_118:
	CMP	BYTE [ESI+00H],BYTE 00H
	JNE	SHORT	L_116
L_119:
;
; Line 530:		return 0;
;
	MOV	EAX,00H
L_120:
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_cscanf]
;
; Line 533:	{
;
_cscanf:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,0100H
	PUSH	EBX
;
; Line 536:		cgets(buf);
;
	LEA	EAX,[EBP+0FFFFFF00H]
	PUSH	EAX
	CALL	_cgets
	POP	ECX
;
; Line 537:		argptr = (va_list)((char *)(&__format)+sizeof(__format));
;
	LEA	EBX,[EBP+08H]
	ADD	EBX,BYTE 04H
;
; Line 538:		vsscanf( buf,__format, argptr);
;
	PUSH	EBX
	PUSH	DWORD [EBP+08H]
	LEA	EAX,[EBP+0FFFFFF00H]
	PUSH	EAX
	CALL	_vsscanf
	ADD	ESP,BYTE 0CH
;
; Line 540:		return 0;
;
	MOV	EAX,00H
L_121:
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_getpass]
;
; Line 543:	{
;
_getpass:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
;
; Line 545:		char *q = passbuf;
;
	LEA	ESI,[L_122]
;
; Line 547:		cputs(__prompt);
;
	PUSH	DWORD [EBP+08H]
	CALL	_cputs
	POP	ECX
;
; Line 548:		inch = getch();
;
	CALL	_getch
	MOV	EBX,EAX
	JMP	L_124
L_126:
;
; Line 550:			switch (inch) {
;
	CMP	EBX,DWORD 08H
	JE	SHORT	L_129
	CMP	EBX,DWORD 07FH
	JE	SHORT	L_130
	JMP	L_127
L_129:
L_130:
;
; Line 553:					if (q == passbuf)
;
	LEA	EAX,[L_122]
	CMP	ESI,EAX
	JNE	SHORT	L_132
;
; Line 554:						fputc(7,(_pstreams[1]));
;
	PUSH	DWORD [04H+__pstreams]
	PUSH	BYTE 07H
	CALL	_fputc
	ADD	ESP,BYTE 08H
	JMP	L_133
L_132:
;
; Line 556:						putch(8);
;
	PUSH	BYTE 08H
	CALL	_putch
	POP	ECX
;
; Line 557:						putch(' ');
;
	PUSH	BYTE 020H
	CALL	_putch
	POP	ECX
;
; Line 558:						putch(8);
;
	PUSH	BYTE 08H
	CALL	_putch
	POP	ECX
;
; Line 559:						q--;
;
	DEC	ESI
;
; Line 560:					}
;
L_133:
;
; Line 561:					break;
;
	JMP	L_128
L_127:
;
; Line 563:					if (inch < 0x20 || inch > 0x7f)
;
	CMP	EBX,BYTE 020H
	JL	SHORT	L_136
	CMP	EBX,BYTE 07FH
	JLE	SHORT	L_134
L_136:
;
; Line 564:						fputc(7,(_pstreams[1]));
;
	PUSH	DWORD [04H+__pstreams]
	PUSH	BYTE 07H
	CALL	_fputc
	ADD	ESP,BYTE 08H
	JMP	L_135
L_134:
;
; Line 566:						cputs("*");
;
	PUSH	DWORD L_123
	CALL	_cputs
	POP	ECX
;
; Line 567:						*q++ = inch;
;
	MOV	EAX,ESI
	INC	ESI
	MOV	BYTE [EAX+00H],BL
;
; Line 568:					}
;
L_135:
;
; Line 569:					break;
;
L_128:
;
; Line 571:			inch = getch();
;
	CALL	_getch
	MOV	EBX,EAX
;
; Line 573:		}
;
L_124:
;
; Line 549:		while (inch != 13) {
;
	CMP	EBX,BYTE 0DH
	JNE	NEAR	L_126
L_125:
;
; Line 574:		*q = 0;
;
	MOV	BYTE [ESI+00H],00H
;
; Line 575:		return passbuf;
;
	LEA	EAX,[L_122]
L_137:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_ungetch]
;
; Line 578:	{
;
_ungetch:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 579:		ungetchar = __ch;
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	DWORD [_ungetchar],EAX
;
; Line 580:	}
;
	POP	EBP
	RET

SECTION _STRING
L_123:
	DB	02AH,00H
SECTION _DATA

_the_info	DB	00H,00H,050H,019H,07H,07H,00H,019H,050H,00H,00H
SECTION _BSS

_screenbase	RESB	04H
[GLOBAL	_chrheight]

_chrheight	RESB	04H
[GLOBAL	_baseport]

_baseport	RESB	04H
[GLOBAL	_ulline]

_ulline	RESB	04H
[GLOBAL	_ungetchar]

_ungetchar	RESB	04H
[GLOBAL	_realdata]

_realdata	RESB	02H

L_122	RESB	0100H
SECTION cstartup
	DD	_conio_init,111
SECTION crundown
	DD	_conio_rundown,19

SECTION _TEXT
[EXTERN	_dpmi_simulate_real_interrupt]
[EXTERN	_vsscanf]
[EXTERN	_dpmi_set_sel_base]
[EXTERN	_dpmi_set_sel_limit]
[EXTERN	_dpmi_free_selector]
[EXTERN	_dpmi_alloc_descriptors]
[EXTERN	_fputc]
[EXTERN	_vsprintf]

SECTION _DATA
[EXTERN	__pstreams]
