	SECTION _TEXT CLASS=CODE USE32
	SECTION _DATA CLASS=DATA USE32
	SECTION _BSS  CLASS=BSS USE32
	SECTION _CONST  CLASS=CONST USE32
	SECTION _STRING  CLASS=STRING USE32
	SECTION cstartup CLASS=INITDATA USE32
	SECTION crundown CLASS=EXITDATA USE32
	SECTION cppinit  CLASS=CPPINIT USE32
	SECTION cppexit  CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
[GLOBAL	_dpmi_alloc_descriptors]
;
; Line 14:	{
;
_dpmi_alloc_descriptors:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 15:		asm mov cx,[num]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 16:		asm mov ax,0
;
	MOV	AX,00H
;
; Line 17:		asm int 0x31
;
	INT	031H
;
; Line 18:		asm jc xerr
;
	JC	NEAR	L_1
;
; Line 19:		asm mov ecx,[basesel]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 20:		asm mov [ecx],ax
;
	MOV	WORD [ECX],AX
;
; Line 21:		return 0;
;
	MOV	EAX,00H
	JMP	L_2
L_1:
;
; Line 24:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_2:
	POP	EBP
	RET
[GLOBAL	_dpmi_free_selector]
;
; Line 27:	{
;
_dpmi_free_selector:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 28:		asm push ebx
;
	PUSH	EBX
;
; Line 29:		asm mov	bx,[sel]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 30:		asm mov	ax,1
;
	MOV	AX,01H
;
; Line 31:		asm int 0x31
;
	INT	031H
;
; Line 32:		asm pop ebx
;
	POP	EBX
;
; Line 33:		asm jc xerr
;
	JC	NEAR	L_3
;
; Line 34:		return 0;
;
	MOV	EAX,00H
	JMP	L_4
L_3:
;
; Line 37:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_4:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_sel_increment]
;
; Line 40:	{
;
_dpmi_get_sel_increment:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 41:		asm mov ax,3
;
	MOV	AX,03H
;
; Line 42:		asm int 0x31
;
	INT	031H
;
; Line 43:		asm mov ecx,[rv]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 44:		asm movzx eax,ax
;
	MOVZX	EAX,AX
;
; Line 45:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 46:		return 0;
;
	MOV	EAX,00H
L_5:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_sel_base]
;
; Line 49:	{
;
_dpmi_get_sel_base:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 50:		asm push ebx
;
	PUSH	EBX
;
; Line 51:		asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+0CH]
;
; Line 52:		asm mov ax,6
;
	MOV	AX,06H
;
; Line 53:		asm int 0x31
;
	INT	031H
;
; Line 54:		asm pop ebx
;
	POP	EBX
;
; Line 55:		asm jc xerr
;
	JC	NEAR	L_6
;
; Line 56:		asm	mov ax,cx
;
	MOV	AX,CX
;
; Line 57:		asm shl eax,16
;
	SHL	EAX,010H
;
; Line 58:		asm mov ax,dx
;
	MOV	AX,DX
;
; Line 59:		asm mov ecx,[base]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 60:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 61:		return 0;
;
	MOV	EAX,00H
	JMP	L_7
L_6:
;
; Line 64:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_7:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_sel_base]
;
; Line 67:	{
;
_dpmi_set_sel_base:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 68:		asm push ebx
;
	PUSH	EBX
;
; Line 69:		asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 70:		asm mov ax,7
;
	MOV	AX,07H
;
; Line 71:		asm mov ecx,[base]
;
	MOV	ECX,DWORD [EBP+0CH]
;
; Line 72:		asm mov dx,cx
;
	MOV	DX,CX
;
; Line 73:		asm shr ecx,16
;
	SHR	ECX,010H
;
; Line 74:		asm int 0x31
;
	INT	031H
;
; Line 75:		asm pop ebx
;
	POP	EBX
;
; Line 76:		asm jc xerr
;
	JC	NEAR	L_8
;
; Line 77:		return 0;
;
	MOV	EAX,00H
	JMP	L_9
L_8:
;
; Line 80:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_9:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_sel_limit]
;
; Line 83:	{
;
_dpmi_get_sel_limit:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 04H
;
; Line 85:		if (dpmi_get_sel_base(&base,sel))
;
	MOVZX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	LEA	EAX,[EBP+0FFFFFFFCH]
	PUSH	EAX
	CALL	_dpmi_get_sel_base
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JE	SHORT	L_10
;
; Line 86:			return -1;
;
	MOV	EAX,0FFFFFFFFH
	JMP	L_12
L_10:
;
; Line 87:		asm mov ax,[sel]
;
	MOV	AX,WORD [EBP+0CH]
;
; Line 88:		asm lsl eax,eax
;
	LSL	EAX,EAX
;
; Line 89:		asm mov ecx,[limit]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 90:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 91:		return 0;
;
	MOV	EAX,00H
L_12:
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_dpmi_set_sel_limit]
;
; Line 94:	{
;
_dpmi_set_sel_limit:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 95:		asm push ebx
;
	PUSH	EBX
;
; Line 96:		asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 97:		asm mov ax,8
;
	MOV	AX,08H
;
; Line 98:		asm mov ecx,[limit]
;
	MOV	ECX,DWORD [EBP+0CH]
;
; Line 99:		asm mov dx,cx
;
	MOV	DX,CX
;
; Line 100:		asm shr ecx,16
;
	SHR	ECX,010H
;
; Line 101:		asm int 0x31
;
	INT	031H
;
; Line 102:		asm pop ebx
;
	POP	EBX
;
; Line 103:		asm jc xerr
;
	JC	NEAR	L_13
;
; Line 104:		return 0;
;
	MOV	EAX,00H
	JMP	L_14
L_13:
;
; Line 107:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_14:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_sel_access_rights]
;
; Line 110:	{
;
_dpmi_get_sel_access_rights:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 04H
;
; Line 112:		if (dpmi_get_sel_base(&base,sel))
;
	MOVZX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	LEA	EAX,[EBP+0FFFFFFFCH]
	PUSH	EAX
	CALL	_dpmi_get_sel_base
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JE	SHORT	L_15
;
; Line 113:			return -1;
;
	MOV	EAX,0FFFFFFFFH
	JMP	L_17
L_15:
;
; Line 114:		asm mov ax,[sel]
;
	MOV	AX,WORD [EBP+0CH]
;
; Line 115:		asm lar eax,eax
;
	LAR	EAX,EAX
;
; Line 116:		asm mov ecx,[rights]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 117:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 118:		return 0;
;
	MOV	EAX,00H
L_17:
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_dpmi_set_sel_access_rights]
;
; Line 121:	{
;
_dpmi_set_sel_access_rights:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 122:		asm push ebx
;
	PUSH	EBX
;
; Line 123:		asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 124:		asm mov ax,9
;
	MOV	AX,09H
;
; Line 125:		asm mov cx,[rights]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 126:		asm int 0x31
;
	INT	031H
;
; Line 127:		asm pop ebx
;
	POP	EBX
;
; Line 128:		asm jc xerr
;
	JC	NEAR	L_18
;
; Line 129:		return 0;
;
	MOV	EAX,00H
	JMP	L_19
L_18:
;
; Line 132:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_19:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_alias_descriptor]
;
; Line 135:	{
;
_dpmi_get_alias_descriptor:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 136:		asm push ebx
;
	PUSH	EBX
;
; Line 137:		asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+0CH]
;
; Line 138:		asm mov ax,0xa
;
	MOV	AX,0AH
;
; Line 139:		asm int 0x31
;
	INT	031H
;
; Line 140:		asm pop ebx
;
	POP	EBX
;
; Line 141:		asm jc xerr
;
	JC	NEAR	L_20
;
; Line 142:		asm mov ecx,[alias]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 143:		asm mov [ecx],ax
;
	MOV	WORD [ECX],AX
;
; Line 144:		return 0;
;
	MOV	EAX,00H
	JMP	L_21
L_20:
;
; Line 147:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_21:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_descriptor]
;
; Line 152:	{
;
_dpmi_set_descriptor:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 153:		asm push ebx
;
	PUSH	EBX
;
; Line 154:		asm push edi
;
	PUSH	EDI
;
; Line 155:		asm mov edi,[desc]
;
	MOV	EDI,DWORD [EBP+0CH]
;
; Line 156:	  asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 157:		asm mov ax,0xc
;
	MOV	AX,0CH
;
; Line 158:		asm int 0x31
;
	INT	031H
;
; Line 159:		asm pop edi
;
	POP	EDI
;
; Line 160:		asm pop ebx
;
	POP	EBX
;
; Line 161:		asm jc xerr
;
	JC	NEAR	L_22
;
; Line 162:		return 0;
;
	MOV	EAX,00H
	JMP	L_23
L_22:
;
; Line 165:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_23:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_descriptor]
;
; Line 168:	{
;
_dpmi_get_descriptor:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 169:		asm push ebx
;
	PUSH	EBX
;
; Line 170:		asm push edi
;
	PUSH	EDI
;
; Line 171:		asm mov edi,[desc]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 172:	  asm mov bx,[sel]
;
	MOV	BX,WORD [EBP+0CH]
;
; Line 173:		asm mov ax,0xb
;
	MOV	AX,0BH
;
; Line 174:		asm int 0x31
;
	INT	031H
;
; Line 175:		asm pop	edi
;
	POP	EDI
;
; Line 176:		asm pop	ebx
;
	POP	EBX
;
; Line 177:		asm jc xerr
;
	JC	NEAR	L_24
;
; Line 178:		return 0;
;
	MOV	EAX,00H
	JMP	L_25
L_24:
;
; Line 181:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_25:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_multiple_descriptors]
;
; Line 184:	{
;
_dpmi_set_multiple_descriptors:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 185:		asm push edi
;
	PUSH	EDI
;
; Line 186:		asm mov edi,[desc]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 187:	  asm mov cx,[count]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 188:		asm mov ax,0xf
;
	MOV	AX,0FH
;
; Line 189:		asm int 0x31
;
	INT	031H
;
; Line 190:		asm pop edi
;
	POP	EDI
;
; Line 191:		asm jc xerr
;
	JC	NEAR	L_26
;
; Line 192:		return 0;
;
	MOV	EAX,00H
	JMP	L_27
L_26:
;
; Line 195:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_27:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_multiple_descriptors]
;
; Line 199:	{
;
_dpmi_get_multiple_descriptors:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 200:		asm push edi
;
	PUSH	EDI
;
; Line 201:		asm mov edi,[desc]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 202:	  asm mov cx,[count]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 203:		asm mov ax,0xE
;
	MOV	AX,0EH
;
; Line 204:		asm int 0x31
;
	INT	031H
;
; Line 205:		asm pop edi
;
	POP	EDI
;
; Line 206:		asm jc xerr
;
	JC	NEAR	L_28
;
; Line 207:		return 0;
;
	MOV	EAX,00H
	JMP	L_29
L_28:
;
; Line 210:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_29:
	POP	EBP
	RET
[GLOBAL	_dpmi_alloc_real_memory]
;
; Line 215:	{
;
_dpmi_alloc_real_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 216:		asm push ebx
;
	PUSH	EBX
;
; Line 217:		asm mov bx,[len]
;
	MOV	BX,WORD [EBP+010H]
;
; Line 218:		asm mov ax,0x100
;
	MOV	AX,0100H
;
; Line 219:		asm int 0x31
;
	INT	031H
;
; Line 220:		asm pop ebx
;
	POP	EBX
;
; Line 221:		asm jc xerr
;
	JC	NEAR	L_30
;
; Line 222:		asm mov ecx,[sel]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 223:		asm mov [ecx],dx
;
	MOV	WORD [ECX],DX
;
; Line 224:		asm mov ecx,[para]
;
	MOV	ECX,DWORD [EBP+0CH]
;
; Line 225:		asm mov [ecx],ax
;
	MOV	WORD [ECX],AX
;
; Line 226:		return 0;
;
	MOV	EAX,00H
	JMP	L_31
L_30:
;
; Line 229:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_31:
	POP	EBP
	RET
[GLOBAL	_dpmi_dealloc_real_memory]
;
; Line 233:	{
;
_dpmi_dealloc_real_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 234:		asm mov dx,[sel]
;
	MOV	DX,WORD [EBP+08H]
;
; Line 235:		asm mov ax,0x101
;
	MOV	AX,0101H
;
; Line 236:		asm int 0x31
;
	INT	031H
;
; Line 237:		asm jc xerr
;
	JC	NEAR	L_32
;
; Line 238:		return 0;
;
	MOV	EAX,00H
	JMP	L_33
L_32:
;
; Line 241:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_33:
	POP	EBP
	RET
[GLOBAL	_dpmi_realloc_real_memory]
;
; Line 244:	{
;
_dpmi_realloc_real_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 245:		asm push ebx
;
	PUSH	EBX
;
; Line 246:		asm mov bx,[size]
;
	MOV	BX,WORD [EBP+0CH]
;
; Line 247:		asm mov dx,[sel]
;
	MOV	DX,WORD [EBP+08H]
;
; Line 248:		asm mov ax,0x102
;
	MOV	AX,0102H
;
; Line 249:		asm int 0x31
;
	INT	031H
;
; Line 250:		asm pop ebx
;
	POP	EBX
;
; Line 251:		asm jc xerr
;
	JC	NEAR	L_34
;
; Line 252:		return 0;
;
	MOV	EAX,00H
	JMP	L_35
L_34:
;
; Line 255:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_35:
	POP	EBP
	RET
[GLOBAL	_dpmi_arbitrary_copy]
;
; Line 259:	{
;
_dpmi_arbitrary_copy:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 260:		asm push ds
;
	PUSH	DS
;
; Line 261:		asm push es
;
	PUSH	ES
;
; Line 262:		asm push esi
;
	PUSH	ESI
;
; Line 263:		asm push edi
;
	PUSH	EDI
;
; Line 264:		asm mov ecx,[len]
;
	MOV	ECX,DWORD [EBP+018H]
;
; Line 265:		asm mov edi,[dest]
;
	MOV	EDI,DWORD [EBP+0CH]
;
; Line 266:	  asm mov esi,[source]
;
	MOV	ESI,DWORD [EBP+014H]
;
; Line 267:	  asm mov es,[dstsel]
;
	MOV	ES,WORD [EBP+08H]
;
; Line 268:	  asm mov ds,[srcsel]
;
	MOV	DS,WORD [EBP+010H]
;
; Line 269:		asm cld
;
	CLD
;
; Line 270:		asm rep movsb
;
	REP	MOVSB
;
; Line 271:		asm pop edi
;
	POP	EDI
;
; Line 272:		asm pop esi
;
	POP	ESI
;
; Line 273:		asm pop es
;
	POP	ES
;
; Line 274:		asm pop ds
;
	POP	DS
;
; Line 275:		return 0;
;
	MOV	EAX,00H
L_36:
	POP	EBP
	RET
[GLOBAL	_dpmi_copy_from_ds]
;
; Line 278:	{
;
_dpmi_copy_from_ds:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 279:		asm push es
;
	PUSH	ES
;
; Line 280:		asm push esi
;
	PUSH	ESI
;
; Line 281:		asm push edi
;
	PUSH	EDI
;
; Line 282:		asm mov ecx,[len]
;
	MOV	ECX,DWORD [EBP+014H]
;
; Line 283:		asm mov edi,[dest]
;
	MOV	EDI,DWORD [EBP+0CH]
;
; Line 284:	  asm mov esi,[source]
;
	MOV	ESI,DWORD [EBP+010H]
;
; Line 285:	  asm mov es,[sel]
;
	MOV	ES,WORD [EBP+08H]
;
; Line 286:		asm cld
;
	CLD
;
; Line 287:		asm rep movsb
;
	REP	MOVSB
;
; Line 288:		asm pop edi
;
	POP	EDI
;
; Line 289:		asm pop esi
;
	POP	ESI
;
; Line 290:		asm pop es
;
	POP	ES
;
; Line 291:		return 0;
;
	MOV	EAX,00H
L_37:
	POP	EBP
	RET
[GLOBAL	_dpmi_copy_to_ds]
;
; Line 294:	{
;
_dpmi_copy_to_ds:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 295:		asm push ds
;
	PUSH	DS
;
; Line 296:		asm push esi
;
	PUSH	ESI
;
; Line 297:		asm push edi
;
	PUSH	EDI
;
; Line 298:		asm mov ecx,[len]
;
	MOV	ECX,DWORD [EBP+014H]
;
; Line 299:		asm mov edi,[dest]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 300:	  asm mov esi,[source]
;
	MOV	ESI,DWORD [EBP+010H]
;
; Line 301:	  asm mov ds,[sel]
;
	MOV	DS,WORD [EBP+0CH]
;
; Line 302:		asm cld
;
	CLD
;
; Line 303:		asm rep movsb
;
	REP	MOVSB
;
; Line 304:		asm pop edi
;
	POP	EDI
;
; Line 305:		asm pop esi
;
	POP	ESI
;
; Line 306:		asm pop ds
;
	POP	DS
;
; Line 307:		return 0;
;
	MOV	EAX,00H
L_38:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_real_interrupt]
;
; Line 312:	{
;
_dpmi_get_real_interrupt:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 313:		asm push ebx
;
	PUSH	EBX
;
; Line 314:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+010H]
;
; Line 315:		asm mov ax,0x200
;
	MOV	AX,0200H
;
; Line 316:		asm int 0x31
;
	INT	031H
;
; Line 317:		asm pop ebx
;
	POP	EBX
;
; Line 318:		asm jc xerr
;
	JC	NEAR	L_39
;
; Line 319:		asm mov eax,[xseg]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 320:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 321:		asm mov eax,[ofs]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 322:		asm mov [eax],dx
;
	MOV	WORD [EAX],DX
;
; Line 323:		return 0;
;
	MOV	EAX,00H
	JMP	L_40
L_39:
;
; Line 326:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_40:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_real_interrupt]
;
; Line 329:	{
;
_dpmi_set_real_interrupt:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 330:		asm push ebx
;
	PUSH	EBX
;
; Line 331:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 332:		asm mov cx,[xseg]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 333:	  asm mov dx,[ofs]
;
	MOV	DX,WORD [EBP+010H]
;
; Line 334:		asm mov ax,0x201
;
	MOV	AX,0201H
;
; Line 335:		asm int 0x31
;
	INT	031H
;
; Line 336:		asm jc	xerr
;
	JC	NEAR	L_41
;
; Line 337:		asm pop ebx
;
	POP	EBX
;
; Line 338:		return 0;
;
	MOV	EAX,00H
	JMP	L_42
L_41:
;
; Line 341:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_42:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_protected_except]
;
; Line 345:	{
;
_dpmi_get_protected_except:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 346:		asm push ebx
;
	PUSH	EBX
;
; Line 347:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+010H]
;
; Line 348:		asm mov ax,0x202
;
	MOV	AX,0202H
;
; Line 349:		asm int 0x31
;
	INT	031H
;
; Line 350:		asm pop ebx
;
	POP	EBX
;
; Line 351:		asm jc xerr
;
	JC	NEAR	L_43
;
; Line 352:		asm mov eax,[sel]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 353:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 354:		asm mov eax,[ofs]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 355:		asm mov [eax],edx
;
	MOV	DWORD [EAX],EDX
;
; Line 356:		return 0;
;
	MOV	EAX,00H
	JMP	L_44
L_43:
;
; Line 359:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_44:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_protected_except]
;
; Line 363:	{
;
_dpmi_set_protected_except:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 364:		asm push ebx
;
	PUSH	EBX
;
; Line 365:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 366:		asm mov cx,[sel]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 367:	  asm mov edx,[ofs]
;
	MOV	EDX,DWORD [EBP+010H]
;
; Line 368:		asm mov ax,0x203
;
	MOV	AX,0203H
;
; Line 369:		asm int 0x31
;
	INT	031H
;
; Line 370:		asm pop ebx
;
	POP	EBX
;
; Line 371:		asm jc	xerr
;
	JC	NEAR	L_45
;
; Line 372:		return 0;
;
	MOV	EAX,00H
	JMP	L_46
L_45:
;
; Line 375:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_46:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_protected_interrupt]
;
; Line 379:	{
;
_dpmi_get_protected_interrupt:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 380:		asm push ebx
;
	PUSH	EBX
;
; Line 381:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+010H]
;
; Line 382:		asm mov ax,0x204
;
	MOV	AX,0204H
;
; Line 383:		asm int 0x31
;
	INT	031H
;
; Line 384:		asm pop ebx
;
	POP	EBX
;
; Line 385:		asm jc xerr
;
	JC	NEAR	L_47
;
; Line 386:		asm mov eax,[sel]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 387:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 388:		asm mov eax,[ofs]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 389:		asm mov [eax],edx
;
	MOV	DWORD [EAX],EDX
;
; Line 390:		return 0;
;
	MOV	EAX,00H
	JMP	L_48
L_47:
;
; Line 393:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_48:
	POP	EBP
	RET
[GLOBAL	_dpmi_set_protected_interrupt]
;
; Line 397:	{
;
_dpmi_set_protected_interrupt:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 398:		asm push ebx
;
	PUSH	EBX
;
; Line 399:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 400:		asm mov cx,[sel]
;
	MOV	CX,WORD [EBP+0CH]
;
; Line 401:	  asm mov edx,[ofs]
;
	MOV	EDX,DWORD [EBP+010H]
;
; Line 402:		asm mov ax,0x205
;
	MOV	AX,0205H
;
; Line 403:		asm int 0x31
;
	INT	031H
;
; Line 404:		asm pop ebx
;
	POP	EBX
;
; Line 405:		asm jc	xerr
;
	JC	NEAR	L_49
;
; Line 406:		return 0;
;
	MOV	EAX,00H
	JMP	L_50
L_49:
;
; Line 409:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_50:
	POP	EBP
	RET
[GLOBAL	_dpmi_simulate_real_interrupt]
;
; Line 414:	{
;
_dpmi_simulate_real_interrupt:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 415:		asm push ebx
;
	PUSH	EBX
;
; Line 416:		asm push edi
;
	PUSH	EDI
;
; Line 417:		asm mov bx,[num]
;
	MOV	BX,WORD [EBP+08H]
;
; Line 418:		asm sub bh,bh
;
	SUB	BH,BH
;
; Line 419:		asm mov edi,[val]
;
	MOV	EDI,DWORD [EBP+0CH]
;
; Line 420:		asm sub ecx,ecx
;
	SUB	ECX,ECX
;
; Line 421:		asm mov ax,0x300
;
	MOV	AX,0300H
;
; Line 422:		asm int 0x31
;
	INT	031H
;
; Line 423:		asm pop edi
;
	POP	EDI
;
; Line 424:		asm pop ebx
;
	POP	EBX
;
; Line 425:		asm jc	xerr
;
	JC	NEAR	L_51
;
; Line 426:		return 0;
;
	MOV	EAX,00H
	JMP	L_52
L_51:
;
; Line 429:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_52:
	POP	EBP
	RET
[GLOBAL	_dpmi_simulate_proc_far_ret_frame]
;
; Line 433:	{
;
_dpmi_simulate_proc_far_ret_frame:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 434:		asm push ebx
;
	PUSH	EBX
;
; Line 435:		asm push edi
;
	PUSH	EDI
;
; Line 436:		asm sub bx,bx
;
	SUB	BX,BX
;
; Line 437:		asm mov edi,[val]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 438:		asm sub ecx,ecx
;
	SUB	ECX,ECX
;
; Line 439:		asm mov ax,0x301
;
	MOV	AX,0301H
;
; Line 440:		asm int 0x31
;
	INT	031H
;
; Line 441:		asm pop edi
;
	POP	EDI
;
; Line 442:		asm pop ebx
;
	POP	EBX
;
; Line 443:		asm jc	xerr
;
	JC	NEAR	L_53
;
; Line 444:		return 0;
;
	MOV	EAX,00H
	JMP	L_54
L_53:
;
; Line 447:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_54:
	POP	EBP
	RET
[GLOBAL	_dpmi_simulate_proc_int_frame]
;
; Line 451:	{
;
_dpmi_simulate_proc_int_frame:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 452:		asm push ebx
;
	PUSH	EBX
;
; Line 453:		asm push edi
;
	PUSH	EDI
;
; Line 454:		asm sub bx,bx
;
	SUB	BX,BX
;
; Line 455:		asm mov edi,[val]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 456:		asm sub ecx,ecx
;
	SUB	ECX,ECX
;
; Line 457:		asm mov ax,0x302
;
	MOV	AX,0302H
;
; Line 458:		asm int 0x31
;
	INT	031H
;
; Line 459:		asm pop edi
;
	POP	EDI
;
; Line 460:		asm pop ebx
;
	POP	EBX
;
; Line 461:		asm jc	xerr
;
	JC	NEAR	L_55
;
; Line 462:		return 0;
;
	MOV	EAX,00H
	JMP	L_56
L_55:
;
; Line 465:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_56:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_real_callback]
;
; Line 468:	{
;
_dpmi_get_real_callback:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 469:		asm push esi
;
	PUSH	ESI
;
; Line 470:		asm push edi
;
	PUSH	EDI
;
; Line 471:		asm mov esi,[proc]
;
	MOV	ESI,DWORD [EBP+08H]
;
; Line 472:		asm mov edi,[buf]
;
	MOV	EDI,DWORD [EBP+0CH]
;
; Line 473:		asm mov ax,0x303
;
	MOV	AX,0303H
;
; Line 474:		asm int 0x31
;
	INT	031H
;
; Line 475:		asm pop edi
;
	POP	EDI
;
; Line 476:	  asm pop esi
;
	POP	ESI
;
; Line 477:		asm jc xerr
;
	JC	NEAR	L_57
;
; Line 478:		asm mov	eax,[xseg]
;
	MOV	EAX,DWORD [EBP+010H]
;
; Line 479:		asm mov	[eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 480:		asm mov eax,[ofs]
;
	MOV	EAX,DWORD [EBP+014H]
;
; Line 481:		asm mov [eax],dx
;
	MOV	WORD [EAX],DX
;
; Line 482:		return 0;
;
	MOV	EAX,00H
	JMP	L_58
L_57:
;
; Line 485:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_58:
	POP	EBP
	RET
[GLOBAL	_dpmi_free_real_callback]
;
; Line 488:	{
;
_dpmi_free_real_callback:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 489:		asm mov cx,[xseg]
;
	MOV	CX,WORD [EBP+08H]
;
; Line 490:		asm mov dx,[ofs]
;
	MOV	DX,WORD [EBP+0CH]
;
; Line 491:		asm mov ax,0x304
;
	MOV	AX,0304H
;
; Line 492:		asm int 0x31
;
	INT	031H
;
; Line 493:		asm jc xerr
;
	JC	NEAR	L_59
;
; Line 494:		return 0;
;
	MOV	EAX,00H
	JMP	L_60
L_59:
;
; Line 497:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_60:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_state_save_restore]
;
; Line 500:	{
;
_dpmi_get_state_save_restore:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 501:		asm push esi
;
	PUSH	ESI
;
; Line 502:		asm push edi
;
	PUSH	EDI
;
; Line 503:		asm mov ax,0x305
;
	MOV	AX,0305H
;
; Line 504:		asm int 0x31
;
	INT	031H
;
; Line 505:		asm push ebx
;
	PUSH	EBX
;
; Line 506:		asm mov bx,[len]
;
	MOV	BX,WORD [EBP+018H]
;
; Line 507:		asm movzx eax,ax
;
	MOVZX	EAX,AX
;
; Line 508:		asm mov [ebx],eax
;
	MOV	DWORD [EBX],EAX
;
; Line 509:		asm pop ebx
;
	POP	EBX
;
; Line 510:		asm mov eax,[csel]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 511:		asm mov [eax],si
;
	MOV	WORD [EAX],SI
;
; Line 512:		asm mov eax,[cofs]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 513:		asm mov [eax],edi
;
	MOV	DWORD [EAX],EDI
;
; Line 514:		asm mov eax,[xseg]
;
	MOV	EAX,DWORD [EBP+010H]
;
; Line 515:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 516:		asm mov eax,[ofs]
;
	MOV	EAX,DWORD [EBP+014H]
;
; Line 517:		asm mov [eax],dx
;
	MOV	WORD [EAX],DX
;
; Line 518:		asm pop edi
;
	POP	EDI
;
; Line 519:		asm pop esi
;
	POP	ESI
;
; Line 520:		return 0;
;
	MOV	EAX,00H
L_61:
	POP	EBP
	RET
[GLOBAL	_dpmi_call_state_save_restore]
;
; Line 523:	{
;
_dpmi_call_state_save_restore:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
;
; Line 525:		asm push esi
;
	PUSH	ESI
;
; Line 526:		asm mov esi,[buf]
;
	MOV	ESI,DWORD [EBP+010H]
;
; Line 527:		asm mov ax,[csel]
;
	MOV	AX,WORD [EBP+08H]
;
; Line 528:		asm mov word ptr [fcall + 4],ax
;
	MOV	WORD [EBP+0FFFFFFF8H+04H],AX
;
; Line 529:		asm mov eax,[proc]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 530:		asm mov dword ptr [fcall],eax
;
	MOV	DWORD [EBP+0FFFFFFF8H],EAX
;
; Line 531:		asm mov ax,[flag]
;
	MOV	AX,WORD [EBP+014H]
;
; Line 532:		asm call fword ptr [fcall]
;
	CALL	DWORD FAR [EBP+0FFFFFFF8H]
;
; Line 533:		asm pop esi
;
	POP	ESI
;
; Line 534:		return 0;
;
	MOV	EAX,00H
L_62:
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_dpmi_get_version]
;
; Line 538:	{
;
_dpmi_get_version:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 539:		asm mov ax,0x400
;
	MOV	AX,0400H
;
; Line 540:		asm int 0x31
;
	INT	031H
;
; Line 541:		asm push esi
;
	PUSH	ESI
;
; Line 542:		asm mov esi, [ver]
;
	MOV	ESI,DWORD [EBP+08H]
;
; Line 543:		asm mov [esi],ax
;
	MOV	WORD [ESI],AX
;
; Line 544:		asm mov [esi + 2],bx
;
	MOV	WORD [ESI+02H],BX
;
; Line 545:		asm mov [esi + 4],cl
;
	MOV	BYTE [ESI+04H],CL
;
; Line 546:		asm mov [esi + 5],dx
;
	MOV	WORD [ESI+05H],DX
;
; Line 548:		asm pop esi
;
	POP	ESI
;
; Line 549:		return 0;
;
	MOV	EAX,00H
L_63:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_memory_info]
;
; Line 554:	{
;
_dpmi_get_memory_info:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 555:		asm push edi
;
	PUSH	EDI
;
; Line 556:		asm mov edi,[info]
;
	MOV	EDI,DWORD [EBP+08H]
;
; Line 557:		asm mov ax,0x500
;
	MOV	AX,0500H
;
; Line 558:		asm int 0x31
;
	INT	031H
;
; Line 559:		asm jc xerr
;
	JC	NEAR	L_64
;
; Line 560:		return 0;
;
	MOV	EAX,00H
	JMP	L_65
L_64:
;
; Line 563:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_65:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_memory]
;
; Line 566:	{
;
_dpmi_get_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 567:		asm push esi
;
	PUSH	ESI
;
; Line 568:		asm push edi
;
	PUSH	EDI
;
; Line 569:		asm push ebx
;
	PUSH	EBX
;
; Line 570:		asm mov ax,0x501
;
	MOV	AX,0501H
;
; Line 571:		asm mov bx,word ptr [size + 2]
;
	MOV	BX,WORD [EBP+010H+02H]
;
; Line 572:		asm mov cx,word ptr [size]
;
	MOV	CX,WORD [EBP+010H]
;
; Line 573:		asm int 0x31
;
	INT	031H
;
; Line 574:		asm jc xerr
;
	JC	NEAR	L_66
;
; Line 575:		asm mov eax,[linear]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 576:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 577:		asm mov [eax+2],bx
;
	MOV	WORD [EAX+02H],BX
;
; Line 578:		asm mov eax,[handle]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 579:		asm mov [eax],di
;
	MOV	WORD [EAX],DI
;
; Line 580:		asm mov [eax+2],si
;
	MOV	WORD [EAX+02H],SI
;
; Line 581:		asm pop ebx
;
	POP	EBX
;
; Line 582:		asm pop edi
;
	POP	EDI
;
; Line 583:		asm	pop esi
;
	POP	ESI
;
; Line 584:		return 0;
;
	MOV	EAX,00H
	JMP	L_67
L_66:
;
; Line 587:		asm pop ebx
;
	POP	EBX
;
; Line 588:		asm pop edi
;
	POP	EDI
;
; Line 589:		asm pop esi
;
	POP	ESI
;
; Line 590:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_67:
	POP	EBP
	RET
[GLOBAL	_dpmi_free_memory]
;
; Line 594:	{
;
_dpmi_free_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 595:		asm push esi
;
	PUSH	ESI
;
; Line 596:		asm push edi
;
	PUSH	EDI
;
; Line 597:		asm mov si,word ptr [handle+2]
;
	MOV	SI,WORD [EBP+08H+02H]
;
; Line 598:		asm mov di,word ptr [handle]
;
	MOV	DI,WORD [EBP+08H]
;
; Line 599:		asm mov ax,0x502
;
	MOV	AX,0502H
;
; Line 600:		asm int 0x31
;
	INT	031H
;
; Line 601:		asm pop edi
;
	POP	EDI
;
; Line 602:		asm pop esi
;
	POP	ESI
;
; Line 603:		asm jc xerr
;
	JC	NEAR	L_68
;
; Line 604:		return 0;
;
	MOV	EAX,00H
	JMP	L_69
L_68:
;
; Line 607:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_69:
	POP	EBP
	RET
[GLOBAL	_dpmi_resize_memory]
;
; Line 610:	{
;
_dpmi_resize_memory:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 611:		asm push esi
;
	PUSH	ESI
;
; Line 612:		asm push edi
;
	PUSH	EDI
;
; Line 613:		asm push ebx
;
	PUSH	EBX
;
; Line 614:		asm mov ax,0x503
;
	MOV	AX,0503H
;
; Line 615:		asm mov bx,word ptr [size + 2]
;
	MOV	BX,WORD [EBP+010H+02H]
;
; Line 616:		asm mov cx,word ptr [size]
;
	MOV	CX,WORD [EBP+010H]
;
; Line 617:		asm mov si,word ptr [handle+2]
;
	MOV	SI,WORD [EBP+0CH+02H]
;
; Line 618:		asm mov di,word ptr [handle]
;
	MOV	DI,WORD [EBP+0CH]
;
; Line 619:		asm int 0x31
;
	INT	031H
;
; Line 620:		asm jc xerr
;
	JC	NEAR	L_70
;
; Line 621:		asm mov eax,[linear]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 622:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 623:		asm mov [eax+2],bx
;
	MOV	WORD [EAX+02H],BX
;
; Line 624:		asm mov eax,[handle]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 625:		asm mov [eax],di
;
	MOV	WORD [EAX],DI
;
; Line 626:		asm mov [eax+2],si
;
	MOV	WORD [EAX+02H],SI
;
; Line 627:		asm pop ebx
;
	POP	EBX
;
; Line 628:		asm pop edi
;
	POP	EDI
;
; Line 629:		asm pop esi
;
	POP	ESI
;
; Line 630:		return 0;
;
	MOV	EAX,00H
	JMP	L_71
L_70:
;
; Line 633:		asm pop ebx
;
	POP	EBX
;
; Line 634:		asm pop edi
;
	POP	EDI
;
; Line 635:		asm pop esi
;
	POP	ESI
;
; Line 636:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_71:
	POP	EBP
	RET
[GLOBAL	_dpmi_get_memory_params]
;
; Line 640:	{
;
_dpmi_get_memory_params:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 641:		asm push esi
;
	PUSH	ESI
;
; Line 642:		asm push edi
;
	PUSH	EDI
;
; Line 643:		asm push ebx
;
	PUSH	EBX
;
; Line 644:		asm mov si,word ptr [handle+2]
;
	MOV	SI,WORD [EBP+010H+02H]
;
; Line 645:		asm mov di,word ptr [handle]
;
	MOV	DI,WORD [EBP+010H]
;
; Line 646:		asm mov ax,0x504
;
	MOV	AX,0504H
;
; Line 647:		asm int 0x31
;
	INT	031H
;
; Line 648:		asm jc xerr
;
	JC	NEAR	L_72
;
; Line 649:		asm mov eax,[base]
;
	MOV	EAX,DWORD [EBP+08H]
;
; Line 650:		asm mov [eax],si
;
	MOV	WORD [EAX],SI
;
; Line 651:		asm mov [eax+2],di
;
	MOV	WORD [EAX+02H],DI
;
; Line 652:		asm mov eax,[size]
;
	MOV	EAX,DWORD [EBP+0CH]
;
; Line 653:		asm mov [eax],cx
;
	MOV	WORD [EAX],CX
;
; Line 654:		asm mov [eax+2],bx
;
	MOV	WORD [EAX+02H],BX
;
; Line 655:		asm pop ebx
;
	POP	EBX
;
; Line 656:		asm pop edi
;
	POP	EDI
;
; Line 657:		asm pop esi
;
	POP	ESI
;
; Line 658:		return 0;
;
	MOV	EAX,00H
	JMP	L_73
L_72:
;
; Line 661:		asm pop ebx
;
	POP	EBX
;
; Line 662:		asm pop edi
;
	POP	EDI
;
; Line 663:		asm pop esi
;
	POP	ESI
;
; Line 664:		return(-1);
;
	MOV	EAX,0FFFFFFFFH
L_73:
	POP	EBP
	RET
[GLOBAL	_dpmi_enable_virtual_flag]
;
; Line 670:	{
;
_dpmi_enable_virtual_flag:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 671:	  asm mov ax,0x901
;
	MOV	AX,0901H
;
; Line 672:		asm int 0x31
;
	INT	031H
;
; Line 673:		asm movzx eax,al
;
	MOVZX	EAX,AL
;
; Line 674:	  asm mov ecx,[rv]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 675:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 676:		return 0;
;
	MOV	EAX,00H
L_74:
	POP	EBP
	RET
[GLOBAL	_dpmi_disable_virtual_flag]
;
; Line 679:	{
;
_dpmi_disable_virtual_flag:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 680:	  asm mov ax,0x900
;
	MOV	AX,0900H
;
; Line 681:		asm int 0x31
;
	INT	031H
;
; Line 682:		asm movzx eax,al
;
	MOVZX	EAX,AL
;
; Line 683:	  asm mov ecx,[rv]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 684:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 685:		return 0;
;
	MOV	EAX,00H
L_75:
	POP	EBP
	RET
[GLOBAL	_dpmi_return_virtual_flag]
;
; Line 688:	{
;
_dpmi_return_virtual_flag:
	PUSH	EBP
	MOV	EBP,ESP
;
; Line 689:	  asm mov ax,0x902
;
	MOV	AX,0902H
;
; Line 690:		asm int 0x31
;
	INT	031H
;
; Line 691:		asm movzx eax,al
;
	MOVZX	EAX,AL
;
; Line 692:	  asm mov ecx,[rv]
;
	MOV	ECX,DWORD [EBP+08H]
;
; Line 693:		asm mov [ecx],eax
;
	MOV	DWORD [ECX],EAX
;
; Line 694:		return 0;
;
	MOV	EAX,00H
L_76:
	POP	EBP
	RET

