/*
 * itouch.c
 *
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <malloc.h>
#include <time.h>
#include <dos.h>
#include "cmdline.h"
#include "itouch.p"

#define VERSION 100

char *usage_text = "[-v] ...";

static BOOL verbose = FALSE;
static unsigned short absdate,abstime;

void boolargs(char select);
ARGLIST ArgList[] = {
  { 'v', ARG_SWITCH, boolargs },
  { 0, 0, 0 }
};

static void boolargs( char select)
{
  switch (select) {
    case 'v' :
				verbose = TRUE;
        break;
  }
}
void itouch(FILE *inf, FILE*outf, char *fname)
{
	int handle;
	if (verbose) {
		printf("Touching %s\n",fname);
	}
	_dos_open(fname,0, &handle);
	_dos_setftime(handle,absdate,abstime);
	_dos_close(handle);
	
}
/* Main routine */
int main(int argc, char *argv[])
{
	struct tm *tms;
	time_t xtime;
	
  banner(VMSG("itouch"));

  if (!parse_args(&argc, argv, FALSE) || (argc == 1))
    usage(argv[0]);

	time(&xtime);
	tms = localtime(&xtime);
	
	abstime = (tms->tm_hour << 11) | (tms->tm_min << 5) | ((tms->tm_sec+1)/2);
	absdate = ((tms->tm_year-1900) << 9) | ((tms->tm_mon+1) << 5) | (tms->tm_mday);

  /* Run through all files making the changes */
  FileRecurse(argc-1, argv+1, 0, itouch, 0, FALSE);

  return(0);
}