/*                            
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * V1.85 July 2000
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 * ibits.c
 *
 * bitfield functions for the global convergence algorithms
 */
/* Define this to get a dump of the flow graph and dominator tree 
 * These are dumped into ccfg.$$$
 */
#define DEBUG

#include        <stdio.h>
#include				<malloc.h>
#include 				<string.h>
#include				"utype.h"	
#include				"cmdline.h"	
#include        "lists.h"
#include        "expr.h"
#include        "c.h"
#include				"iexpr.h"
#include				"iopt.h"
#include 				"diag.h"

static int names,namebytes;
static ENODE **bitnames;
static ENODE ***enodehash;

static int bittab[8] = { 1,2,4,8,16,32,64,128 };

BYTE *alloc_bitarray(void)
{
	return xalloc(namebytes);
}
void SetBit(BYTE *array, int bit)
{
	array[bit/8] |= bittab[bit & 7];
}
void ClearBit(BYTE *array, int bit)
{
	array[bit/8] &= ~bittab[bit & 7];
}
int TestBit(BYTE *array, int bit)
{
	return array[bit/8] & bittab[bit & 7];
}
void OrArray(BYTE *array1, BYTE *array2)
{
	int i;
	for (i=0; i < namebytes; i++)
		array1[i] |= array2[i];
}
void AndArray(BYTE *array1, BYTE *array2)
{
	int i;
	for (i=0; i < namebytes; i++)
		array1[i] &= ~array2[i];
}
int CompareArray(BYTE *array1, BYTE *array2)
{
	return memcmp(array1,array2,namebytes);
}
