#include        <stdio.h>
#include				<malloc.h>
#include 				<string.h>
#include 				<setjmp.h>
#include				<signal.h>
#include				<stdlib.h>
#include				"utype.h"	
#include				"cmdline.h"	
#include				"umem.h"

#define VERSION 100

char *usage_text = "[options] file"
"\n"
"\t/D  Define something\n"
"\t/fo  set output file\n"
"\t/i  set include file path\n"
"\t/r  reserved for compatability\n"
"\t/t  reserved for compatability\n"
"\t/v  reserved for compatability\n" ;

extern int total_errors ;
extern char *errfile ;
int prm_listfile = FALSE ;
int prm_warning = FALSE ;
int prm_extwarning = FALSE ;
int prm_quieterrors = FALSE ;
int prm_errfile = FALSE ;
int prm_maxerr = 0 ;
int prm_ansi = FALSE ;
int prm_cplusplus = FALSE ;
int prm_trigraph = FALSE ;
int prm_cmangle = FALSE ;
int version = VERSION ;
char *prm_inclpath ;
char *listFile ;
char *errFile ;
char *cppFile ;
char *inputFile ;
char *outputFile[200] ;

char *prm_searchpath = 0 ;
LIST *deflist ;

void incl_setup(char select, char *string);
void ofile_setup(char select, char *string);
void bool_setup(char select, char *string);
void def_setup(char select, char *string);
ARGLIST ArgList[] = {
	{ 'D', ARG_CONCATSTRING, def_setup },
	{ 'f', ARG_CONCATSTRING, ofile_setup },
  { 'i', ARG_CONCATSTRING, incl_setup },
	{ 'r', ARG_BOOL, bool_setup },
	{ 't', ARG_BOOL, bool_setup },
	{ 'v', ARG_BOOL, bool_setup },
	{0,0 },
} ;
void bool_setup(char select, char *string)
{
}
void setglbldefs(void)
{
	LIST *l = deflist;
	while (l) {
		char *s = l->data;
		char *n = s;
		while (*s && *s != '=')
			s++;
		if (*s == '=')
			*s++=0;
		glbdefine(n,s);
		l = l->link;
	}
  glbdefine("__CCDL__","");
  glbdefine("__386__","");
  glbdefine("__i386__","");
  glbdefine("RC_INVOKED","");
}
void def_setup(char select, char *string)
/*
 * activation for command line #defines
 */
{
	char *s = malloc(strlen(string)+1);
	LIST *l = malloc(sizeof(LIST));
	strcpy(s,string);
	l->link = deflist;
	deflist = l;
	l->data = s;
}
void addinclude(void)
/*
 * Look up the INCLUDE environment variable and append it to the
 * search path
 */
{
	char *string = getenv("CCINCL");
	if (string && string[0]) {
		char temp[500];
		strcpy(temp,string);
		if (prm_searchpath) {
			strcat(temp,";");
			strcat(temp,prm_searchpath);
			free(prm_searchpath);
		}
		prm_searchpath = malloc(strlen(temp)+1);
		strcpy(prm_searchpath,temp);
	}
}
void incl_setup(char select, char * string)
/*
 * activation for include paths
 */
{
	if (prm_searchpath)
		prm_searchpath = realloc(prm_searchpath,strlen(string)+strlen(prm_searchpath)+1);
	else {
		prm_searchpath = malloc(strlen(string)+1);
		prm_searchpath[0] = 0;
	}
	strcat(prm_searchpath,string);
}
void ofile_setup(char select, char *string)
{
	if (string[0] != 'o')
		fatal("Invalid paramter -f") ;
	strcpy(outputFile,string+1) ;
	
}
void *AllocateMemory(size_t size)
{
	void *rv ;
	if (size == 0)
		return 0 ;
	rv = malloc(size) ;
	if (!rv)
		fatal("out of memory") ;
	return rv ;
}
char *litlate(char *in)
{
	char *rv = AllocateMemory(strlen(in) +1 );
	strcpy(rv,in) ;
	return rv ;
}

void DeallocateMemory(void *val)
{
	free(val) ;
}
void setfile(char *buf,char *orgbuf,char *ext)
/*
 * Get rid of a file path an add an extension to the file name
 */
{
	char *p = strrchr(orgbuf,'\\');
	if (!p) p = orgbuf;
	else p++;
	strcpy(buf,p);
	StripExt(buf);
	AddExt(buf,ext);
}
int main(int argc, char **argv)
{
  banner("XRC Version %d.%02d Copyright (c) 1994-2001, LADsoft",VERSION/100,VERSION %100);
  if (!parse_args(&argc, argv, TRUE) || argc != 2)
    usage(argv[0]);
	symini() ;
	preprocini() ;
	initsym() ;
	initerr() ;
	kwini() ;

	/* tack the environment includes in */
	setglbldefs() ;
	addinclude();

	errfile = inputFile = strdup(argv[1]) ;
	if (!outputFile[0])
		setfile(outputFile,inputFile,".res") ;

	write_resource(outputFile,parse_rc_file(inputFile)) ;

	if (total_errors) {
			remove(outputFile);
			return 1 ;
	}
	return 0;
}