/*  q type constants used by high precision check routines */

#include "qhead.h"

#if WORDSIZE ==  16
#if NQ > 12

/* 0.0E0 */
short qzero[NQ] = {
0000000,0000000,0000000,0000000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short qzero[];
/* 5.0E-1 */
short qhalf[NQ] = {
0000000,EXPONE-1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short qhalf[];
/* 1.0E0 */
short qone[NQ] = {
0000000,EXPONE,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short qone[];
/* 2.0E0 */
short qtwo[NQ] = {
0000000,EXPONE+1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short qtwo[];
short qthree[NQ] = {
0000000,EXPONE+1,0000000,0140000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short qthree[];
short qnine[NQ] = {0,EXPONE+3,0,0110000,0,0,0,0,0,0,0,0};
extern short qnine[];
/* 3.2E1 */
short q32[NQ] = {
0000000,EXPONE+5,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000,
0,0,0,0,0,0,0,0,0,0,0,0};
extern short q32[];

/*6.9314718055994530941723212145817656807550013436025525412068000949339362E-1*/
short qlog2[NQ] = {
0x0000,EXPONE-1,0x0000,0xb172,0x17f7,0xd1cf,0x79ab,0xc9e3,
0xb398,0x03f2,0xf6af,0x40f3,0x4326,0x7298,0xb62d,0x8a0d,
0x175b,0x8baa,0xfa2b,0xe7b8,0x7620,0x6deb,0xac98,0x5595,};
extern short qlog2[];

/*  1.41421356237309504880168872420969807856967187537694
 *    80731766797379907324784621070388503875343276415727e0
 */
short qsqrt2[NQ] = {
0x0000,EXPONE,0x0000,0xb504,0xf333,0xf9de,0x6484,0x597d,
0x89b3,0x754a,0xbe9f,0x1d6f,0x60ba,0x893b,0xa84c,0xed17,
0xac85,0x8333,0x9915,0x4afc,0x8304,0x3ab8,0xa2c3,0xa8b2,};
extern short qsqrt2[];

/* 2/sqrt(PI) =
 *1.1283791670955125738961589031215451716881012586579977136881714434212849E0*/
short oneopi[NQ] = {
0x0000,EXPONE,0x0000,0x906e,0xba82,0x14db,0x688d,0x71d4,
0x8a7f,0x6bfe,0xc344,0x1409,0xa0eb,0xac3e,0x7517,0x39a1,
0x5830,0xcce6,0x20b0,0xc075,0x9cf8,0x5927,0x0f11,0x40c0};
extern short oneopi[];

/* 3.14159265358979323846264338327950288419716939937510
 *  582097494459230781640628620899862803482534211706798e0
 */
short qpi[NQ] = {
0x0000,EXPONE+1,0x0000,0xc90f,0xdaa2,0x2168,0xc234,0xc4c6,
0x628b,0x80dc,0x1cd1,0x2902,0x4e08,0x8a67,0xcc74,0x020b,
0xbea6,0x3b13,0x9b22,0x514a,0x0879,0x8e34,0x04dd,0xef95,};
extern short qpi[];


/* 5.77215664901532860606512090082402431042159335939923
 *   59880576723488486772677766467093694706329174674951e-1
 */
short qeul[NQ] = {
0x0000,EXPONE-1,0x0000,0x93c4,0x67e3,0x7db0,0xc7a4,0xd1be,
0x3f81,0x0152,0xcb56,0xa1ce,0xcc3a,0xf65c,0xc019,0x0c03,
0xdf34,0x709a,0xffbd,0x8e4b,0x59fa,0x03a9,0xf0ee,0xd065,};
extern short qeul[];

#else

/*							qconst.c	*/
/*  q type constants used by high precision check routines */

/* 0.0 */
short qzero[NQ] = {
0000000,0000000,0000000,0000000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short qzero[];

/* 5.0E-1 */
short qhalf[NQ] = {
0000000,EXPONE-1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short qhalf[];
/* 1.0E0 */
short qone[NQ] = {
0000000,EXPONE,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short qone[];
/* 2.0E0 */
short qtwo[NQ] = {
0000000,EXPONE+1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short qtwo[];
short qthree[NQ] = {
0000000,EXPONE+1,0000000,0140000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short qthree[];
short qnine[NQ] = {0,EXPONE+3,0,0110000,0,0,0,0,0,0,0,0};
extern short qnine[];
/* 3.2E1 */
short q32[NQ] = {
0000000,EXPONE+5,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern short q32[];
/* 6.93147180559945309417232121458176568075500134360255E-1 */
short qlog2[NQ] = {
0000000,EXPONE-1,0000000,0130562,0013767,0150717,
0074653,0144743,0131630,0001762,0173257,0040363};
extern short qlog2[];
/* 1.41421356237309504880168872420969807856967187537695E0 */
short qsqrt2[NQ] = {
0000000,EXPONE,0000000,0132404,0171463,0174736,
0062204,0054575,0104663,0072512,0137237,0016557};
extern short qsqrt2[];
/* 2/sqrt(PI) =
 * 1.12837916709551257389615890312154517168810125865800E0 */
short oneopi[NQ] = {
0000000,EXPONE,0000000,0110156,0135202,0012333,
0064215,0070724,0105177,0065776,0141504,0012012};
extern short oneopi[];
/* 3.14159265358979323846264338327950288419716939937511E0 */
short qpi[NQ] = {
0000000,EXPONE+1,0000000,0144417,0155242,0020550,
0141064,0142306,0061213,0100334,0016321,0024402};
extern short qpi[];
/* 5.7721566490153286060651209008240243104215933593992E-1 */
short qeul[NQ] = {
0000000,EXPONE-1,0000000,0111704,0063743,0076660,
0143644,0150676,0037601,0000522,0145526,0120717};
extern short qeul[];
#endif
#endif /* WORDSIZE 16 */

#if WORDSIZE == 32
#if NQ > 8
/*							qc100.c	*/
/*  q type constants used by high precision check routines */

/* 0.0E0 */
QELT qzero[NQ] = {
0,0x0000,0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qzero[];
/* 5.0E-1 */
QELT qhalf[NQ] = {
0,EXPONE-1,0,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qhalf[];
/* 1.0E0 */
QELT qone[NQ] = {
0,EXPONE,0,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qone[];
/* 2.0E0 */
QELT qtwo[NQ] = {
0,EXPONE+1,0,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qtwo[];
/* 3.0E0 */
QELT qthree[NQ] = {
0,EXPONE+1,0,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qthree[];
/* 9.0e0 */
QELT qnine[NQ] = {
0,EXPONE+3,0,0x90000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT qnine[];
/* 3.2E1 */
QELT q32[NQ] = {
0,EXPONE+5,0,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000};
extern QELT q32[];

/*6.9314718055994530941723212145817656807550013436025525412068000949339362E-1*/
QELT qlog2[NQ] = {
0,EXPONE-1,0,0xb17217f7,0xd1cf79ab,0xc9e3b398,0x03f2f6af,0x40f34326,
0x7298b62d,0x8a0d175b,0x8baafa2b,0xe7b87620,0x6debac98,0x559552fb,};
extern QELT qlog2[];

/*  1.41421356237309504880168872420969807856967187537694
 *    80731766797379907324784621070388503875343276415727e0
 */
QELT qsqrt2[NQ] = {
0,EXPONE,0,0xb504f333,0xf9de6484,0x597d89b3,0x754abe9f,0x1d6f60ba,
0x893ba84c,0xed17ac85,0x83339915,0x4afc8304,0x3ab8a2c3,0xa8b1fe70,};
extern QELT qsqrt2[];

/* 2/sqrt(PI) =
 *1.1283791670955125738961589031215451716881012586579977136881714434212849E0*/
QELT oneopi[NQ] = {
0,EXPONE,0,0x906eba82,0x14db688d,0x71d48a7f,0x6bfec344,0x1409a0eb,
0xac3e7517,0x39a15830,0xcce620b0,0xc0759cf8,0x59270f11,0x40c03609};
extern QELT oneopi[];

/* 3.14159265358979323846264338327950288419716939937510
 *  582097494459230781640628620899862803482534211706798e0
 */
QELT qpi[NQ] = {
0,EXPONE+1,0,0xc90fdaa2,0x2168c234,0xc4c6628b,0x80dc1cd1,0x29024e08,
0x8a67cc74,0x020bbea6,0x3b139b22,0x514a0879,0x8e3404dd,0xef9519b4,};
extern QELT qpi[];


/* 5.772156649015328606065120900824024310421593359399235988
     057672348848677267776646709369470632917467495146314472  */
QELT qeul[NQ] = {
0,EXPONE-1,0,0x93c467e3,0x7db0c7a4,0xd1be3f81,0x0152cb56,0xa1cecc3a,
0xf65cc019,0x0c03df34,0x709affbd,0x8e4b59fa,0x03a9f0ee,0xd0649ccb,};
extern QELT qeul[];

#else

 /*							qconst.c	*/
/*  q type constants used by high precision check routines */

/* 0.0 */
QELT qzero[NQ] = {
0000000,0000000,0000000,0000000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qzero[];

/* 5.0E-1 */
QELT qhalf[NQ] = {
0000000,EXPONE-1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qhalf[];
/* 1.0E0 */
QELT qone[NQ] = {
0000000,EXPONE,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qone[];
/* 2.0E0 */
QELT qtwo[NQ] = {
0000000,EXPONE+1,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qtwo[];
QELT qthree[NQ] = {
0000000,EXPONE+1,0000000,0140000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qthree[];
QELT qnine[NQ] = {
0000000,EXPONE+3,0000000,0110000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT qnine[];
/* 3.2E1 */
QELT q32[NQ] = {
0000000,EXPONE+5,0000000,0100000,0000000,0000000,
0000000,0000000,0000000,0000000,0000000,0000000};
extern QELT q32[];
/* 6.93147180559945309417232121458176568075500134360255E-1 */
QELT qlog2[NQ] = {
0000000,EXPONE-1,0000000,0130562,0013767,0150717,
0074653,0144743,0131630,0001762,0173257,0040363};
extern QELT qlog2[];
/* 1.41421356237309504880168872420969807856967187537695E0 */
QELT qsqrt2[NQ] = {
0000000,EXPONE,0000000,0132404,0171463,0174736,
0062204,0054575,0104663,0072512,0137237,0016557};
extern QELT qsqrt2[];
/* 2/sqrt(PI) =
 * 1.12837916709551257389615890312154517168810125865800E0 */
QELT oneopi[NQ] = {
0000000,EXPONE,0000000,0110156,0135202,0012333,
0064215,0070724,0105177,0065776,0141504,0012012};
extern QELT oneopi[];
/* 3.14159265358979323846264338327950288419716939937511E0 */
QELT qpi[NQ] = {
0000000,EXPONE+1,0000000,0144417,0155242,0020550,
0141064,0142306,0061213,0100334,0016321,0024402};
extern QELT qpi[];
/* 5.7721566490153286060651209008240243104215933593992E-1 */
QELT qeul[NQ] = {
0,EXPONE-1,0,0x93c467e3,0x7db0c7a4,0xd1be3f81,0x0152cb56,0xa1cecc3a,
0xf65cc019,0x0c03df34,0x709affbd,0x8e4b59fa,0x03a9f0ee,0xd0649ccb};
extern QELT qeul[];
#endif
#endif /* WORDSIZE 32 */
