/********* Listing 3 *************************** DYNHASH.HPP ******
*  Copyright (C) 1990 by Tom Provenzano
* 
*  Implements a dynamic hashing scheme called linear hashing and
*  is based on the article "Dynamic Hash Tables" by Per-Ake Larson,
*  Communications of the ACM, v31 n4, April 1988, pp. 446-457.
*******************************************************************/

#include <generic.hpp>  // Zortech's equivalent of generic.h
#include <slist.hpp>    // use's Zortech Tools singly-linked lists & iterators
#include "dynarray.hpp" // will inherit dynamic array class

// status parameters

const int OK             =  0;    // successful operation
const int NOT_FOUND      = -100;  // item not found
const int NO_MEMORY      = -101;  // memory allocation failure
const int NOT_INSERTED   = -102;  // item not put in hashtable
const int NOT_REMOVED    = -103;  // item not removed from hashtable
const int EXPAND_ERROR   = -104;  // error during hashtable expansion
const int CONTRACT_ERROR = -105;  // error during hashtable contraction

#define gdynhash(type) name2(type,gdynhash)
#define gdynhashdeclare(type)                                           \
struct gdynhash(type) : dynhash                                         \
{                                                                       \
  gdynhash(type)() : (sizeof(type)) {}                                  \
  int   insert(type* p)   { return dynhash::insert(p); }                \
  int   remove(type* p)   { return dynhash::remove(p); }                \
  type* lookup(type* p)   { return (type* )dynhash::lookup(p);  }       \
  type* get_next( void )  { return (type* )dynhash::get_next(); }   \
};

typedef zSList* pzSList;  // because 'declare' won't accept pointer syntax
declare(gdynarray,pzSList);

class dynhash
{
private:
  int N;                        // minimum size of hash table
  int splitp;                   // pointer to next bucket to split
  int maxp;                     // upper bound on p during this expansion
  int CurrentSize;              // current size (num records in table)
  int MinLoadFactor;            // lower bound on load factor
  int MaxLoadFactor;            // upper bound on load factor
  int Threshold;                // load factor threshold reached (Y/N)
  int recsize;                  // size of a table record (bytes)
  int err;                      // class's error flag
 
  int hash( char * );           // compute hash function
  int ExpandTable();            // expand hash table
  int ContractTable();          // contract hash table
  int ConvertKey( char * );     // convert key to integer value
  int insert_rec( void * );     // insert record in hash table
  int remove_rec( void * );     // remove record from hash table
  gdynarray(pzSList) hashtable; // declare hash table dynarray of pzSList*'s

public:
  dynhash( int );               // constructor
  ~dynhash();                   // destructor
  int insert( void * );         // insert entry in hash table
  int remove( void * );         // remove entry from hash table
  void *get_next( void );       // get next entry in hash table
  void *lookup( void * );       // look up entry in hash table
  int size() { return CurrentSize; } // report number of records in table
  int error() { int x = err; err = 0; return x; } // error handler
};