/*******  Listing 4  ******************************  OX.H  ***********
*   ox.h  --  Prototypes and data types for OBJECT EXPLORER
*         by Thomas E. Siering, 1991. See Listing 1 for copyright
**********************************************************************/

/* A few code-readability enhancers */
typedef int RC;              /* Function Return Codes */
typedef unsigned char bool;  /* TRUE, FALSE */

#define OK          0        /* Successful function completion */
#define PRIVATE     static   /* Private ... */
#define PUBLIC               /* ... and public function types */
#define FALSE       0        /* Boolean values */
#define TRUE        !FALSE
#define FOREVER for ( ; ; )


#define OMFNAMELENGTH 8

/* The following provides Linked List services: */
struct node {
    void *InfoP;
    struct node *NextP;
};
typedef struct node LNODE;

/* The following are specific OMF data structures: */
typedef struct {
    char ID;
    char Type;
    char Method;
    LNODE *DefList;
    int  ListIndex;
} FIXUPTHREAD;

typedef enum {
    Message,
    Warning,
    Error
} MESSAGETYPE;

/* These are the services available from svc.c: */
PUBLIC void InstList(LNODE *header);
PUBLIC LNODE AddListNode(LNODE header, void  *obj);
PUBLIC LNODE *GetListNode(LNODE header, unsigned int node_num);
PUBLIC void *MakeASCIIZ(char *data);
PUBLIC void Output(MESSAGETYPE MsgType, FILE *Stream, char *OutputFormat, ...);

/* The Object Module Format types */

/* The following object record types represent the INTEL subset commonly
** used by language translators: */

/* 1. OMF comment records: */
#define THEADR      0x80
#define COMENT      0x88
#define MODEND      0x8A

/* 2. Symbol lists: */
#define LNAMES      0x96
#define EXTDEF      0x8C
#define PUBDEF      0x90

/* 3. Memory layout info: */
#define SEGDEF      0x98
#define GRPDEF      0x9A
#define COMDEF      0xB0
#define TYPDEF      0x8E

/* 4. Code and data */
#define LEDATA      0xA0
#define LIDATA      0xA2

/* 5. Address binding/relocation: */
#define FIXUPP      0x9C

/* 6. Debugging info: */
#define LINNUM      0x94

/* 7. Obsolete record types */
#define BLKDEF      0x7A
#define BLKEND      0x7C
#define LHEADR      0x82

/* 8. Microsoft Extensions: local symbol record types, QC back patch */
#define BAKPAT      0xB2
#define LEXTDEF     0xB4
#define LPUBDEF     0xB6
#define LCOMDEF     0xB8


/* The high-level Object Explorer API: */
PUBLIC void InstObjExp(char objfn[], char **ws, long *objsiz);
PUBLIC RC GetObjRecordName(unsigned char orecnum, char typbufr[]);
PUBLIC unsigned int GetRecordRelPos(char *CurrentPosition);


/* The low-level functions associated with the OMF types */
PUBLIC void DoTHEADR(unsigned char *rec);
PUBLIC void DoCOMENT(unsigned char *rec, int RecordLength);
PUBLIC void DoMODEND(unsigned char *rec);
PUBLIC void DoLNAMES(unsigned char *rec, int RecordLength);
PUBLIC void DoEXTDEF(unsigned char *rec, int RecordLength);
PUBLIC void DoPUBDEF(unsigned char *rec, int  RecordLength);
PUBLIC void DoSEGDEF(unsigned char *rec);
PUBLIC void DoGRPDEF(unsigned char *rec, int  RecordLength);
PUBLIC void DoCOMDEF(unsigned char *rec, int RecordLength);
PUBLIC void DoTYPDEF(void);
PUBLIC void DoLEDATA(unsigned char *rec, int  RecordLength);
PUBLIC void DoLIDATA(unsigned char *rec, int RecordLength);
PUBLIC void DoFIXUPP(unsigned char *rec, int RecordLength);
PUBLIC void DoLINNUM(unsigned char *rec, int  RecordLength);
PUBLIC void DoBAKPAT(unsigned char *rec, int  RecordLength);
PUBLIC void DoBLKDEF(void);
PUBLIC void DoBLKEND(void);
PUBLIC void DoLHEADR(unsigned char *rec);

/* A print formatting function */
PUBLIC void PrintObjDumpLine(char *Src, FILE *Dest, int LocCtr,
        int RecordLength);