/* Test if switch: Some switch-options are optimized to void */

#include <stdio.h>
#include <string.h>

struct state {
    int flags;				/* Current state flags */
};

static struct state stack;	/* Linked list of stacked states */

#define TRACE_ON	      000001  /* Trace enabled */
#define DEBUG_ON	      000002  /* Debug enabled */
#define FILE_ON		      000004  /* File name print enabled */
#define LINE_ON		      000010  /* Line number print enabled */
#define DEPTH_ON	      000020  /* Function nest level print enabled */
#define PROCESS_ON	      000040  /* Process name print enabled */
#define NUMBER_ON	      000100  /* Number each line of output */
#define SANITY_CHECK_ON	      000200  /* Check safemalloc on DBUG_ENTER */
#define FLUSH_ON_WRITE	      000400  /* Flush on every write */

void _db_push_ (char *control);

int main(int argc,char *argv[])
{
  _db_push_ ("#t");
  if (stack.flags & TRACE_ON)
    puts("The program works");
  else
    puts("Error: -t switch dosen't work");
  return 0;
}


void _db_push_ (control)
char *control;
{
  register char *scan;
  char *new_str;

    for (scan=control; scan != NULL; scan = strchr(scan,':'))
    {
	      switch (*(++scan)) {
		  case 'd':
		  case 'D':
			      stack.flags |= DEBUG_ON;
			      break;
		  case 'f':
		  case 'F':
			      stack.flags |= FILE_ON;
			      break;
		  case 'L':
			      stack.flags |= LINE_ON;
			      break;
		  case 'n':
			      stack.flags |= DEPTH_ON;
			      break;
		  case 'N':
			      stack.flags |= NUMBER_ON;
			      break;
		  case 'O':
		  case 'o':
			      stack.flags |= FLUSH_ON_WRITE;
			      break;
		  case 'p':
		  case 'P':
		  case 'r':
			      stack.flags |= PROCESS_ON;
			      break;
		  case 't':
			      stack.flags |= TRACE_ON;
			      break;
		  case 'S':
			      stack.flags |= SANITY_CHECK_ON;
			      break;
	      }
    }
}
