/*  BLOB.C -- A program to print out a four line label.  Written for an
    ALPS P2000G printer, it should work on any Epson-compatible printer.
    This program accompanies an article in issue 20 of the C News.  */

#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>

char *get_date();

union REGS regs;

#define YES 1
#define NO  0
#define LINELEN 129         /* DOS max line length + 1 */


FILE *printer;

void main()
{
	/*  Declare variables for name, title, and the two comment lines
	    to be character arrays.  Declare the character array NLQ for
	    elite print and initialize with the escape codes for elite
	    printing on the ALPS P2000 printer.  Declare an integer for
	    use with yorn() to determine whether elite printer is desired.  */

	char name[15], title[28], comment1[28], comment2[28];
	char NLQ[] = {0x1B, 0x4D};
	int elite;

	/*  Clear the screen and reset the cursor to the upper left
	    corner.  */

	clearscr(24,79);
	set_cursor(0,0);

	/*  Open the stream to the printer.  */

	printer = fopen("LPT1", "w");

	/*  Check whether the printer is online.  If not, notify the user
	    before proceeding.  (NOTE:  The program could be designed to
	    exit if the printer is not ready.)  */

	if(!prncheck())
		puts("Please check the printer.");

	/*  Ask the user if elite printing is desired using yorn().  */

	elite = yorn("Would you like elite printing?", YES);

	/*  If the user has requested elite printing, send the escape codes
	    for elite printing, NLQ, to the printer.  */

	if (elite)
		fputs(NLQ, printer);

	/*  Use a do-while loop to request the data and print the labels.  */

	do
	{
		printf("Please enter the title:  ");
		gets(title);

		printf("Please enter a name:  ");
		gets(name);

		printf("Please enter the first comment:  ");
		gets(comment1);

		printf("Please enter the second comment:  ");
		gets(comment2);

		fprintf(printer,"%s\n", title);
		fprintf(printer,"%s", name);
		fprintf(printer,"                  %s\n", get_date());
		fprintf(printer,"%s\n", comment1);
		fprintf(printer,"%s\n\n", comment2);

		printf("\n");

	} while(yorn("Would you like to print another label?", YES));

	/*  Flush the buffer and close the stream to the printer.  */

	fflush(printer);
	fclose(printer);

}

/*  Get the system date using interrupt 21, function 2A.  See accompanying
    text for details.  */

char *get_date()
{
	static char date[9];

	regs.h.ah= 0x2a;
	intdos(&regs, &regs);

	sprintf(date, "%02.2d/%02.2d/%02.2d", regs.h.dh, regs.h.dl, regs.x.cx-1900);

	return(date);
}

/*  Get user response to a question, allowing the user to hit enter for
    the requested default.  */

int yorn(char *prompt, int dfault)
{
	char s[LINELEN], c;
	int len;

	printf("%s (%c) ", prompt, dfault ? 'Y' : 'N');
	fgets(s, LINELEN, stdin);
	len = strspn(s, " \t\n");    /* skip whitespace */

	if(len < strlen(s))
	{
		c = *(s + len);
		if(c == 'Y' || c == 'y') return YES;
		else if(c == 'N' || c == 'n') return NO;
	}

	return dfault;
}

/*  Clear the area of the screen from 0,0 to the specified coordinates using
    interrupt 10, function 6.  See accompanying text for details.  */

int clearscr(int rows, int columns)
{
	regs.h.ah = 6;
	regs.h.al = 0;
	regs.h.bh = 7;    /*  Attribute to write to screen.  */
	regs.h.ch = 0;
	regs.h.cl = 0;
	regs.h.dh = rows;
	regs.h.dl = columns;

	int86(0x10, &regs, &regs);
}

/*  Return the cursor to the desired position using interrupt 10, function 2.
    See accompanying text for details.  */

int set_cursor(int rows, int columns)
{
	regs.h.ah = 2;
	regs.h.bh = 0;
	regs.h.dh = rows;           /*  Return cursor to this row.  */
	regs.h.dl = columns;        /*  Retun cursor to this column.  */

	int86(0x10, &regs, &regs);
}


/*  Check to see if the printer is online using interrupt 17, function 2.
    See accompanying text for details.  */

int prncheck()
{
	union REGS regs;

	regs.h.ah = 0x02;        /*  AH = 02 for printer status  */
	regs.x.dx = 0;           /*  DX = 00 for LPT1  */

	int86(0x17, &regs, &regs);

	return(((regs.h.ah & 0x80) == 0x80) ? 1 : 0);
}
