/****************************************************************************
*
*                             The MegaToolbox
*
*                   Copyright (C) 1996 SciTech Software.
*                           All rights reserved.
*
* Filename:     $Workfile:   test.c  $
* Version:      $Revision:   1.0  $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  Test program for the console output library.
*
* $Date:   05 Feb 1996 20:44:32  $ $Author:   KendallB  $
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include "console.h"

/*---------------------------- Implementation -----------------------------*/

void test_CON_printf(void)
{
	int     i;

	CON_printf("This is a test of CON_printf() \"%s\" '%c' %d\n",
		"String", 'C', 10);
	for (i = 0; i < 100; i++)
		CON_printf("CON_printf() line number %d ... \n", i);
}

void test_CON_puts(void)
{
	int     i;

	for (i = 0; i < 100; i++)
		CON_puts("CON_puts() for fast Strings! ");
}

void test_CON_putc(void)
{
	int     i;

	for (i = 0; i < 100; i++)
		CON_putc('c');
}

void test_CON_writec(void)
{
	int     i;

	for (i = 0; i < 80; i++) {
		CON_writec(i, 0, CON_makeAttr(CON_CYAN, CON_BLUE), '');
		CON_writec(i, 1, CON_makeAttr(CON_CYAN, CON_BLUE), '');
		}
}

void test_CON_write(void)
{
	int     i;

	for (i = 2; i < CON_maxy() + 1; i++)
		CON_write(0, i, CON_makeAttr(CON_RED, CON_BLUE),
			"");
}

void test_CON_clreol(void)
{
	getch();
	CON_gotoxy(0, 1);
	CON_clreol();
}

void test_CON_delline(void)
{
	getch();
	CON_delline();
}

void test_CON_moveText(void)
{
	int     i;

	getch();
	for (i = 0; i < 40; i++)
		CON_moveText(i, i, i+10, i+10, i+1,i+1);
	getch();
	for (i = 39; i > 0; i--)
		CON_moveText(i, i, i+10, i+10, i-1,i-1);
	getch();
	for (i = 0; i < 70; i++)
		CON_moveText(i, 0, i+10, 10, i+1, 0);
}

void test_CON_saveText(void)
{
	char    *savebuf;

	getch();
	savebuf = malloc(CON_bufSize(CON_maxy()+1,CON_maxx()+1));

	CON_saveText(0, 0, CON_maxx(), CON_maxy(), savebuf);
	CON_clrscr();
	getch();
	CON_restoreText(0, 0, CON_maxx(), CON_maxy(), savebuf);

	free(savebuf);
}

void test_CON_scroll(void)
{
	int i;

	getch();
	CON_setBackground(CON_makeAttr(CON_CYAN, CON_BLUE), '');
	for (i = 0; i < CON_maxy() + 1; i++)
		CON_scroll(CON_SCROLL_UP, 1);

	getch();
	CON_setBackground(CON_makeAttr(CON_CYAN, CON_BLUE), '');
	for (i = 0; i < CON_maxy() + 1; i++)
		CON_scroll(CON_SCROLL_DOWN, 1);

	getch();
	CON_setBackground(CON_makeAttr(CON_RED, CON_BLUE), '');
	for (i = 0; i < CON_maxx() + 1; i++)
		CON_scroll(CON_SCROLL_RIGHT, 1);

	getch();
	CON_setBackground(CON_makeAttr(CON_RED, CON_BLUE), '');
	for (i = 0; i < CON_maxx() + 1; i++)
		CON_scroll(CON_SCROLL_LEFT, 1);
}

void test_CON_fillText(void)
{
	getch();
	CON_fillText(0, 0, CON_maxx(), CON_maxy(),
		CON_makeAttr(CON_CYAN, CON_BLUE), '');
}

void test_CON_fillAttr(void)
{
	getch();
	CON_fillAttr(0, 0, CON_maxx(), CON_maxy(),
		CON_makeAttr(CON_RED, CON_BLUE));
}

void do_tests_in_window(void)
{
	CON_setBackground(CON_makeAttr(CON_LIGHTGRAY, CON_BLACK), ' ');
	CON_setWindow(10, 10, CON_screenWidth()-10, CON_screenHeight()-10);
	getch();
	CON_setForeColor(CON_RED);
	CON_setBackColor(CON_BLUE);
	CON_setAttr(CON_makeAttr(CON_RED, CON_BLUE));
	test_CON_printf();
	test_CON_puts();
	test_CON_putc();
	getch();
	CON_clrscr();
	test_CON_writec();
	test_CON_write();
	test_CON_clreol();
	test_CON_delline();
	test_CON_saveText();
	test_CON_scroll();
	test_CON_fillText();
	test_CON_fillAttr();
}

void main(int argc,char *argv[])
{
	/* Initialise the console output routines */

	CON_init();

	if (argc > 1) {
		if (atoi(argv[1]) == 25)
			CON_set25LineMode();
		else if (atoi(argv[1]) == 43)
			CON_set43LineMode();
		else if (atoi(argv[1]) == 50)
			CON_set50LineMode();
		}

	test_CON_printf();
    test_CON_puts();
    test_CON_putc();
    getch();
    CON_clrscr();
    test_CON_writec();
    test_CON_write();
    test_CON_clreol();
    test_CON_delline();
    test_CON_moveText();
    test_CON_saveText();
    test_CON_scroll();
    test_CON_fillText();
	test_CON_fillAttr();

    do_tests_in_window();

    CON_setActivePage(1);
    CON_setVisualPage(1);
    do_tests_in_window();

    getch();

    CON_setActivePage(0);
    CON_setVisualPage(0);
	CON_write(10,10,CON_makeAttr(CON_RED, CON_BLUE), "Back on page 0");
	getch();

	CON_restoreMode();
}

