

1        Introduction et avertissements                                    1
1.1      Pourquoi utiliser un extracteur                                   1
1.1.1    Mise en service d'une librairie avec prototypes invalides         1
1.1.2    Validation implicite du fichier d'inclusion                       1
1.1.3    Rvision des clients d'un service                                 2
1.2      Certains compilateurs peuvent extraire les prototypes             2
1.2.1    Un compilateur peut oublier des prototypes                        2
2        Limites de la version d'valuation                                2
2.1      Production automatise de sommaire alphabtique                   3
2.2      Production d'un index permut                                     3
2.3      Production et entretien d'un historique des fonctions             3
3        Spcifications et opration                                       3
3.1      Principes gnraux                                                4
3.1.1    Systmes, clients, et fournisseurs en programmation               4
3.1.2    Dclaration de fonction (prototypes) et dfinition                4
3.1.2.1  Utilit des dclarations de fonctions                             5
3.1.2.2  Stratgie d'utilisation des prototypes                            5
3.1.2.3  Composition du fichier d'inclusion                                5
3.2      ANSI C et C++ supports                                           6
3.3      Mot-cls ajouts pour automatiser l'opration de                  6
         l'extracteur                                                
3.3.1    Dfinition des mots cls supplmentaires                          6
3.4      Options de la ligne de commande                                   6
3.4.1    @fichier : fichier contenant des paramtres de ligne de           7
         commande                                                    
3.4.1.1  Exemple de localisation de fichiers de commandes                  7
3.4.1.2  @ spcifi sans fichier                                           8
3.4.2    -a : Accs par dfaut au fonctions membres (C++)                  8
3.4.3    -b : Mise  jour d'un fichier C++  partir d'un fichier .pm       8
3.4.3.1  Exemple d'utilisation de l'option -b                              9
3.4.3.2  Controle de la distribution des prototypes de fonctions           9
         membres                                                     
3.4.4    -c : composition de l'extraction                                  9
3.4.4.1  Le verbe export : extension au C                                 10
         Ajout du verbe export au langage C                               10
         Utilit du verbe export                                          10
         Le verbe _export                                                 10
3.4.4.2  Combinaison de l'option -c et -f dans une seule session          11
3.4.4.3  Paramtre 'i' de l'option -c: Rfrence inverse                  11
3.4.4.4  Paramtre 'd' de l'option -c: Prototypes et documentation        11
3.4.4.5  Corrections au prototypes avant la gnration                    11
         Fonctions sans type de retour                                    12
         Paramtres sans type                                             12
         Fonctions sans paramtre                                         12
3.4.5    -C : Ne traite pas les commentaires imbriqus                    12
3.4.6    -D : Dfinition de symbole sur la ligne de commande              12
3.4.7    -e : Ferme un fichier rsultat                                   13
3.4.7.1  Protection contre le double traitement durant une session        13
         Fichiers sources rpartis dans deux rpertoires                  13
3.4.8    -f/+f : identification d'un fichier rsultat                     13
3.4.8.1  Combinaison de l'option -c et -f dans une seule session          14
3.4.9    -h : fichier de prototypes C++  dcomposer                      14
3.4.10   -i : Mode incrmental                                            14
3.4.11   -I : Rpertoire de recherche pour les fichiers d'inclusion       15
3.4.12   -k : Renomme les mot-cls reconnus par l'extracteur              15
3.4.13   -l : Spcification d'un nom alternatif pour l'option -h          15
3.4.14   -m : Slectionne une mthodologie particulire                   16



                                                              1


3.4.14.1 Rpertoires alternatifs pour l'exportation des fichiers          16
         rsultat                                                    
3.4.15   -o : Nom alternatif pour l'option -m                             16
3.4.16   -p : Activation de l'extraction pour les fichiers suivants       16
3.4.16.1 Exemple d'utilisation des options -x et -p                       16
3.4.16.2 Protection contre le double traitement durant une session        17
3.4.17   -P : activation du prprocesseur                                 17
3.4.17.1 Traitement des #define mme lorsque le prprocesseur n'est       17
         pas actif                                                   
3.4.17.2 Traitements des #if, #ifdef, ... sans -P                         17
3.4.18   -s : opration silencieuse                                       18
3.4.19   -t : lecture du source  traiter sur la console                  18
3.4.20   -v : Liste des fichiers traits                                  18
3.4.21   -x : exclusion d'un groupe de fichier                            18
3.4.21.1 Exemple d'utilisation des options -x et -p                       18
3.4.21.2 Protection contre le double traitement durant une session        18
3.4.22   Macros et Caractres spciaux                                    19
3.4.22.1 $ : Nom du rpertoire courant                                    19
3.5      Combinaisons invalides d'options                                 19
3.6      Stratgie d'utilisation de l'extracteur                          19
3.6.1    Convention d'utilisation: Avertissement au lecteur               19
3.6.2    Le rpertoire (directory) est la base de l'organisation d'un     19
         systme                                                     
3.6.3    Convention de noms pour les fichiers d'inclusion                 20
3.6.4    Fichiers gnrs localement                                      20
3.6.5    Fichiers exports pour les clients                               20
3.6.5.1  Le verbe export : extension au C                                 21
3.6.6    Unicit du fichier d'inclusion                                   21



1        Introduction et avertissements                              

    L'extracteur de prototypes automatise et agrmente une 
    partie du travail d'un programmeur en langage ANSI C et C++ 
    2.0. Il supporte aussi la syntaxe de dclaration de 
    fonctions K&R.

    Une version existe pour MSDOS (PCDOS) version 3 et plus, 
    pour SCO XENIX version 2.3 (UNIX systme V.3.2) et pour SUN 
    SPARC (Sunos).

    Ce manuel s'applique intgralement dans les trois 
    environnements. Toutefois, le sparateur / a t choisi pour 
    la spcification de fichiers dans le manuel. La version 
    MSDOS du logiciel reconnat le sparateur \ et non pas /.

1.1      Pourquoi utiliser un extracteur                             

    L'utilisation d'un extracteur de prototypes est facultative. 
    On peut inscrire manuellement les prototypes dans un fichier 
    d'inclusion. Le langage ANSI C tolre l'absence de prototype 
    pour conserver une compatibilit avec la version K&R du 
    langage. Le langage C++ commande l'usage de prototypes.

    Nous ne tenterons pas de dmontrer l'importance des 
    prototypes en programmation. Nous tenterons de dmontrer 
    pourquoi une extraction automatique par un outil spcialis 
    est requise.

1.1.1    Mise en service d'une librairie avec prototypes invalides   

    En rvisant une librairie, on doit parfois ajouter des 
    fonctions, en liminer et en modifier. Lorsqu'on livre une 
    nouvelle version d'une librairie, la fiabilit des 
    prototypes est essentielles. Souvent des problmes avec la 
    nouvelle version seront dtects par une autre quipe de 
    programmeurs, qui seront confondus par le fait que leur 
    projet compile parfaitement mais n'excute pas bien.

    En C ce problme peut prendre un temps considrable  
    rgler. La nouvelle version de la librairie sera la dernire 
     tre souponne. En C++ le problme sera dtect  l'tape 
    du "link". Cela introduira une perte de temps, et surtout 
    une insatisfaction vidente.

1.1.2    Validation implicite du fichier d'inclusion                 

    Un truc simple permet de vrifier que les prototypes 
    inscrits dans un fichier d'inclusion sont valides. Il s'agit 
    d'inclure ce fichier dans chacun des sources qui dclarent 
    ces fonctions. Une simple recompilation permettra de 
    comparer les prototypes  la dclaration originale.

    Cette mthode a toutefois un lacune. Elle ne dtecte pas 
    l'absence d'un prototype, ni ne dtecte la prsence de 
    prototypes de fonctions primes.



                                                              1


    En C++, cette mthode est simplement inutile, car plusieurs 
    fonctions peuvent porter le mme nom et possder des 
    arguments totalement diffrents.

1.1.3    Rvision des clients d'un service                           

    On doit parfois modifier les arguments d'une fonction 
    utilise dans divers autre sous-systme. Gnralement avant 
    de faire cela, le programmeur localisera toutes les usages 
    de cette fonction et les modifiera en consquence.

    Cela se fera souvent  l'aide du programme GREP. Cette 
    mthode n'est toutefois pas garantie. Il se peut que 
    certains systmes client soit innaccessibles  GREP (pas sur 
    le mme ordinateur), ou simplement inconnus du programmeur.

    Notez qu'en C++, la dtection des usages d'une fonction 
    membre  l'aide de GREP est pratiquement vou  l'chec. Il 
    faudra utiliser des rfrences croiss ou autre gadgets pour 
    dterminer qui se sert d'une fonction.

    Seul une recompilation de ces systmes clients exposera les 
    utilisations errons. Cette recompilation pourra se faire 
    plusieurs semaines, et mme plusieurs mois aprs la mise en 
    service de la librairie. La validit des prototypes est la 
    seule assurance.

1.2      Certains compilateurs peuvent extraire les prototypes       

    Certains compilateurs ont une option pour extraire les 
    prototypes tout en compilant. Une telle option pose 
    gnralement des problmes de performance et n'est utilise 
    qu'en dernier recours.

    L'extraction des prototypes doit tre ralise avant la 
    compilation; des prototypes valides sont essentiels. Si un 
    compilateur est utilis, deux sessions de compilation seront 
    ncessaires; une pour extraire les prototypes et une autre 
    pour compiler.

1.2.1    Un compilateur peut oublier des prototypes                  

    Si on utilise un compilateur pour extraire des prototypes, 
    on peut se retrouver avec un problme de taille. Le 
    compilateur peut stopper dlibrment la compilation d'un 
    source parce qu'ils rencontrent trop d'erreurs. Les 
    prototypes des fonctions qu'il n'a pas compil ne seront pas 
    gnrs.

    En fait plusieurs des erreurs rencontrs par le compilateur 
    seront causs par l'absence de prototypes valides.

2        Limites de la version d'valuation                          

    Le prsent manuel explique toutes les options de 
    l'extracteur.




                                                              2


    Certaines options ne sont pas disponibles dans la version 
    d'valuation. La licence explique comment on peut obtenir 
    une version complte.

    En plus d'obtenir la dernire version du logiciel, l'usager 
    recevra d'autres utilitaires. Ils sont documents ici. La 
    liste prsente ici est sujet  changement sans pravis.

2.1      Production automatise de sommaire alphabtique             

    Un utilitaire produit un sommaire. Pour chaque fonction, une 
    ligne de commentaires est extraite du source. La ligne 
    choisie est base sur une convention minimale.

    Le fichier produit est un texte dont le format est:

      fonction_a: description sommaire de fonction_a
      ...
      fonction_z: description sommaire de fonction_z

    La premire ligne du bloc de commentaire prcdant la 
    dclaration d'une fonction est extraite.

2.2      Production d'un index permut                               

    A partir du sommaire alphabtique, un index bas sur les 
    mots cls de la description est produit. Pour un sommaire 
    comportant les deux fonctions suivantes,

      bouton_creation: cration et initialisation d'un bouton
      bouton_annule: efface et limine un bouton de la mmoire

    Chacun des mots significatifs de la description seront tour 
     tour utiliss comme cl de tri. Il devient possible de 
    localiser une fonction en utilisant diffrents mots cls 
    (efface, limine, bouton, mmoire, cration, ...).

2.3      Production et entretien d'un historique des fonctions       

    Un fichier sera entretenu  partir du fichier de prototypes 
    et documentation produit par l'extracteur.

    L'historique est un fichier texte. Il contient une 
    description de chaques fonctions accompagnes de sa date de 
    cration ou de rvision. A chaque fois que le systme est 
    rvis, le fichier d'historique est mis  jour en ajoutant 
    les fonctions qui ont t rvises (bas sur une comparaison 
    ASCII du prototype document de la fonction), les nouvelles 
    fonctions et en notant les fonctions limines.

    Ce fichier permet  un programmeur de localiser rapidement 
    les nouveaux services, les services rviss et les services 
    qui ont t limins.

3        Spcifications et opration                                 



                                                              3


    Description des caractristiques de l'extracteur de 
    prototypes ANSI C. Ce manuel contient un guide d'opration 
    mais aussi des suggestions sur l'application de cet outils.

3.1      Principes gnraux                                          

    L'extracteur s'applique autant aux projets de quelques 
    fichiers sources qu'aux projets d'envergure: plusieurs 
    centaines de fichiers rpartis en plusieurs rpertoires.

3.1.1    Systmes, clients, et fournisseurs en programmation         

    Tout au long de ce manuel, nous utiliserons les mots 
    systmes, clients et fournisseurs.

    Un systme (package) est une collection de fonctions 
    intimement lies permettant la ralisation d'une tche 
    spcialise. Un exemple de systme est la srie de fonctions 
    str____() livre avec la majorit des compilateurs C 
    (strcmp, strlen, strcpy, strchr, ...). Ces fonctions 
    proposent gnralement un certain nombre de conventions ou 
    modles  l'usager (le programmeur). Le systme est un 
    fournisseur, et les sources qui le composent sont des 
    membres du systme.

    Le programmeur qui utilise ces fonctions pour raliser une 
    nouvelle fonction est un client de ce systme. Tout au long 
    de ce document, c'est la relation entre ces nouvelles 
    fonctions et les fonctions d'un systme qui sera tudie.

    Les fonctions cres  partir d'autres fonctions, sont des 
    clientes. Ces "autres" fonctions sont des fournisseurs. Ces 
    dernires font gnralement partie d'un systme (parfois 
    appel librairie).

3.1.2    Dclaration de fonction (prototypes) et dfinition          

    Une diffrence majeure entre le langage ANSI C et le C 
    original (K&R) est le concept de dclaration de fonction 
    (function prototype). C'est la possibilit de dcrire de 
    faon formelle l'interface d'une fonction sans fournir le 
    corps de cette fonction.

    Soit la dfinition de la fonction max():

      int max(int a, int b)
      {
          if (a<b) return (b);
          return (a);
      }

    Soit la dclaration de la fonction max():

      int max (int a, int b);




                                                              4


3.1.2.1  Utilit des dclarations de fonctions                       

    La dclaration d'une fonction permet d'informer le 
    compilateur sur l'interface d'une fonction, sans fournir la 
    fonction au complet. Cela permet de crer une fonction dans 
    un fichier source et de l'utiliser dans un autre en toute 
    scurit.

    Le compilateur aura toutes les informations pour dterminer 
    si l'utilisation (appel de la fonction) faite de cette 
    fonction est conforme. Il pourra vrifier le nombre 
    d'arguments ainsi que le type de chacun. Les appels  la 
    fonction max() seront tous signals par le compilateur. 
    Evidemment un prototype de la fonction devra tre fourni au 
    dbut du source.

      int max(int a, int b);

          ...
          char *pt = max ("xyz","zzz");   /* arguments invalides */
          int m = max (1,2,3);            /* nombre d'arguments invalide */

3.1.2.2  Stratgie d'utilisation des prototypes                      

    Gnralement on placera dans un fichier d'inclusion (*.h) 
    les prototypes de toutes les fonctions composant un systme 
    ou librairie. Plusieurs fichiers d'inclusion fournis avec le 
    compilateur que vous utilisez contiennent des prototypes de 
    fonctions.

    Les fonctions clientes (utilisant cette librairie) devront 
    inclure ce fichier d'inclusion au dbut du source.

    exemple:

      #include <string.h>

      ...
      char *pt = strlen("....."); /* strlen() est dclar dans string.h */

3.1.2.3  Composition du fichier d'inclusion                          

    Le fichier d'inclusion associ  un systme ne contiendra 
    pas ncessairement les prototypes de toutes les fonctions 
    contenues dans ce systme.

    Les fonctions "static" ne seront pas incluses, puisqu'elles 
    ne sont pas accessibles. Certaines fonctions internes non 
    plus, puisque souvent, elles ne sont ni documentes, ni 
    utilisables aisment par les sources clients d'une 
    librairie.





                                                              5


    Un fichier d'inclusion est donc cr avec le client en tte. 
    Un programmeur peut crer deux fichiers d'inclusion pour un 
    systme. Un sera utilis par les fonctions membres et 
    l'autre par les fonctions clientes. L'extracteur permet de 
    construire slectivement des fichiers d'inclusion.

3.2      ANSI C et C++ supports                                     

    L'extracteur reconnait la syntaxe C et C++. Aucune option 
    n'est requise. Quelques options permettent de traiter 
    spcifiquement certains dclarations tel les fonctions 
    membres C++.

3.3      Mot-cls ajouts pour automatiser l'opration de            
         l'extracteur                                                

    Le langage C++ ne permet pas d'extraire les prototypes d'une 
    faon compltement automatique. Pour sa part le langage C 
    possde un concept rudimentaire de controle de l'accs.

    Sept mot-cls sont interprts par l'extracteur pour 
    compltement controler la gnration des prototypes  partir 
    du source.

      export      C et C++
      _export     C et C++
      PRIVATE     C++
      PUBLIC      C++
      PROTECTED   C++
      STATIC      C++
      VIRTUAL     C++

3.3.1    Dfinition des mots cls supplmentaires                    

    Les mots cls export,_export,PRIVATE,PROTECTED,PUBLIC et 
    VIRTUAL ne sont pas supports par plusieurs compilateurs C 
    et C++. On devra fournir au prprocesseur une dfinition 
    nulle pour chacun de ces mot-cls.

    Un dfinition nulle peut s'exprimer directement sur la ligne 
    de commande (gnralement option -d du compilateur) ou dans 
    un fichier d'inclusion.

      #define export
      #define _export
      #define PUBLIC
      #define PRIVATE
      #define PROTECTED
      #define VIRTUAL

    Notez que _export est support par certain compilateurs.

3.4      Options de la ligne de commande                             





                                                              6


    Cette section dcrit la liste des options spcifiables sur 
    la ligne de commande. Une option est spcifie par un '-' 
    suivie d'une lettre suivie optionnellement d'une squence de 
    caractres non blancs:

      -x
      -ceoi
      -ffichier.nar

3.4.1    @fichier : fichier contenant des paramtres de ligne de     
         commande                                                    

    Si un paramtre de la ligne de commande dbute par @, il 
    sera interprt comme un nom de fichier. Ce fichier 
    contiendra lui-mme d'autres paramtres qui seront 
    interprts.

    Le fichier peut tre spcifi avec un rpertoire ou non. Si 
    le fichier est spcifi avec un rpertoire, ce rpertoire et 
    ses anctres seront utiliss jusqu' ce que le fichier soit 
    localis.

    Si aucun rpertoire n'est spcifi, le rpertoire courant 
    sera consult, et ses anctres ensuite.

    Ce mcanisme de localisation permet d'crire un seul fichier 
    qui sera applicable  plusieurs rpertoires. Il permet aussi 
    d'crire un fichier de paramtres qui sera spcifique  un 
    rpertoire.

3.4.1.1  Exemple de localisation de fichiers de commandes            

    Soit les rpertoires:

      /usr/prj1/liba
      /usr/prj1/libb
      /usr/prj1/libb/libb0
      /usr/prj1/libb/libb1
      /usr/prj1/libc
      /usr/prj2/liba
      /usr/prj2/libb
      /usr/prj2/libc

    Si on cr les fichiers d'option suivants.

      /usr/proto.cfg
      /usr/prj1/libb/proto.cfg
      /usr/prj2/libc/proto.cfg

    La liste suivante indique quel fichier de commande sera lu 
    si on applique "proto @proto.cfg" dans chaque rpertoire.






                                                              7


      /usr/prj1/liba          /usr/proto.cfg
      /usr/prj1/libb/libb0    /usr/prj1/libb/proto.cfg
      /usr/prj1/libb/libb1    /usr/prj1/libb/proto.cfg
      /usr/prj1/libc          /usr/proto.cfg
      /usr/prj2/liba          /usr/proto.cfg
      /usr/prj2/libb          /usr/proto.cfg
      /usr/prj2/libc          /usr/prj2/libc/proto.cfg
      /lib/prjx               ici la variable d'environnement PATH
                              sera consulte pour localiser proto.cfg
                              de la mme faon que les programmes
                              sont localiss.

3.4.1.2  @ spcifi sans fichier                                     

    Si le caractre @ apparat seul, le fichier 'proto.cfg' sera 
    cherch par dfaut. Il sera cherch dans le rpertoire 
    courant. S'il n'est pas trouv, le rpertoire anctre sera 
    cherch (..). La recherche se poursuivra jusqu' la racine 
    du disque.

    Lorsque les fichiers proto.cfg requis sont crs et placs 
    aux bons endroits dans un systme de rpertoire, la commande 
    "proto @" est suffisante pour extraire les prototypes de 
    n'importe quel systme.

3.4.2    -a : Accs par dfaut au fonctions membres (C++)            

    Les fonctions membres (d'une classe) qui ne spcifient pas 
    d'accs seront dclars "private". L'option -a permet 
    d'enregistrer un comportement diffrent.

      -a0 : private
      -a1 : protected
      -a2 : public

    L'accs d'une fonction membre se spcifie  l'aide d'un des 
    mots cls ajouts PRIVATE, PROTECTED, et PUBLIC.

3.4.3    -b : Mise  jour d'un fichier C++  partir d'un fichier .pm 

    Normalement, proto regroupe tous les prototypes des 
    fonctions membres d'une classe C++ dans un seul fichier 
    (voir -m0+,-m1+ et -c+). Ce fichier porte gnralement 
    l'extension ".pm". A partir de ce fichier, les prototypes 
    des fonctions membres sont distribus dans les fichiers qui 
    contiennent les dclarations des classes. L'option -b active 
    cette distribution.

    La syntaxe de l'option est:

      -bfichier__rviser+fichier_pm=fichier_rsultat
      -bfichier__rviser+fichier_pm
      -bfichier__rviser
      -b



                                                              8


    Si fichier_rsultat n'est pas spcifi, fichier__rviser 
    sera pris comme source et destination. Si fichier_pm n'est 
    pas spcifi, X.pm sera choisi (X est le nom du rpertoire 
    courant). L'option -b sans arguments sera quivalente  
    -bX.hpp+X.pm o -bX.h+X.pm o X est le nom du rpertoire 
    courant. X.h sera utilis si X.hpp n'existe pas.

    L'option -b peut tre utilis plusieurs fois (pour rviser 
    plusieurs fichier d'inclusion) sur la ligne de commande. Son 
    action ne sera dclenche qu'aprs l'extraction du dernier 
    prototype.

3.4.3.1  Exemple d'utilisation de l'option -b                        

    Soit la commande,

      proto -c+ -fx.pm *.c -bfichier1.h+x.pm -bfichier2.h+x.pm

    Le fichier x.pm sera produit. Il contiendra tous les 
    prototypes des fonctions membres. Ensuite les fichier 
    "fichier1.h" et "fichier2.h" seront dits et les prototypes 
    seront distribus dans la dclaration des classes dont ils 
    sont membres.

3.4.3.2  Controle de la distribution des prototypes de fonctions     
         membres                                                     

    Les prototypes des fonctions membres doivent tre distribus 
     l'intrieur de la dfinition de la classe dont ils sont 
    membres. L'extracteur utilise une mthode simple pour 
    localiser l'endroit o les prototypes sont placs.

    L'extracteur recherche des paires de commentaires de la 
    forme:

      /*~PROTOBEG~ NOM_DE_LA_CLASSE */
      /*~PROTOEND~ */

    Les commentaires doivent tre seuls sur leur ligne 
    respective. Tous ce qui est entre cette paire de 
    commentaires a t plac l par l'extracteur. Le programmeur 
    ne devra rien ajouter entre ces commentaires, puisque 
    l'extracteur annulera le contenu  chaque rvision du 
    fichier.

3.4.4    -c : composition de l'extraction                            

    PROTO peut extraire plusieurs informations des fichiers 
    sources qu'il traite. Voici la liste des informations qu'il 
    peut extraire avec la lettre qui servira  spcifier ces 
    informations.







                                                              9


      e : Prototypes des fonctions export (extension au langage C).
      o : Prototypes des fonctions ordinaires.
      p : Prototypes des fonctions membres C++ "private".
      r : Prototypes des fonctions membres C++ "protected".
      s : Prototypes des fonctions static.
      u : Prototypes des fonctions membres C++ "public".

      + : Prototypes des fonctions membres (C++).
      d : Documentations (commentaires) autour de ces fonctions.
      i : Rfrence inverse fonction vs source.

    La commande "proto -cod *.c" extraira les prototypes avec la 
    documentation qui les accompagne pour tous les fichiers *.c 
    du rpertoire courant.

3.4.4.1  Le verbe export : extension au C                            

    Le verbe export est un ajout au langage C. A notre 
    connaissance aucun compilateur C ne supporte un tel verbe. 
    Ce verbe est prsentement appliqu  la dclaration de 
    fonctions, mais peut aussi s'appliquer  la dclaration de 
    types, de constantes, de variables, etc...

    Le verbe export a un usage un peu quivalent au verbe 
    static. Ce dernier restreint la visibilit d'un objet au 
    source o il apparat. Le verbe export, au contraire, 
    indique que la visibilit d'un objet dpasse le cadre du 
    systme o il est dfini. Une fonction 'export' est un 
    service officiel offert aux clients. Une fonction ordinaire 
    est local au systme et ne doit pas tre utilise 
    directement par une fonction cliente du systme.

3.4.4.1.1Ajout du verbe export au langage C                          

    En utilisant le prprocesseur, il est possible d'ajouter le 
    verbe export au language. On inscrit simplement la ligne 
    "#define export" dans un fichier d'inclusion. Ce fichier est 
    inclus dans les sources qui font usage du verbe.

    On peut aussi dfinir ce verbe sur la ligne de commande  
    l'aide de l'option -d du compilateur. La plupart des 
    compilateurs supportent une option -d de la mme faon que 
    l'extracteur.

3.4.4.1.2Utilit du verbe export                                     

    Bien que non support par le compilateur, ce verbe permet de 
    classifier les fonctions d'un systme. Cela simplifie la vie 
    des clients  la recherche d'un service. Gnralement la 
    liste des fonctions offertes aux clients reprsente moins de 
    la moiti des fonctions du systme. Cela simplifie autant 
    l'usage que l'entretien du systme.

3.4.4.1.3Le verbe _export                                            




                                                             10


    Le verbe _export devient une extension populaire au language 
    C. Il facilite la ralisation de librairies dynamiques. Il a 
    smantiquement le mme rle que le verbe export dcris plus 
    haut. Les deux verbes sont accept comme synonimes.

3.4.4.2  Combinaison de l'option -c et -f dans une seule session     

    Les options -c et -f peuvent tre spcifies plusieurs fois 
    sur la ligne de commande.

    L'option -c tablie une composition de rsultat valide pour 
    toutes les options -f qui suivent, et ce jusqu' la 
    prochaine option -c.

    La commande "proto -co -fordin.h -cs -fstatic.h -cod 
    -finfo.h *.c" produira trois fichiers de composition 
    diffrente. On sauve du temps  gnrer plusieurs fichiers 
    simultanment.

3.4.4.3  Paramtre 'i' de l'option -c: Rfrence inverse             

    Le paramtre 'i' de l'option -c produit une rfrence 
    inverse fonction -> sources. D'un format compact, le fichier 
    permet de dterminer le source qui contient la dclaration 
    d'une fonction.

    Le fichier est un texte ASCII o chaque ligne a la forme 
    suivante:

      longueur!nom_de_la_fonction!source

    Les points d'exclamation '!' sont prsents dans le fichier, 
    comme sparateur. La longueur est la dimension (en octet) de 
    la ligne. Cette longueur est encode en un seul octet. Pour 
    ne pas nuire  la nature 'texte' du fichier, la constante 32 
    est ajoute  cette longueur.

    Un format texte a t choisi pour simplifier la ralisation 
    de fonction de recherche. Une telle fonction peut tre code 
    directement  partir du langage macro de certains diteurs.

3.4.4.4  Paramtre 'd' de l'option -c: Prototypes et documentation   

    Le paramtre 'd' commande l'extraction des prototypes ainsi 
    que des commentaires entourant la dclaration de la 
    fonction.

    Tous les commentaires contigus qui prcdent immdiatement 
    la dclaration ainsi que tous rencontrs avant la premire 
    '{' du corps de la fonction seront extrait et placs avec le 
    prototype.

    Le format du fichier produit n'est pas compilable. Ce 
    fichier peut tre utilis comme sommaire d'un systme.

3.4.4.5  Corrections au prototypes avant la gnration               



                                                             11


    On peut omettre certaines informations lors de la 
    dclaration d'une fonction. L'extracteur ajoute ce qui 
    manque pour produire un prototype valide.

3.4.4.5.1Fonctions sans type de retour                               

    Si une fonction est dclar sans type, l'extracteur ajoute 
    'int' au prototype. La dclaration suivante:

      max(int a, int b){....}

    produit le prototype suivant:

      int max (int a, int b);

3.4.4.5.2Paramtres sans type                                        

    Si un paramtre apparait sans type, le mot-cl 'int' est 
    insr.

    Soit la fonction suivante:

      int max (a,b){ ... }

    Le prototype produit sera:

      int max (int a, int b);

3.4.4.5.3Fonctions sans paramtre                                    

    Le mot cl 'void' sera automatiquement insr dans le 
    prototype d'une fonction sans paramtres, s'il n'est pas 
    dj prsent. La dclaration suivante produit:

      int fct (){ ... }

    produit:

      int fct (void);

3.4.5    -C : Ne traite pas les commentaires imbriqus               

    Proto permet les commentaires imbriqus. L'option -C annule 
    ce comportement.

3.4.6    -D : Dfinition de symbole sur la ligne de commande         

    L'option -D permet de dfinir des symboles du prprocesseur 
    directement sur la ligne de commande.





                                                             12


    L'option "-Dsymxxx" est quivalente  la ligne "#define 
    symxxx".

    L'option "-Dsymxxx=yyy" est quivalente  "#define symxxx 
    yyy".

3.4.7    -e : Ferme un fichier rsultat                              

    L'option -e est utilise aprs l'option -f (+f) et termine 
    l'usage de ce fichier comme fichier rsultat. Il est donc 
    possible de produire en une seule session plusieurs fichiers 
    qui ont des contenus compltement diffrents.

    Exemple: proto -ffichier1 a*.c -efichier1 -ffichier2 *.c

    Ici, "fichier1" ne contiendra que les prototypes de fonction 
    des fichiers "a*.c". "fichier2" contiendra pour sa part 
    toutes les autres fonctions. Si l'option -e n'avait pas t 
    utilis, "fichier1" contiendrait toutes les fonctions des 
    fichiers "a*.c" en plus de ceux contenus dans "fichier2".

3.4.7.1  Protection contre le double traitement durant une session   

    L'extracteur ne retraitera pas deux fois le mme fichier 
    lors d'une session. Cela permet de traiter une srie de 
    fichier avec une combinaison d'options et de traiter les 
    autres avec une autre combinaison.

    La squence suivante permet d'associer une combinaison 
    spcifique au fichier xyz.c.

    proto -option ... -option xyz.c -option ... -option *.c

    Bien que *.c inclue xyz.c, celui-ci ne sera pas trait deux 
    fois.

3.4.7.1.1Fichiers sources rpartis dans deux rpertoires             

    Une mthodologie applicable aux projets en groupe permet de 
    sauver de l'espace disque. Souvent les sources d'un projet 
    sont placs dans un rpertoire rfrence. Le programmeur 
    importe dans un rpertoire personnel uniquement les sources 
    qu'il modifie. Ce mcanisme est souvent ralis par 
    l'diteur qui lit les fichiers dans le rpertoire rfrence 
    et les sauve dans le rpertoire personnel lorsque modifis.

    Soit le projet X dont les sources sont placs dans le 
    rpertoire /usr/src/x. Soit le programmeur 'prog' qui rvise 
    le projet. Les sources sont imports graduellement dans le 
    rpertoire /usr/prog/x.

    La commande "proto *.c /usr/src/x/*.c" applique dans le 
    rpertoire /usr/prog/x produira les prototypes du projet X. 
    La protection contre le double traitement est applique sur 
    le nom des fichiers et non pas sur l'accs (path).

3.4.8    -f/+f : identification d'un fichier rsultat                



                                                             13


    L'option -f peut tre utilise plusieurs fois sur la ligne 
    de commande. En une seule session, proto peut produire 
    plusieurs fichiers.

    L'option est suivi du nom du fichier qui sera produit. 
    L'option -f cre le fichier. L'option +f ajoute  la fin du 
    fichier.

    Le nature du fichier cr dpend de la dernire composition 
    tablie par l'option -c.

    ex : "proto -cos -ffichier.p *.c" produira "fichier.p" avec 
    tous les prototypes des fonctions ordinaires et static du 
    rpertoire courant.

3.4.8.1  Combinaison de l'option -c et -f dans une seule session     

    Les options -c et -f peuvent tre spcifies plusieurs fois 
    sur la ligne de commande.

    L'option -c tablie une composition de rsultat valide pour 
    toutes les options -f qui suivent, et ce jusqu' la 
    prochaine option -c.

    La commande "proto -co -fordin.h -cs -fstatic.h -cod 
    -finfo.h *.c" produira trois fichiers de composition 
    diffrente. On sauve du temps  gnrer plusieurs fichiers 
    simultanment.

3.4.9    -h : fichier de prototypes C++  dcomposer                 

    L'option -h commande la dcomposition d'un fichier de 
    prototypes C++ contenant des fonctions membres (class 
    member). Autant de fichier que de classes rencontrs seront 
    produits. Le nom de ces fichiers sera obtenu en utilisant le 
    nom de la classe (potentiellement tronqu) suivit de 
    l'extension ".pp".

    Ces fichiers pourront tre sous-inclus dans les fichiers 
    d'inclusion dclarant les classes.

    -h est suivit sans espace par le nom du fichier  
    dcomposer. -h sans argument commande la dcomposition du 
    fichier ".pm" ayant le mme nom que le rpertoire courant.

    La dcomposition dmarera aprs l'extraction du dernier 
    prototype.

    L'option -h peut tre utilis plusieurs fois sur la ligne de 
    commande.

3.4.10   -i : Mode incrmental                                       








                                                             14


    Lorsque l'option -i est spcifie, proto vrifie si les 
    fichiers  gnrer existent dj. Si oui, il les relie. 
    Lorsque vient le temps de gnrer les prototypes d'un 
    source, il vrifie si ce dernier a chang depuis la dernire 
    gnration. Les fichiers produits par proto contiennent la 
    date de chaque fichiers sources. Si les dates sont 
    semblables, le fichier source n'est pas trait.

    Cela acclre significativement le traitement.

3.4.11   -I : Rpertoire de recherche pour les fichiers d'inclusion  

    L'option -I indique la liste des rpertoires  consulter 
    pour localiser les fichiers d'inclusion (directive 
    #include).

    L'option -I peut apparatre plusieurs fois sur la ligne de 
    commande. On peut spcifier plusieurs rpertoires en une 
    seule fois, en sparant ces rpertoires avec un ':'.

    ex: -I/usr/include:/include <==> -I/usr/include -I/include

3.4.12   -k : Renomme les mot-cls reconnus par l'extracteur         

    Certains mot-cls reconnus par l'extracteur ne sont pas 
    supports par tous les compilateurs (export, PUBLIC, 
    PRIVATE, ...). Le programmeur doit donc fournir une 
    dfinition nulle au prprocesseur pour que la prsence de 
    ces mots cls soit tolre par le compilateur.

    Ces mot-cls peuvent crs des conflits avec des noms de 
    variables ou de type dj existant. Il est possible de 
    renommer ces mots cls ou simplement d'en annuler le sens 
    vue de l'extrateur.

    L'option -kxxx=yyy renomme le mot-cl xxx  yyy. L'option 
    -kxxx annule le mot-cl xxx. L'option -k peut tre utilise 
    plusieurs fois sur la ligne de commande.

    Soit l'exemple suivant o le verbe export entre en conflit 
    avec un typedef existant dans le programme. L'option 
    -kexport=EXPORT aura l'effet suivant: L'extracteur ne 
    reconnaitra plus le mot export comme un mot cl, tandis que 
    le mot EXPORT rcuprera le rle attribu normalement au 
    mot-cl export. Ainsi l'nonc suivant sera acceptable.

    EXPORT export *fct (void);

3.4.13   -l : Spcification d'un nom alternatif pour l'option -h     

    Lors de l'application de l'option -h, tous les fichiers 
    produits auront un nom compos du nom de la classe suivit de 
    l'extension .pp. Le nom d'une classe pourra tre tronqu 
    pour satisfaire les limites du systme d'exploitation. Il 
    est possible que deux classes entrent en conflit.





                                                             15


    L'option -l force l'extracteur  utiliser un autre nom. Ce 
    nom pourra contenir ou pas un extension.

    Ex: proto -m0+ -lCLASS_SPEC1=class1.pp 
    -lCLASS_SPEC2=class2.pp *.c -h

    Les prototypes des fonctions membres de la classe 
    CLASS_SPEC1 se retrouveront dans class1.pp et ceux de 
    CLASS_SPEC2 dans class2.pp.

3.4.14   -m : Slectionne une mthodologie particulire              

    -m0 : mthodologie pour projets  un seul rpertoire

      "proto -m0 *.c" appliqu dans le rpertoire X est quivalent 
      "proto -ceo -fX.p -ceod -fX.nap -ceoi -fX.nar *.c"

    -m1 : mthodologie pour projets  plusieurs rpertoires

      "proto -m1 *.c" appliqu dans le rpertoire X est quivalent 
      "proto -ceo -fX.p -ce  -f../include/X.p
          -ceod -fX.nap -ced -f../doc/X.nap
          -ceoi -fX.nar -cei -f../doc/X.nar *.c"

3.4.14.1 Rpertoires alternatifs pour l'exportation des fichiers     
         rsultat                                                    

    Par dfaut l'option -m1 exporte vers les rpertoires 
    ../include et ../doc.

    Si le rpertoire ../include n'existe pas, le rpertoire ../h 
    est utilis. Au moins un des deux rpertoires doit exister 
    pour que l'option -m1 excute correctement.

3.4.15   -o : Nom alternatif pour l'option -m                        

    L'option -m compose le nom des fichiers resultats  partir 
    du nom du rpertoire courant. L'option -o permet de 
    spcifier un autre nom

3.4.16   -p : Activation de l'extraction pour les fichiers suivants  

    Cette option est utilise aprs l'option -x. Elle ractive 
    l'extraction des prototypes pour les fichiers suivants.

    Par dfaut, l'extraction est active.

3.4.16.1 Exemple d'utilisation des options -x et -p                  

    Certains fichiers C ne comportent aucun prototypes 
    intressants. Certains fichiers sont produit par des 
    gnrateurs d'crans, de rapports, etc ... ne comportent que 
    des tableaux et constantes. Ces fichiers sont souvent trs 
    gros. Il est intrressant de les viter lors de l'extraction 
    dans le simple but de sauver du temps.



                                                             16


    Soit les fichiers ecran1.c et ecran2.c que l'on veut viter. 
    La commande "proto -x ecran1.c ecran2.c -p *.c" extraira les 
    prototypes de tous les fichiers sauf ceux-l.

3.4.16.2 Protection contre le double traitement durant une session   

    L'extracteur ne retraitera pas deux fois le mme fichier 
    lors d'une session. Cela permet de traiter une srie de 
    fichier avec une combinaison d'options et de traiter les 
    autres avec une autre combinaison.

    La squence suivante permet d'associer une combinaison 
    spcifique au fichier xyz.c.

    proto -option ... -option xyz.c -option ... -option *.c

    Bien que *.c inclue xyz.c, celui-ci ne sera pas trait deux 
    fois.

3.4.17   -P : activation du prprocesseur                            

    Normalement proto ne fait pas l'expansion macro. Il ne fait 
    pas la lecture des fichiers d'inclusion. Cela permet  proto 
    de rgnrer des sources (option -g) et aussi d'extraire les 
    prototypes trs rapidement.

    Gnralement, le fait d'ignorer les commandes du 
    prprocesseur n'a aucun effet sur les fichiers produits. Il 
    existe quelques exceptions o le prprocesseur est essentiel 
     la comprhension des dclarations.

    L'option -P active un prprocesseur complet ANSI C 
    (construit dans PROTO). Les options -I et -d devront tre 
    utilises en combinaison.

    L'option -g (rgnration du source) perdra toute 
    signification.

3.4.17.1 Traitement des #define mme lorsque le prprocesseur n'est  
         pas actif                                                   

    Les dfinitions des commandes #define sont enregistres mme 
    si l'expansion macro n'est pas actif (option -P). Cela 
    permet d'valuer les commandes #if, #ifdef, et #ifndef.

    Les commandes #undef sont aussi interprtes dans le mme 
    but.

3.4.17.2 Traitements des #if, #ifdef, ... sans -P                    

    Lorsque le prprocesseur n'est pas actif, il n'est pas 
    toujours possible de slectionner adquatement la section de 
    code  analyser. Comme les fichiers d'inclusion ne sont pas 
    lus, la valeur des macros (#define) n'est pas toujours 
    connue. L'option -d permet de dfinir des macros directement 
    sur la ligne de commande.




                                                             17


3.4.18   -s : opration silencieuse                                  

    Normalement proto prsente un rapport pour chaque fichier 
    produit, indiquant la composition (option -c) en vigueur 
    pour ce fichier.

    L'option -s rend proto silencieux.

3.4.19   -t : lecture du source  traiter sur la console             

    L'option -t force proto  lire un source sur l'entre 
    standard (gnralement la console). Cela permet de faire des 
    tests rapidement.

    La commande "proto -cxxxx -t" permet de vrifier le 
    comportement de proto pour certaines combinaisons.

3.4.20   -v : Liste des fichiers traits                             

    L'option -v commande l'affichage de tous les fichiers 
    traits par proto.

3.4.21   -x : exclusion d'un groupe de fichier                       

    Tous les fichiers spcifis aprs l'option -x seront exclus 
    du traitement. L'option -p renverse cet tat.

    la commande "proto -x xxxx.c -p *.c" gnre les prototypes 
    de tous les fichiers *.c sauf le fichier xxxx.c.

3.4.21.1 Exemple d'utilisation des options -x et -p                  

    Certains fichiers C ne comportent aucun prototypes 
    intressants. Certains fichiers sont produit par des 
    gnrateurs d'crans, de rapports, etc ... ne comportent que 
    des tableaux et constantes. Ces fichiers sont souvent trs 
    gros. Il est intrressant de les viter lors de l'extraction 
    dans le simple but de sauver du temps.

    Soit les fichiers ecran1.c et ecran2.c que l'on veut viter. 
    La commande "proto -x ecran1.c ecran2.c -p *.c" extraira les 
    prototypes de tous les fichiers sauf ceux-l.

3.4.21.2 Protection contre le double traitement durant une session   

    L'extracteur ne retraitera pas deux fois le mme fichier 
    lors d'une session. Cela permet de traiter une srie de 
    fichier avec une combinaison d'options et de traiter les 
    autres avec une autre combinaison.

    La squence suivante permet d'associer une combinaison 
    spcifique au fichier xyz.c.

    proto -option ... -option xyz.c -option ... -option *.c

    Bien que *.c inclue xyz.c, celui-ci ne sera pas trait deux 
    fois.



                                                             18


3.4.22   Macros et Caractres spciaux                               

    Certains caractres et combinaisons de caractres auront une 
    interprtation particulire. Cela permettra de crer des 
    commandes gnrales dans des fichiers batch.

3.4.22.1 $ : Nom du rpertoire courant                               

    Le nom du rpertoire courant est rgulirement utilis pour 
    composer des noms de fichier ou de rpertoire. Certaines 
    mthodologies spcifient que les prototypes d'un rpertoire 
    doivent tre placs dans un fichier portant le nom de ce 
    rpertoire plus une extension.

    Si on veut crer une commande gnrale, on doit pouvoir 
    automatis la gnration du nom.

    Le caractre $ dans la ligne de commande sera remplac par 
    le nom du rpertoire courant.

    "proto -co -f$.p -cod -f$.nap -coi -f$.nar *.c" sera 
    quivalent  "proto -m0 *.c".

3.5      Combinaisons invalides d'options                            

    Plusieurs options sont disponibles sur la ligne de commande. 
    Plusieurs combinaisons n'ont aucun sens.

    Certaines combinaisons invalides sont dtectes et un 
    message d'erreur est spcifi. Certaines combinaisons 
    gnreront des rsultats compltement inutiles.

3.6      Stratgie d'utilisation de l'extracteur                     

    L'utilisation de l'extracteur de prototypes est relativement 
    simple. On applique proto sur un certain nombre de fichier 
    source et on obtient un ou plusieurs fichier d'inclusion.

    Beaucoup d'efforts ont t faits pour conserver  proto un 
    caractre gnral. Le nombre d'options disponibles en est un 
    tmoin.

    Nous allons suggrer une approche fonctionnelle applicable 
    autant au petit projet (1 seul rpertoire de source) qu' un 
    projet plus important.

3.6.1    Convention d'utilisation: Avertissement au lecteur          

    Les conventions qui suivent ne sont pas absolues. Nous les 
    jugeons acceptables et pratiques. Ces conventions 
    proviennent de l'exprience tire de plusieurs projets de 
    diverses dimensions.

    Les suggestions et amliorations sont bienvenues.

3.6.2    Le rpertoire (directory) est la base de l'organisation d'un
         systme                                                     



                                                             19


    Un systme est gnralement compos de plusieurs sources (10 
    @ 30). Un systme complexe peut tre compos de plusieurs 
    rpertoires. En fait ce systme est compos de 
    sous-systmes.

    Vu d'un client, un systme qu'il soit complexe ou pas, 
    provient d'un seul rpertoire. En fait, un client ne doit 
    pas savoir si un systme est complexe ou pas.

    Nous proposons donc qu'un rpertoire corresponde  un 
    systme. A ce rpertoire sera associ une librairie (*.lib) 
    et un fichier d'inclusion.

3.6.3    Convention de noms pour les fichiers d'inclusion            

    Dans un but de simplicit d'utilisation et de ralisation 
    nous proposons une convention pour slectionner le nom des 
    fichiers d'inclusion.

    Le nom du rpertoire sera choisi comme base du nom des 
    fichiers d'inclusion. Pour un systme plac dans un 
    rpertoire X, le nom des fichiers d'inclusions seront "X.*".

    Cette convention vise les fichiers qui sont offert aux 
    systmes clients.

3.6.4    Fichiers gnrs localement                                 

    L'option -m0 permet de gnrer localement 3 fichiers. Pour 
    un rpertoire X, les fichier X.p, X.nap et X.nar. L'option 
    -m1 gnre les mmes fichiers en plus d'exporter trois 
    autres.

    X.p contient les prototypes. Ce fichier sera sous-inclus par 
    le fichier X.h  l'aide de la commande '#include "X.p"'. Les 
    prototypes sont placs normalement directement dans le 
    fichier X.h. Ce fichier contient en plus des prototypes, 
    diverses dfinitions et dclarations. Comme l'extracteur ne 
    peut pas produire les prototypes directement dans X.h sans 
    en dtruire le contenu, un autre fichier doit tre produit 
    et inclus dans X.h.

3.6.5    Fichiers exports pour les clients                          

    L'option -m1 exporte trois fichiers en plus de produire 
    trois fichiers localement. Pour un rpertoire X, un fichier 
    X.p sera produit dans le rpertoire ../include et les 
    fichiers X.nap et X.nai seront produit dans le rpertoire 
    ../doc. En fait, ces fichiers portent les mmes noms que les 
    fichiers produits localement. Ce sont des versions 
    restreintes (elles contiennent moins de fonctions) des 
    fichiers locaux.

    L'utilisation du verbe 'export' au dbut de la dclaration 
    d'une fonction permet de spcifier les fonctions qui doivent 
    tre offertes aux clients.




                                                             20


3.6.5.1  Le verbe export : extension au C                            

    Le verbe export est un ajout au langage C. A notre 
    connaissance aucun compilateur C ne supporte un tel verbe. 
    Ce verbe est prsentement appliqu  la dclaration de 
    fonctions, mais peut aussi s'appliquer  la dclaration de 
    types, de constantes, de variables, etc...

    Le verbe export a un usage un peu quivalent au verbe 
    static. Ce dernier restreint la visibilit d'un objet au 
    source o il apparat. Le verbe export, au contraire, 
    indique que la visibilit d'un objet dpasse le cadre du 
    systme o il est dfini. Une fonction 'export' est un 
    service officiel offert aux clients. Une fonction ordinaire 
    est local au systme et ne doit pas tre utilise 
    directement par une fonction cliente du systme.

3.6.6    Unicit du fichier d'inclusion                              

    Pour un rpertoire X, il existe un fichier X.h. Tous les 
    sources du rpertoire X l'inclue. Ce fichier incluant 
    lui-mme X.p, tous les sources ont accs aux prototypes de 
    toutes les fonctions du rpertoire X. Le fichier X.h 
    contient l'nonc '#include "X.p"'.

    Si le rpertoire X est un sous-systme, le fichier X.h ou 
    une portion de celui-ci est export dans le rpertoire 
    ../include. Il devient disponible aux systmes clients. 
    Lorsque qu'un source d'un systme client inclut 
    ../include/X.h, celui-ci inclut ../include/X.p.

    Les clients ont accs aux prototypes de toutes les fonctions 
    'export' du systme X. De plus, les fichier ../doc/X.nap et 
    ../doc/X.nai peuvent tre consults pour obtenir plus 
    d'information sur le systme X.

    Le fichier X.h conceptuellement unique offre une vision 
    diffrente aux clients et aux sources du rpertoire X.
