//CRT.H
//Video Handling Functions Header File
//ver 2.1

#if !defined (__CRT_H)
#define __CRT_H

#if !defined( __DEFS_H)
#include <_defs.h>
#endif

#ifndef NULL
#include <_null.h>
#endif

#ifdef CRT_FULL
#define SAVECRT
#define RESTORECRT
#define SAVECRTWIN
#define RESTORECRTWIN
#endif

	/* * * DATA TYPES * * */

struct crtwin
 {
	int left;
	int top;
	int right;
	int bottom;
 };

struct crtwin_inp
 {
	char *title; //Title (if s==NULL doesn't print title)
	int tcolor; //Title color
	int fchr;   //character used to fill window internal area
	int fcolor; //internal window area color
	int bcolor; //border color
	int btype;  //border type, same as crtframe
 };

	/* * * ENUMS AND DEFINES * * */

#if !defined(__COLORS)
#define __COLORS

enum CRT_COLORS{
	BLACK,			//dark colors
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	BROWN,
	LIGHTGRAY,
	DARKGRAY,		//light colors
	LIGHTBLUE,
	LIGHTGREEN,
	LIGHTCYAN,
	LIGHTRED,
	LIGHTMAGENTA,
	YELLOW,
	WHITE,
	BKCOLOR,			//selects background color if multiplied by a dark color
	TEXTBLINK = 128	//text blink bit
};
#else

#define BKCOLOR 16
#define TEXTBLINK 128

#endif

//macros to be used  with setdacpgmode
#define DACPAGE_64 0
#define DACPAGE_16 1

//macros to be used with changechar
#define CHANGCHR_NORM 0x1100
#define CHANGCHR_RECALC 0x1110

	/* * * GLOBAL VARIABLES * * */

extern int _Cdecl vmode_x; //number of columns in text mode (default=80)
extern int _Cdecl vmode_y; //number of rows in text mode (default=25)
extern int _Cdecl vmode_mode; //video mode expected by CRT functions (default=3)
extern int _Cdecl crt_direct; //set BIOS use if != 0. (default=0)
extern int _Cdecl crt_page; //selects the text page that must be used by
									 //functions
extern int _Cdecl crtwin_just; //used by printsj...
extern struct crtwin _Cdecl crtwin_dta; //used by printsj... and crtwindow

extern char far * _Cdecl video_addr; //base VIDEO RAM address
extern const char _Cdecl crtframe_mat[]; //array used by crtframe
extern const char _Cdecl mkline_mat[]; //array used by mkline

extern int _Cdecl changechar_height; //used by changechar
extern int _Cdecl changechar_func; //and changecharg
extern int _Cdecl changechar_blk;

extern int _Cdecl crt_EVGA_addr; //EGA/VGA adapter base address
	//primary = 3C0h    alternate = 2C0h

	/* * * FUNCTIONS * * */

#ifdef __cplusplus
extern "C" {
#endif
void		_Cdecl	crt_detect	(int mode);
void		_Cdecl	crt_init		(int mode);
void		_Cdecl	videomode (int newmode);
void 		_Cdecl	setcrtmode (int mode);
int 		_Cdecl	getcrtmode (void);
void 		_Cdecl	setcrtpage (int page);
void		_Cdecl	crt_gotoxy	(int  x, int y );
int		_Cdecl	crt_getxy	(int *x, int *y);
int		_Cdecl	getcrtchar	(int  x,	int y );
int		_Cdecl	getcrtcolor (int  x, int y );
void		_Cdecl	biosprintc  (int chr, int x, int y, int color, int func);
void		_Cdecl	printcn	(int c, int x, int y);
void		_Cdecl	printc	(int c, int x, int y, int color);
void		_Cdecl	changecolor (int x, int y, int color);
void 		_Cdecl	printct	(int c, int x, int y, int color, unsigned int type);
void		_Cdecl	printsn	(char *s, int x, int y);
void		_Cdecl	prints	(char *s, int x, int y, int color);
void		_Cdecl	printxy	(char *s, int x, int y, int dx, int dy, int color);
void		_Cdecl	printx	(char *s, int x, int y, int color);
int  		_Cdecl	printtext (char *s, int x, int y, int color);
void 		_Cdecl	printsj	(char *s, int y, int color);
void 		_Cdecl	printsjc (char *s, int y, int color);
int 		_Cdecl	printsnf	(int x, int y,					char *fmt,... );
int 		_Cdecl	printsf	(int x, int y, int color,	char *fmt,... );
int 		_Cdecl	printxyf (int x, int y, int dx, int dy, int color, char *fmt,... );
int 		_Cdecl	printxf	(int x, int y, int color, 	char *fmt,... );
int 		_Cdecl	printtextf	(int x, int y, int color, char *fmt,... );
int 		_Cdecl	printsjf 	(int y, int color, char *fmt,... );
int 		_Cdecl	printsjcf	(int y, int color, char *fmt,... );
void		_Cdecl	fillscr	(int c, int color);
void 		_Cdecl	barcolor (int xi, int yi, int xf, int yf, int color);
void		_Cdecl	fillbar	(int c, int xi, int yi, int xf, int yf, int color);
void 		_Cdecl	fillbarw (int c, int color);
void 		_Cdecl	fillbox	(int c, int xi, int yi, int xf, int yf, int color, int func);
void		_Cdecl	fillboxw (int c, int color, int func);
void		_Cdecl	crtframe	(int xi, int yi, int xf, int yf, int color, unsigned int type);
void		_Cdecl	crtframew(int color, unsigned int type);
void		_Cdecl	mkline_aux 	(int cnt, int var, unsigned int mode, int pos, int color);
void		_Cdecl	mkline		(int cnt, int bgn, int end, int color, unsigned int mode);
void 		_Cdecl	crtwindow 	(struct crtwin_inp p0);
char far *_Cdecl	savevideo		(char far *s);
char far *_Cdecl	restorevideo	(char far *s);
char far *_Cdecl	savevideowin	(char far *s, int xi, int yi, int xf, int yf);
char far *_Cdecl	restorevideowin(char far *s, int xi, int yi, int xf, int yf);
char far *_Cdecl	savevideow		(char far *s);
char far *_Cdecl	restorevideow	(char far *s);

#ifdef SAVECRT
char far *_Cdecl	savecrt			(char far *s, int mode);
#define savevideo(s) savecrt(s,0)
#endif

#ifdef RESTORECRT
char far *_Cdecl	restorecrt		(char far *s, int mode);
#define restorevideo(s) restorecrt(s,0)
#endif

#ifdef SAVECRTWIN
char far *_Cdecl  savecrtwin		(char far *s, int xi, int yi, int xf, int yf, int mode);
char far *_Cdecl	savecrtw			(char far *s, int mode);
#define savevideowin(s,xi,yi,xf,yf) savecrtwin(s,xi,yi,xf,yf,0)
#define savevideow(s) savecrtw(s,0)
#endif

#ifdef RESTORECRTWIN
char far *_Cdecl  restorecrtwin	(char far *s, int xi, int yi, int xf, int yf, int mode);
char far *_Cdecl	restorecrtw		(char far *s, int mode);
#define restorevideowin(s,xi,yi,xf,yf) restorecrtwin(s,xi,yi,xf,yf,0)
#define restorevideow(s) restorecrtw(s,0)
#endif

void	_Cdecl	crt_clrscr (void);
void	_Cdecl	setcursorsh (unsigned int shape);
int	_Cdecl	getcursorsh (void);
int 	_Cdecl	getpalreg (int regpal);
void 	_Cdecl	setpalreg (int regpal, int val);
int 	_Cdecl	getbordercolor (void);
void	_Cdecl	setbordercolor (int val);
void	_Cdecl	getdacreg (int dacreg, char *red, char *green, char *blue);
void	_Cdecl	setdacreg (int dacreg, char red, char green, char blue);
void	_Cdecl	setdacpgmode	(int pgmode);
void	_Cdecl	setdacpage		(int page);
int 	_Cdecl	getdacpgstate 	(void);
void	_Cdecl	setchrboxwidth	(int cmd);
void	_Cdecl	settextblink	(int cmd);
void	_Cdecl	changechar	(unsigned char *fmt, int ind, int qt);
void	_Cdecl	changecharg (unsigned char *fmt, int rows);
void	_Cdecl	crtfontspec (int blkspec);
#ifdef __cplusplus
}
#endif

//CRT MACROS

	//crtframe macros
#define moldura(xi,yi,xf,yf,color)\
	crtframe(xi,yi,xf,yf,color,0)	//draws a text frame with single outline
#define moldurad(xi,yi,xf,yf,color)\
	crtframe(xi,yi,xf,yf,color,1) //draws a text frame with double outline

	//crtframew macros
#define molduraw(color)\
	crtframew(color,0)
#define molduradw(color)\
	crtframew(color,1);

	//mkline macros
#define linha_hor(y,xi,xf,color)\
	mkline(y,xi,xf,color,0) //draws a single horizontal line
#define linha_ver(x,yi,yf,color)\
	mkline(x,yi,yf,color,1) //draws a single vertical line
#define linhad_hor(y,xi,xf,color)\
	mkline(y,xi,xf,color,2) //draws a double horizontal line
#define linhad_ver(x,yi,yf,color)\
	mkline(x,yi,yf,color,3) //draws a double horizontal line

	//macro setcrtwin
#define setcrtwin(xi,yi,xf,yf)\
	 crtwin_dta.left=xi;\
	 crtwin_dta.top=yi;\
	 crtwin_dta.right=xf;\
	 crtwin_dta.bottom=yf	//easely loads values to crtwin_dta

	//crtwindow macros
#define janela(p0)\
	p0.btype=0;\
	crtwindow(p0)	//draws a window with single outline
#define janelad(p0)\
	p0.btype=1;\
	crtwindow(p0)	//draws a window with double outline

#endif /* __CRT_H */

// By Mrcio Afonso Arimura Fialho.
// Email: jlfialho@inconet.com.br OR jlfialho@yahoo.com.br (alternate)
// http://pessoal.iconet.com.br/jlfialho
// Freeware Library Functions - Free Distribution and Use.
// Read README.1ST for information.