/****************************************************************************/
/*																																					*/
/* ENCOM.H 																																	*/
/*																																					*/
/* This is the main header for ENCOM, containing all the defines, macros,	  */
/* typedefs and prototypes for the library.																	*/
/*																													Kevin Huck			*/
/*																													Boyd Gafford		*/
/*																													01/23/92				*/
/****************************************************************************/
#include <time.h>
#include <conio.h>
#ifndef WN_POPUP
	#ifdef M_I86
	#include <stddef.h>
	#include <sys\types.h>
	#pragma pack(1)
	#define setmem(p,c,v)				memset((p),(v),(c))
	#define movmem(s,d,c)				memmove((d),(s),(c))
	#define getvect(i)          _dos_getvect(i)
	#define setvect(i,hdlr)     _dos_setvect(i,hdlr)
	#define enable              _enable
	#define disable             _disable
	#endif
typedef unsigned char uchar;
typedef unsigned int  uint;
typedef unsigned long ulong;
#endif

#ifdef M_I86    												/* prevents compatibility problems  */
#define outbyte outp                    /* even though Borland has outp,inp */
#define inbyte  inp
#define outword outpw
#define inword  inpw
#else
#define outbyte outportb
#define inbyte  inportb
#define outword outport
#define inword  inport
#endif
typedef unsigned short ushort;

extern int   Tics_per_sec;
extern char  Pause_char, Clear_rx_char, Clear_tx_char;
extern uchar Encrypt_char, End_flag;

/*---------------------- common globals with UltraWin ----------------------*/
#if defined(WN_POPUP) || defined(ENCOM)
extern int					(*Idle_func)();						/* global function pointer		*/
extern ulong T_cnt, T_hi;
extern int Counter, Clock_high;
extern int        Uw_timers[4];               /* user timers-decrement to 0 */
extern int        Sys_timers[2], Sound_timer;	/* system/sound timers				*/
extern int        Clock_init; 								/* 1 if we have clock vector	*/
extern int        Sound_on; 									/* 1 when sound is on					*/
extern ulong      Tics;												/* total clock interrupts			*/

#else

int				 (*Idle_func)();
ulong 		 T_cnt, T_hi;
int 			 Counter, Clock_high;
int        Uw_timers[4];
int        Sys_timers[2], Sound_timer;
int        Clock_init;
int        Sound_on;
ulong      Tics;
#endif


/*-------------------------- crc definitions -------------------------------*/
#define CRC_UNDEF   0
#define CRC_FORWARD 1
#define CRC_REVERSE 2

#define CRCCITT     0x1021
#define CRCCITT_REV 0x8408
#define CRC16       0x8005
#define CRC16_REV   0xa001

#define QUOTE_FLAG   0x88
#define QUOTE_MASK   0x11

#define MAX_MSG_SIZE 512

#define END_FLAG     0x02

/*---------------------- constant definitions ------------------------------*/
#define CNTRL 0x43																	/* clock port addresses */
#define TIMER 0x40


#define HEAD_ROOM		0x8000L		/* 32K memory head room space for allocation	*/

#define SEC_1				18				/* number of clock tics in 1 second						*/

#define ON       1
#define OFF      0

#define CRC_INIT 0xffff
#define CRC_FCS  0xf0b8

#define SOH    0x01
#define STX    0x02
#define ETX    0x03
#define EOT    0x04
#define SYN    0x16
#define CTRL_Z 26

#define XON_CHAR   17
#define XOFF_CHAR  19
#define XON_ANY    256
#define XWAIT			 1
#define XRELEASE   0

#define NONE      'N'
#define ODD       'O'
#define EVEN      'E'
#define MARK      'M'
#define SPACE     'S'

#define MAX_PORTS  4
#define COM1			 0
#define COM2			 1
#define COM3			 2
#define COM4			 3

#define RX         0x01
#define TX         0x02

#define HALF_DUPLEX 0
#define FULL_DUPLEX 1
#define HS_RTS_CTS  2

/*-------------------------- uart type defines -----------------------------*/
#define NO_UART  0
#define ID_8250  1
#define ID_16450 2
#define ID_16550 3

/*-------------------------- 16650 FIFO control ----------------------------*/
#define FIFO_OFF      0x00										/* 16550 fifo enable bit off  */
#define FIFO_ON       0x01										/* 16550 fifo enable bit on	  */
#define RX_FIFO_RESET 0x02										/* 16550 rx fifo reset				*/
#define TX_FIFO_RESET 0x04										/* 16550 tx fifo reset				*/
#define RX_TRIG_1     0x00                    /* 16550 rx fifo trigger 1    */
#define RX_TRIG_4     0x40  									/* 16550 rx fifo trigger 4    */
#define RX_TRIG_8     0x80										/* 16550 rx fifo trigger 8    */
#define RX_TRIG_14    0xc0										/* 16550 rx fifo trigger 14   */

/*-------------------- line status register bit masks ----------------------*/
#define DR	 	 0x01							/* data ready														 0	*/
#define OE 		 0x02							/* overrun error												 1	*/
#define PE	 	 0x04							/* parity error 												 2	*/
#define FE 		 0x08							/* framing error 												 3	*/
#define BI 		 0x10							/* break interrupt											 4	*/
#define THRE	 0x20							/* transmitter holding register empty		 5	*/
#define TSRE	 0x40							/* transmitter shift   register empty		 6	*/
#define F_ERR  0x80							/* FIFO error (only for 16550)           7	*/

/*-------------------- modem status register bit masks ---------------------*/
#define DCTS 	 0x01							/* delta 0 clear to send								 0	*/
#define DDSR	 0x02							/* delta data set ready 								 1	*/
#define TERI 	 0x04							/* trailing edge ring indicator 				 2	*/
#define DDCD	 0x08							/* delta data carrier detect						 3	*/

#define CTS		 0x10							/* clear to send  											 4	*/
#define DSR 	 0x20							/* data set ready                        5	*/
#define RI  	 0x40							/* ring indicator                        6	*/
#define DCD 	 0x80							/* data carrier detect                   7	*/

/*-------------------- modem control register bit masks --------------------*/
#define DTR  	 0x01							/* data terminal ready  								 0	*/
#define RTS  	 0x02							/* request to send      								 1	*/
#define OUT1 	 0x04							/* out 1                                 2	*/
#define OUT2 	 0x08							/* out 2                                 3	*/
#define LOOP 	 0x10							/* loop                                  4	*/

/*--------------------- line control register bit masks --------------------*/
#define DATA_BITS_5  0x00				/* data bit control	masks										*/
#define DATA_BITS_6  0x01
#define DATA_BITS_7  0x02
#define DATA_BITS_8  0x03

#define STOP_BITS_1  0x00				/* stop bit control	masks 									*/
#define STOP_BITS_2  0x04

#define NO_PARITY    0x00				/* parity control masks											*/
#define ODD_PARITY   0x08
#define EVEN_PARITY  0x18
#define MARK_PARITY  0x28
#define SPACE_PARITY 0x38

#define BREAK_CTRL   0x40    		/* break control bit												*/
#define DLAB			   0x80				/* divisor latch access bit									*/

/*---------------------- interrupt enable bit masks ------------------------*/
#define DR_IRQ   0x01						/* data ready irq                           */
#define THRE_IRQ 0x02						/* transmitter holding register empty irq   */
#define RLS_IRQ  0x04						/* receiver line status irq                 */
#define MS_IRQ   0x08						/* modem status irq                         */

/*-------------------- interrupt identification masks ----------------------*/
#define IIR_LSTAT 0x06					/* serialization error or break             */
#define IIR_RX    0x04					/* received data                            */
#define IIR_TX    0x02					/* Transmit Buffer Empty                    */
#define IIR_CTRL  0x00					/* RS-232 input                             */

/*-------------------------- 8250 uart registers ---------------------------*/
/*	{	0x3f8, 0x3f8, 0x3f9, 0x3fa, 0x3fb, 0x3fc, 0x3fd, 0x3fe, 0x3f8, 0x3f9, 0x3ff },*/
#define RBR	 0	               /* receiver buffer register (read only) 			*/
#define THR  1  	             /* transmitter holding register (write only) */
#define IER  2 	  	           /* interrupt enable register            		 	*/
#define IIR  3      	         /* interrupt id register (read only)					*/
#define FCR  3      	         /* FIFO control for 16550 (write only)				*/
#define LCR  4   	    	       /* line control register                     */
#define MCR  5     	    	     /* modem control register                    */
#define LSR  6       	    	   /* line status register                      */
#define MSR  7         	    	 /* modem status register                     */
#define DLL	 8           	 	   /* divisor latch  (low - least significant)  */
#define DLH  9            		 /* divisor latch  (high - most significant)  */
#define SCRATCH 10						 /* scratch pad register											*/


/*---------------------------- com port defines ----------------------------*/
typedef struct port
{
	uchar  reg_save[12];				 /* saves all uart registers before init			*/

	int   rx_on;								 /* receiver on or off												*/
	uint  rx_read; 							 /*	receive queue read  pointer								*/
	uint  rx_write;							 /* recieve queue write pointer               */
	uint  rx_cnt;       	       /* # of bytes currently in receive queue			*/
	uint  rx_size;							 /* actual size of receive queue							*/
	uint  rx_overflow;					 /* count of byte received when queue full		*/
	ulong rx_chars;							 /* receive character count            				*/
	uchar *rx_data;							 /* pointer to receive queue data area				*/
	uint  parity_errs;					 /* line status errors												*/
	uint  framing_errs;
	uint  overrun_errs;
	uint  break_cnt;
	int   que_stat_flag;				 /* if 1, status is queued with each byte			*/
	uint  msg_cnt;							 /* number of messages (match_chars) rx'd    	*/
	uchar encrypt_char;					 /* character to use for XOR encryption     	*/
	uchar match_char;						 /* rx match char.  When rx'd, msg_cnt incs		*/
															 /* Only a call to get_msg decrements					*/

	int   tx_on;								 /* transmitter on or off											*/
	uint  tx_read; 							 /*	transmit queue read  pointer							*/
	uint  tx_write;							 /* transmit queue write pointer              */
	uint  tx_cnt;                /* # of bytes currently in transmit queue		*/
	uint  tx_size;							 /* actual size of transmit queue							*/
	uint  tx_overflow;					 /* count of byte transmit when queue full		*/
	ulong tx_chars;							 /* transfer character count 									*/
	uchar *tx_data;							 /* pointer to transmit queue data area				*/

	int   uart_type;						 /* NO_UART, 8250, 16450, 16550								*/
	int   fifos_enabled;				 /* are fifos enabled if 16550								*/
	int   rx_trig_level;			   /* rx trigger level, 1, 4, 8, or 14					*/
	int   chan;									 /* com port channel index (0 - MAX_PORTS-1)  */
	int   *uart;								 /* pointer to array of uart i/o addresses		*/
	long  baud;									 /* port baud rate divisor										*/
	int 	data_bits;						 /* number of data bits (5,6,7,8)							*/
	int 	stop_bits;						 /* number of stop bits	(1,2)									*/
	int 	parity;								 /* parity (NONE, ODD, EVEN, MARK, SPACE)			*/
	int   status;								 /* 1 = in use, 0 = not in use								*/

#ifdef __cplusplus
	void  interrupt far (*old_vect)(...);
#else
	void  (interrupt far *(old_vect))();
#endif

	int   old_mask;											/* old com port interrupt mask				*/
	int   old_ier;											/* old interrupt id register   				*/
	int 	vect_no;											/* uart com port vector number				*/
	int   mask;                         /* uart com port interrupt mask       */

	int   xon_xoff_mode;								/* 1 if XON/XOFF handshaking enabled	*/
	int   rx_xstate;										/* 1 if XOFF sent                     */
	int   tx_xstate;										/* 1 if XOFF received                 */
	int   xon_char; 										/* char to trigger XON, >= 256 if any	*/
	int   xoff_char;										/* char to trigger XOFF								*/
	uint  highwater;										/* point where we send XOFF for rx		*/
	uint  lowwater;                     /* point where we send XON to release */

	int   rts_cts_mode;									/* 1 if RTS/CTS handshaking enabled		*/
	int   rts_cts_state;								/* current RTS/CTS state (ON/OFF)			*/

	int   dcd_mode;                     /* 1 if CD must be high to rx					*/
	int   dcd_state;										/* current DCD state									*/

	int   dsr_mode;                     /* 1 if DSR must be high to rx				*/
	int   dsr_state;										/* current DSR state									*/

	int   sline_status;									/* static line status register				*/
	int   smodem_status;								/* static modem status register				*/

	int   edge_trigger;									/* for rare hardware incompatibility  */

	void  *usr_ptr;           					/* user expansion pointer        		  */
} PORT;


/*--------------------------------- macros ---------------------------------*/
#define lower(x, y)	  	(((x) < (y)) ? (x) : (y))
#define upper(x, y) 	 	(((x) > (y)) ? (x) : (y))
#define lobyte(c)			  (uchar) ((c) & 0x00ff)
#define hibyte(c)			  (uchar) ((c) >> 8)
#define range(l,b,h)    ( (((b) >= (l)) && ((b) <= (h))) ? 1:0 )
#define swap( a,b,c)	  ( (c) = (a), (a) = (b), (b) = (c) )

#ifndef min
#define min(x, y) 		 	(((x) < (y)) ? (x) : (y))
#define max(x, y)  			(((x) > (y)) ? (x) : (y))
#endif

/*------------------------------- com macros -------------------------------*/
#define com_tx_cnt(cp)       ((cp)->tx_cnt)
#define com_rx_cnt(cp)       ((cp)->rx_cnt)
#define com_tx_free(cp)      ((cp)->tx_size - (cp)->tx_cnt)
#define com_rx_free(cp)      ((cp)->rx_size - (cp)->rx_cnt)
#define is_rx_empty(cp)      ((cp)->rx_cnt ? 1 : 0)
#define is_rx_full(cp)       ((cp)->rx_size == (cp)->rx_cnt)
#define is_tx_empty(cp)      ((cp)->tx_cnt ? 1 : 0)
#define is_tx_full(cp)       ((cp)->tx_size == (cp)->tx_cnt)

#define set_encrypt(c, cp)	 ((cp)->encrypt_char = c)
#define set_match(c, cp)		 ((cp)->match_char = c)
#define init_msg(cp)				 (End_flag = (cp)->match_char, Encrypt_char = (cp)->encrypt_char)

#define msg_cnt(cp)					 ((cp)->msg_cnt)
#define clear_msg_cnt(cp)    ((cp)->msg_cnt = 0)

#define set_que_status(x,cp) ((cp)->que_stat_flag = x)
#define is_que_status(cp)    ((cp)->que_stat_flag)

/*----------------------------- flow control -------------------------------*/
#define set_lowwater(l,cp)   ((cp)->lowwater = l)
#define set_highwater(h,cp)  ((cp)->highwater = h)
#define get_lowwater(cp)     ((cp)->lowwater)
#define get_highwater(cp)    ((cp)->highwater)

#define set_cts_flow(x,cp)   ((cp)->rts_cts_mode = x)

#define is_cts_flow(cp)	     ((cp)->rts_cts_mode)
#define is_dcd_flow(cp) 	   ((cp)->dcd_mode)
#define is_dsr_flow(cp)      ((cp)->dsr_mode)
#define is_xon_flow(cp)		   ((cp)->xon_xoff_mode)

#define cts_flow_state(cp)	 ((cp)->rts_cts_state)
#define dcd_flow_state(cp) 	 ((cp)->dcd_state)
#define dsr_flow_state(cp)   ((cp)->dsr_state)
#define xon_flow_state(cp)	 ((cp)->xon_xoff_state)

/*----------------------- 16550 fifo control macro -------------------------*/
#define fifo_enable(cp)   (com_fifo_ctrl( ON,FIFO_ON,(cp)),(cp)->fifos_enabled =  ON)
#define fifo_disable(cp)  (com_fifo_ctrl(OFF,FIFO_ON,(cp)),(cp)->fifos_enabled = OFF)
#define fifo_rx_reset(cp) (com_fifo_ctrl(ON,RX_FIFO_RESET,(cp)))
#define fifo_tx_reset(cp) (com_fifo_ctrl(ON,TX_FIFO_RESET,(cp)))

#define is_fifo_enabled(cp)   ((cp)->fifos_enabled)
#define get_trigger_level(cp) ((cp)->rx_trig_level)

/*------------------------------ modem macros ------------------------------*/
#define modem_reset(cp)  	       modem_cmd("ATZ",-1,Tics_per_sec*2,(cp))
#define modem_dial(s,cp)         modem_cmd(s,-1,Tics_per_sec*45,(cp))
#define modem_answer(cp)         modem_cmd("ATA",-1,Tics_per_sec,(cp))
#define modem_hangup(cp)         modem_cmd("+++~~~ATH0",-1,Tics_per_sec*5,(cp))
#define modem_online(cp)		   	 modem_cmd("ATO",-1,Tics_per_sec,(cp))
#define modem_repeat(cp)  	     modem_cmd("A/",-1,Tics_per_sec,(cp))
#define modem_speaker(x,cp) 	   modem_cmd("ATM",x,Tics_per_sec,(cp))
#define modem_echo(x,cp)  		   modem_cmd("ATE",x,Tics_per_sec,(cp))
#define modem_word_reply(x,cp)   modem_cmd("ATV",x,Tics_per_sec,(cp))
#define modem_extend_reply(x,cp) modem_cmd("ATX",x,Tics_per_sec,(cp))
#define modem_duplex(x,cp)		   modem_cmd("ATF",x,Tics_per_sec,(cp))
#define modem_quiet(x,cp)		   	 modem_cmd("ATQ",x,Tics_per_sec,(cp))

/*-------------------- current modem status macros -------------------------*/
#define is_dcd(cp)           ((inbyte((cp)->uart[MSR]) & DCD) ? 1 : 0)
#define is_cts(cp)           ((inbyte((cp)->uart[MSR]) & CTS) ? 1 : 0)
#define is_dsr(cp)           ((inbyte((cp)->uart[MSR]) & DSR) ? 1 : 0)
#define is_ri(cp)	           ((inbyte((cp)->uart[MSR]) & RI ) ? 1 : 0)

/*-------------------- static modem status macros --------------------------*/
#define clear_mstatus(cp)		  ((cp)->modem_status = 0)
#define is_sdcd(cp)          (((cp)->smodem_status & DCD)  ? 1 : 0)
#define is_scts(cp)          (((cp)->smodem_status & CTS)  ? 1 : 0)
#define is_sdsr(cp)          (((cp)->smodem_status & DSR)  ? 1 : 0)
#define is_sri(cp)           (((cp)->smodem_status & RI )  ? 1 : 0)

#define is_sddcd(cp)         (((cp)->smodem_status & DDCD) ? 1 : 0)
#define is_sdcts(cp)         (((cp)->smodem_status & DCTS) ? 1 : 0)
#define is_sddsr(cp)         (((cp)->smodem_status & DDSR) ? 1 : 0)
#define is_sdri(cp)          (((cp)->smodem_status & DRI)  ? 1 : 0)

/*-------------------- current line status macros --------------------------*/
#define is_overrun_err(cp)   ((inbyte((cp)->uart[LSR]) & OE)  ? 1 : 0)
#define is_parity_err(cp)    ((inbyte((cp)->uart[LSR]) & PE)  ? 1 : 0)
#define is_framing_err(cp)   ((inbyte((cp)->uart[LSR]) & FE)  ? 1 : 0)
#define is_break(cp)			   ((inbyte((cp)->uart[LSR]) & BI)  ? 1 : 0)

/*-------------------- static line status macros ---------------------------*/
#define clear_lstatus(cp)		  ((cp)->sline_status = 0)
#define is_soverrun_err(cp)  (((cp)->sline_status & OE)  ? 1 : 0)
#define is_sparity_err(cp)   (((cp)->sline_status & PE)  ? 1 : 0)
#define is_sframing_err(cp)  (((cp)->sline_status & FE)  ? 1 : 0)
#define is_sbreak(cp)			   (((cp)->sline_status & BI)  ? 1 : 0)

/*------------------ current modem control macros --------------------------*/
#define is_dtr(cp)           ((inbyte((cp)->uart[MCR]) & DTR)  ? 1 : 0)
#define is_rts(cp)           ((inbyte((cp)->uart[MCR]) & RTS)  ? 1 : 0)
#define is_out1(cp)          ((inbyte((cp)->uart[MCR]) & OUT1) ? 1 : 0)
#define is_out2(cp)          ((inbyte((cp)->uart[MCR]) & OUT2) ? 1 : 0)
#define is_loop(cp)          ((inbyte((cp)->uart[MCR]) & LOOP) ? 1 : 0)


/*------------------------- en_main.c prototypes ---------------------------*/
void com_isr( register PORT *cp );
#ifdef __cplusplus
void interrupt far com_isra(...);
void interrupt far com_isrb(...);
PORT *com_vect_init( void interrupt far (*com_isrp)(...), PORT *cp );
#else
void interrupt far com_isra();
void interrupt far com_isrb();
PORT *com_vect_init( void (interrupt far *com_isrp)(), PORT *cp );
#endif
int  com_port_create( int chan, long baud, int parity, int data_bits,
											int stop_bits, int rx_size, int tx_size, PORT *cp );
int  com_port_init( long baud, int parity, int data_bits, int stop_bits,
										PORT *cp );
void com_port_destroy( PORT *cp );
void com_clear_que( int mode, PORT *cp );
int  com_getc( PORT *cp );
int  com_putc( int c, PORT *cp );
void prime_tx( PORT *cp );
int  force_tx( int c, PORT *cp );
int  com_puts( uchar *s, PORT *cp );
int  check_rts( PORT *cp );
int  com_irq_ctrl( int state, int mask, PORT *cp );
int  com_232_ctrl( int state, int mask, PORT *cp );
void read_regs( uchar *s, PORT *cp );
void write_regs( uchar *s, PORT *cp );

/*------------------------- en_supp.c prototypes ---------------------------*/
int  com_getc_qty( uchar *data, uint qty, PORT *cp );
int  com_gets( uchar *data, uchar c, uint qty, PORT *cp );
int  check_xon( PORT *cp );
int  com_putc1( int c, PORT *cp );
int  com_putc_qty( uchar *data, uint qty, PORT *cp );
void send_break( int t, PORT *cp );
int  set_xon_flow( int state, int xon_char, int xoff_char,
									 uint highwater, uint lowwater, PORT *cp );
int  set_dcd_flow( int state, PORT *cp );
int  set_dsr_flow( int state, PORT *cp );
void suspend( int t );
int  wait_for_rx( int t, uint cnt, PORT *cp );
int  wait_for_no_rx( int t, PORT *cp );
char *modem_cmd( char *cmd_str, int p, int t, PORT *cp );
int com_fifo_ctrl( int state, int mask, PORT *cp );
int com_fifo_trigger( int level, PORT *cp );

/*------------------------- en_supp.c prototypes ---------------------------*/
void encrypt_msg( uchar *msg, uint len );
uint calc_crc( uchar *msg, uint len );
uint fmt_msg( uchar *s, uchar *d, uint len );
uint defmt_msg( uchar *src, uchar *dest );
uint get_msg( uchar *dest, PORT *cp );
#ifdef __cplusplus
void mk_crc_tbl( ushort init, ushort poly, ushort (*crcfn)(...) );
#else
void mk_crc_tbl( ushort init, ushort poly, ushort (*crcfn)() );
#endif
ushort gen_crc(ushort data, ushort genpoly, ushort accum);
ushort gen_crc_rev(ushort data, ushort genpoly, ushort accum);

/*-------------------------- en_kbd.c prototypes ---------------------------*/
void init_ctrlc_hdlr();
void end_ctrlc_hdlr();
void init_clock( uint speed );
void end_clock();
void clock_speed( uint speed );
void tone( uint freq, int dur );
void sound_off();
void set_idle_func( int (*func_ptr)() );

/**** END OF FILE ****/
