
/* eoue.h   EOUE Project, 1997 by Michael Mangelsdorf    */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */


typedef unsigned char  byte;

extern byte *kana_font, *joyo_font,
       *font8x8ptr, *font8x16ptr;

extern byte *scrollbuf;
extern unsigned scroll_ptr;

extern unsigned *jtext;

extern unsigned x,y,wpage;
extern byte c;
extern byte pal [256][3];
extern byte vpage;

/* DOSALLOC.C
*/
extern void libermem (void);
extern byte dosalloc (unsigned paragraphs, unsigned *dosmemseg);
extern byte dosdealloc (unsigned dosmemseg);


/* EMSALLOC.C
*/
extern byte testemm (void);
extern byte emsalloc (byte pages, byte *emsframebase, unsigned *emshandle);
extern void banksw (byte bank, unsigned emshandle);
extern byte emsdealloc (unsigned emshandle);

/* ROMAKANA.C
*/
extern byte kanatransl (byte *linstr, unsigned *codebuf);

/* CONVERT.C
*/
extern unsigned* jis (unsigned *codestr);
extern unsigned* internal (unsigned *codestr);
extern unsigned* resource (unsigned index, unsigned *codestr);

/* VGA.C
*/
extern byte hasvga (void);
extern void get8x8ptr (void);
extern void get8x16ptr (void);
extern void savepal (void);
extern void loadpal (void);
extern void modifypal (byte palreg, byte r, byte b, byte g);
extern void overscan (byte color);
extern void ClrScr (void);
extern void set8025c (void);
extern void plot (void);
extern void peekscr (void);
extern void wait4VRetrace (void);
extern byte set320x400 (byte bordercolor, byte bgcolor);
extern void setvpage (byte page);
extern void copyscr (void);
extern void linedel (unsigned start, unsigned count);
extern void copyline (byte line);
extern void flipscreen (void);
extern void chunkscroll_up (byte lines);
extern void chunkscroll_up_keep (byte lines, byte discard);
extern void chunkscroll_down_kept (byte lines);

/* WRCHAR.C
*/
extern void wrchar_ROM (unsigned x0, unsigned y0,
	       byte uchar, byte bg, byte h);
extern void wrchar_JIS (unsigned x0, unsigned y0,
	       unsigned uchar, byte bg);
extern void fixprint (unsigned col, unsigned line,
	       char *s, byte bg, byte height);
extern void jprint (unsigned col, unsigned line,
	       unsigned *codestr, byte bg);
extern void tategaki (unsigned col, unsigned line,
	       unsigned *codestr, byte bg);

/* INITEXIT.C
*/
extern byte eoue_init (byte uses_scrolling);
extern byte eoue_exit (void);


