/*
         test2.c

         Testing file for Turbo C and/or DJGPP


         W. Metzenthen    17th feb 1992

         Modified for Turbo C 1.5,  2nd March 1992.
         Modified for BCC 3.0 30th March 1992.
 */


#define	__BCC30__	0x400

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>


static int	fd[500];
static FILE	*stream[500];
static int	FullDebug = 0;


int measure_files(void);
int measure_streams(void);
void test_files(int n);
void test_streams(int n);


/*--- main() ----------------------------------------------------------------+
 |                                                                           |
 +---------------------------------------------------------------------------*/
void main(int argc, char *argv[])
{
int	i, maxfd, maxstr;



#ifdef __TURBOC__
/* This is also needed if #pragma startup is not used in close.c */
#if __TURBOC__ <= 0x200
increase_handles();
#endif
#endif

if ( argc > 1 )
	{
	for ( i = 1; i < argc; i++ )
		{
		if ( argv[i][0] == '-' )
			{
			switch ( argv[i][1] )
				{
				case 'd':
				case 'D':
				FullDebug = 1;
				break;

				default:
				fprintf(stderr, "Unknown option\n");
				exit(1);
				}
			}
		}
	}


if ( (i = open("test2.c", 0)) == -1 )
	{
	fprintf(stderr, 
"ERROR: Can't find \"test2.c\".\n"\
"       (\"test2.c\" must be in the current default directory)\n");
	exit(1);
	}
close(i);

maxfd = measure_files();

maxstr = measure_streams();

#ifdef __TURBOC__
test_files(maxfd);
#if __TURBOC__ > __BCC30__
test_streams(maxstr);
#endif
#else
test_streams(maxstr);
#endif

}



/*--- measure_files() -------------------------------------------------------+
 |                                                                           |
 +---------------------------------------------------------------------------*/
int measure_files(void)
{
int	i, j, maxfd;


for ( i = 0 ; i < 500 ; i++ )
	{
	fd[i] = open("test2.c", 0);
	if ( FullDebug )
		printf("fd[%d] = %d\n", i, fd[i]);
	if ( fd[i] == -1 )
		{
		if ( !FullDebug )
			printf("%d: fd = %d\n", i, fd[i]);
		break;
		}
	}

maxfd = i;
printf("%d file opens\n", maxfd);

/* Close all of the files */
for ( j = i-1 ; j >= 0 ; j-- )
	{
	if ( FullDebug )
		printf("closing %d\n", fd[j]);
	if ( close(fd[j]) )
		printf("close returned an error\n");
	}

return maxfd;

}



/*--- measure_streams() -----------------------------------------------------+
 |                                                                           |
 +---------------------------------------------------------------------------*/
int measure_streams(void)
{
int	i, maxstr;


/* See how many streams we can open */
for ( i = 0 ; i < 500 ; i++ )
	{
	if ( FullDebug )
		{
		printf("%d: ", i);
		fflush(stdout);
		}
	stream[i] = fopen("test2.c", "rt");
	if ( FullDebug )
		{
		printf("stream = %p", stream[i]);
		fflush(stdout);
		}
	if ( stream[i] == NULL )
		{
		if ( FullDebug )
			printf("\n");
		  else
			printf("%d: stream = %p\n", i, stream[i]);
		break;
		}
	if ( FullDebug )
		{
		printf(", fd = %d", fileno(stream[i]));
		fflush(stdout);
		}
	if ( FullDebug )
		{
		printf(".\n");
		fflush(stdout);
		}
	}

maxstr = i;
printf("%d stream opens\n", maxstr);

for ( i = 0 ; i < maxstr ; i++ )
	{
	if ( fclose(stream[i]) )
		{
		fprintf(stderr, "stream close error on stream #%d\n", i);
		printf("ERROR: errno = %d, stream #%d fclose()\n", errno, i);
		exit(1);
		}
	}

return maxstr;

}



/*--- test_files() ----------------------------------------------------------+
 |                                                                           |
 +---------------------------------------------------------------------------*/
void test_files(int n)
{
int	i;
char	fname[20], string[80];


for ( i = 0 ; i < n ; i++ )
	{
	sprintf(fname, "fd_%03d.$$$", i);
	fd[i] = open(fname, O_TEXT|O_CREAT|O_RDWR, S_IWRITE);
	if ( FullDebug )
		printf("%d: fd = %d, file = \"%s\"\n", i, fd[i], fname);
	if ( fd[i] == NULL )
		{
		if ( !FullDebug )
			printf("%d: fd = %p\n", i, fd[i]);
		break;
		}
	}

if ( i == n ) printf("test_files(): %d files created\n", i);

for ( i = 0 ; i < n ; i++ )
	{
	sprintf(string, "This is file \"fd_%03d.$$$\"", i);
	write(fd[i], string, strlen(string));
	if ( close(fd[i]) )
		{
		fprintf(stderr, "fd close error %d on fd #%d\n", errno, i);
		exit(1);
		}
	}

}



/*--- test_streams() --------------------------------------------------------+
 |                                                                           |
 +---------------------------------------------------------------------------*/
void test_streams(int n)
{
int	i, count;
char	fname[20];


for ( i = 0 ; i < n ; i++ )
	{
	sprintf(fname, "str_%03d.$$$", i);
	stream[i] = fopen(fname, "wt");
	if ( FullDebug )
		printf("%d: stream = %p, file = \"%s\"", i, stream[i], fname);
	if ( stream[i] == NULL )
		{
		if ( !FullDebug )
			printf("%d: stream = %p\n", i, stream[i]);
		break;
		}
	if ( FullDebug )
		printf(", fd = %d\n", fileno(stream[i]));
	}

if ( i == n ) printf("test_streams(): %d files created\n", i);

for ( i = 0 ; i < n ; i++ )
	{
	count = fprintf(stream[i],
		"This is file \"str_%03d.$$$\", fn = %d, stream = %p",
				i, fileno(stream[i]), stream[i]);
	if ( FullDebug )
		printf("Wrote %d bytes to \"str_%03d.$$$\"\n", count, i);
	if ( fclose(stream[i]) )
		{
		fprintf(stderr, "stream close error on stream #%d\n", i);
		exit(1);
		}
	}

}
