/*
 * idllPower.h - idllPower v3.02 application include file.
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Copyright (c) 1996, Tony Toole
 * Please read idllPower.doc for library reference.
 */                                            

#ifndef __idpower_h__
  #define __idpower_h__

  #ifdef __cplusplus
    extern "C" {
  #endif

  typedef void (*bankType  )(int, int);
  typedef void (*KeyHandler)(int, int);

  enum idllPowerErrors
    {
    idllSuccess, idllModualNotFound, idllOutOfMemory,
    idllInvalidModual, idllModCorrupt, idllInvalidComp, idllInvalidHandle,
    idllInvalidVersion, idllOldVersion, idllExportMissing, idllCompNotSupported
    };

  #pragma pack(1)
  struct tagExtErrorRec
    {
    int   errCode;
    char  highVer;
    char  lowVer;
    char  errMessage[100];
    char  modName[127];
    char  expName[127];
    };
  #pragma pack()

  /***** New to idllPower version 3.02 *****/
  void  idllSetArgs (int argc, char *argv[], char *argvp[]);
  void  idllGetExtErrorInfo (struct tagExtErrorRec *errRec);
  char *idllGetProblemExport();
  char *idllGetProblemModual();
  int   idllGetReturnCode(int modHandle, int *retCode);
  int   idllExecApplication(char *modName, int argc, char *argv[], char *argvp[], int *retCode);
  /*****************************************/

  char   idllGetErrorCode();
  int    idllLoadLibrary(char *modName);
  int    idllGetCompatLowVer();
  int    idllGetCompatHighVer();
  int    idllGetLowVer();
  int    idllGetHighVer();
  char **idllGetArgvp();
  int    idllGetArgc();
  char **idllGetArgv();
  int    idllGetLibHandle(char *modName);
  int    idllFreeLibrary(int modHandle);
  void  *idllGetLibProc(char *procName, int modHandle);
  void  *idllGetVideoRWAddr();
  void  *idllGetVideoRAddr();
  void  *idllGetVideoWAddr();
  int    idllEnablePaging();
  void   idllDisablePaging();
  void   idllSetBankingHook(bankType newBank);
  void *idllGetLibSection(int modHandle, char *section);
  char *idllGetDescription(int modHandle);

/***** Keyboard functions *****/
  void idllHookKbd();
  void idllUnhookKbd();
  int  idllKbdEvent();
  int  idllKeyPressed(int);
  char *idllGetKbdBuf();
  void idllCustomKbdHook(KeyHandler);
  void idllCustomKbdUnhook();

  #ifdef __cplusplus
    }
  #endif

#endif

