INCLUDE CLIB_16.INC

;memmove() -- Copy memory block
;void __far * __far memmove(void __far * const, void __far * const, const int);

;NOTES:
;   assumes that the ds and es segments will never overlap

_TEXT SEGMENT
memmove PROC FAR16 C USES es ds si di,
	    p_m1:FAR16 PTR, p_m2:FAR16 PTR, num:WORD

	    lds si, [p_m2]	    ;ds:SI = source
	    les di, [p_m1]	    ;es:DI = destination
	    mov cx, [num]	    ;CX = count

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@doit		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
@@doit:
	    rep movsb
	    ; done
	    cld		    ;Clear direction flag
@@done:
	    lds si, [p_m1]
	    mov ax, si
	    mov dx, ds
	    ret
memmove ENDP
_TEXT ENDS
END
