INCLUDE CLIB_16.INC

;strcpy() -- Copies string 2 to string 1, including null term char
;char __far * __far strcpy(char __far * const, const char __far * const);

_TEXT SEGMENT
strcpy PROC FAR16 C USES si di es ds, p_str1:FAR PTR BYTE, p_str2:FAR PTR BYTE
	    les di, [p_str1]	    ;es:DI = destination
	    lds si, [p_str2]	    ;ds:SI = source

	    mov ax, ds	    ; if pointers equal, then done
	    mov bx, es
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov bx, di
	    jmp @@exit

@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lodsb		    ;Load char
	    stosb		    ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@exit:
	    mov dx, es
	    mov ax, bx
	    ret 		    ;Return DX:AX points to copied string
strcpy ENDP
_TEXT ENDS
END
