INCLUDE CLIB_16.INC

;iscntrl() - Control Character( 00h-1Fh, 7Fh)
;int __far iscntrl(const int);

;RETURNS:
;   0	    is NOT a control character
;   1	    is	   a control character

_TEXT SEGMENT
iscntrl PROC FAR16 C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 1Fh ; ctrl < 1Fh?
    jbe @@yes
    cmp bl, 7Fh
    jne @@done
@@yes:
    inc ax
@@done:
    ret
iscntrl ENDP

; __fastcall
;   AX		num
;int __fastcall __far iscntrl(const int);
@iscntrl PROC FAR16 USES bx
    mov bl, al
    xor ax, ax
    cmp bl, 7Fh
    je @@yes
    cmp bl, 1Fh
    ja @@exit
@@yes:
    inc ax
@@exit:
    ret
@iscntrl ENDP

_TEXT ENDS
END
