/* skipspr.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"skipspr.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(skipspr)
#endif

// skipspr() -- Find the last non white space char in a string.
//  char * skipspr(const char * const);
// GIVEN:
//	p_str	String to search.
// RETURNS: (r8)
//	pointer to the last non white space character in the string.
//	if no more non white space characters in the string, then
//	  points to terminating '\0'
// NOTES:
//  see isspace for the definition of a white space character
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(skipspr)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str==r32
ret_ptr==r8
tmp==r11
	mov ret_ptr=r0
Loop:
	ld1 tmp=[p_str],1	// tmp=*(p_str++);
	cmp.eq p30,p31=tmp,r0	// if (tmp==0)
	(p30) br.cond.spnt Exit	//  goto Exit
	cmp.eq p30,p31=0x20,tmp	// if(tmp==' ')
	(p30) br.cond.spnt Loop	//  goto Loop
	cmp.gtu p30,p31=0x09,tmp // if(0x09>tmp)
	(p30) br.cond.spnt IsNotWhiteSpace	//   goto Loop
	cmp.ltu p30,p31=0x0D,tmp // if(0x0D<tmp)
IsNotWhiteSpace:
	(p30) mov ret_ptr=p_str	//   ret_ptr=p_str; non white space char
	br.cond.sptk Loop	//  goto Loop
Exit:
	cmp.eq p30,p31=ret_ptr,r0 // if(ret_ptr==0)
	(p30) mov ret_ptr=p_str	//     ret_ptr=p_str;
	sub ret_ptr=ret_ptr,r0,1 //  --ret_ptr;
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(skipspr)
