#define ILIBC_64_EXTERN_PTRS 1
#include "ilibc_64/ilibc_64.inc"

	.file	"string.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strlen)
#endif

// strlen
// GIVEN:
//	p_str	pointer to string (r32)
// RETURNS: (r9)
//	int	string length of p_str
// NOTES:
//	uses r8, r9
p_str==r32	// in/out0
cnt==r8		// return value(return reg)
tmp==r9		// temp value (return scratch)
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strlen)
ilibc_64_proc_prologue
ilibc_64_proc_body
	mov cnt = r0
loop_1:
	ld1 tmp = [p_str]
	add cnt = cnt, r0, 1
	add p_str = p_str, r0, 1
	cmp.ne p30,p31 = r0, tmp
	(p30) br loop_1
	sub cnt = cnt, r0, 1
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strlen)





