/* strncpy.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strncpy.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strncpy)
#endif

// strncpy() -- Copy n characters from one string to another.
// GIVEN:
//	p_str1		Destination string.
//	p_str2		Source string.
//	cnt		number of chars to copy.
// RETURNS: (r8)
//	pointer to the destination string.
// NOTES:
//  a terminating null is always added to end of string1.
//  because of this, n+1 chars may be copied.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strncpy)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str1==r32
p_str2==r33
cnt==r34
tmp==r11
ret_ptr==r8
	mov ret_ptr=p_str1

Loop2:
	cmp.eq p30,p31=cnt,r0		// if(cnt==0)
	(p30) br.cond.spnt AddNull	//  goto AddNull
	ld1 tmp=[p_str2],1		// tmp=*(p_str2++);
	cmp.eq p30,p31=tmp,r0		// if(tmp==0)
	(p30) br.cond.spnt AddNull	//  goto AddNull
	st1 [p_str1]=tmp,1		// *(p_str1++)=tmp;
	sub cnt=cnt,r0,1		// --cnt;
	br.cond.sptk Loop2		//  goto Loop2
AddNull:
	mov tmp=r0
	st1 [p_str1]=tmp	
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strncpy)
