#include <stdio.h>
#define _DEFINED_SIZE_T
#define ILIBC_64_EXTERN_PTRS 1
#include "ilibc_64/misc.h"
#include "ilibc_64/string.h"

#define TEST_ALL 0
#define PAUSE 0

// is functions
typedef int (* P_FN_ONE)(int);
#define NUM_FT_ONE 11

// FT_TWO
// function type two
// skipsp, skiptosp, skipspr, skiptosr, strlwr, strupr
typedef char * (* P_FN_TWO)(char *);
#define NUM_FT_TWO 6

// FT_THREE
// function type three
// strcpy, strcat, strstr
typedef char * (* P_FN_THREE)(char *, char *);
#define NUM_FT_THREE 3

// FT_FOUR
// function type four
// strlen
typedef int (* P_FN_FOUR)(char *);
#define NUM_FT_FOUR 1

// FT_FIVE
// function type five
// strchr, strrchr
typedef char * (* P_FN_FIVE)(char *, int);
#define NUM_FT_FIVE 2

// FT_SIX
// function type six
// strcmp, stricmp
typedef int (* P_FN_SIX)(char *, char *);
#define NUM_FT_SIX 2

// FT_SEVEN
// function type seven
// strncpy, strncat, memmove
typedef char * (* P_FN_SEVEN)(char *, char *, int);
#define NUM_FT_SEVEN 3

// FT_EIGHT
// function type eight
// memcmp
typedef int (* P_FN_EIGHT)(char *, char *, int);
#define NUM_FT_EIGHT 1

// FT_NINE
// function type nine
// memset
typedef char * (* P_FN_NINE)(char *, int, size_t);
#define NUM_FT_NINE 1

     // globals
     char sz_test1[10][64]={
       "This is string1",
       "AAAA BBB CCC",
       "               ",
       "",
       "#$%%JKLaaaa",
       "      f       ",
       "Ijkld;fdsa",
       "            fdsfds",
       "fdsafdsa         ",
       "AXax"};

char sz_test2[10][64]={
  "This is string2",
  "aaaa bbb ccc",
  "                   ",
  "",
  "(*&^^&*^(*(",
  "gfdsgfdsfd",
  "        ax",
  "axAX         ",
  "fdsafdsafds",
  "FDSJAKLGJDF;SL"};

char ch_ary[10]={'\0','A','Z','a','z',0x08,0x09,0x0D,0x0E,0x7F};

void test_ft_one(char * nm, P_FN_ONE pfn){
  int i;
  int x;
  int j;
  printf("Testing %s\n",nm);
  for(i=0,x=0;i<256+16;++i) {
    if (x==16) {x=0;printf("\n");}
    ++x;
    j=(*pfn)(i);
    printf("%02X=%1X ",i,(char) j);
    }
  printf("\n");
  return;
}

void test_ft_two(char * nm, P_FN_TWO pfn) {
  int i;

  char * pc;
  printf("Testing %s\n",nm);
  for(i=0;i<10;++i) {
    printf("Prior:%s?\n",sz_test1[i]);
    pc=(*pfn)(sz_test1[i]);
    printf("res:%s?, sz:%s?\n",pc,sz_test1[i]);
  }
  return;
}

void test_ft_three(char * nm, P_FN_THREE pfn) {
  int i;
  int j;
  char * pc;
  char sz_buf1[32], sz_buf2[32];
  printf("Testing %s\n",nm);
  for (i=0;i<10;++i){
    for(j=0;j<10;++j){
      strcpy(sz_buf1,sz_test1[i]);
      strcpy(sz_buf2,sz_test2[j]);
      printf("Prior 1:%s,2: %s?\n",sz_buf1,sz_buf2);
      pc = (*pfn)(sz_buf1,sz_buf2);
      printf("res:%s,1:%s,2:%s?\n",pc, sz_buf1, sz_buf2);
    }
  }
  return;
}// test_ft_three

void test_ft_four(char * nm, P_FN_FOUR pfn) {
  int i;
  int j;
  char * pc;
  printf("Testing %s\n",nm);
  for(i=0;i<10;++i) {
    printf("Prior:%s?\n",sz_test1[i]);
    j=(*pfn)(sz_test1[i]);
    printf("res:%d?, sz:%s?\n",j,sz_test1[i]);
  }
  return;
}

void test_ft_five(char * nm, P_FN_FIVE pfn) {
  int i;
  char sz_buf[32];
  char * pc;
  int j, k;

  printf("Testing %s\n",nm);
  for(i=0;i<10;++i) {
      for(j=0;j<10;++j) {
        printf("Prior:%s,0x%02X\n",sz_test1[i],ch_ary[j]);
	pc=(*pfn)(sz_test1[i],ch_ary[j]);
        printf("res:%s?, ch:0x%02X, sz:%s?\n",pc,ch_ary[j],sz_test1[i]);
    }
  }
  return;
}

void test_ft_six(char * nm, P_FN_SIX pfn) {

  int i,j,k;

  printf("Testing %s\n",nm);
  for (i=0;i<10;++i) {
    for (j=0;j<10;++j) {
      printf("Prior 1:%s, 2:%s?\n",sz_test1[i],sz_test2[j]);
      k=(*pfn)(sz_test1[i],sz_test2[j]);
      printf("res:%d,1:%s,2:%s?\n",k,sz_test1[i],sz_test2[j]);
    }
  }
  return;
}

void test_ft_seven(char * nm, P_FN_SEVEN pfn) {
  int i,j,k,l,m,n;
  char sz_buf1[64], sz_buf2[64];
  char * pc;

  printf("Testing %s\n",nm);
  for(i=0;i<10;++i) {
    for (j=0;j<10;++j){
      strcpy(sz_buf1,sz_test1[i]);
      strcpy(sz_buf2,sz_test2[j]);
      n=0;
      printf("Prior:1:%s,2:%s,n=%d\n",sz_buf1,sz_buf2,n);
      pc=(*pfn)(sz_buf1,sz_buf2,n);
      printf("Res:%s, %s, %s?\n",pc, sz_buf1, sz_buf2);
      strcpy(sz_buf1,sz_test1[i]);
      strcpy(sz_buf2,sz_test2[j]);
      n=3;
      printf("Prior:1:%s,2:%s,n=%d\n",sz_buf1,sz_buf2,n);
      pc=(*pfn)(sz_buf1,sz_buf2,n);
      printf("Res:%s, %s, %s?\n",pc, sz_buf1, sz_buf2);
      strcpy(sz_buf1,sz_test1[i]);
      strcpy(sz_buf2,sz_test2[j]);
      n=30;
      printf("Prior:1:%s,2:%s,n=%d\n",sz_buf1,sz_buf2,n);
      pc=(*pfn)(sz_buf1,sz_buf2,n);
      printf("Res:%s, %s, %s?\n",pc, sz_buf1, sz_buf2);
    }
  }
return;
}

void test_ft_eight(char * nm, P_FN_EIGHT pfn) {
  int i,j,k,n;

  printf("Testing %s\n",nm);
  for(i=0;i<10;++i) {
    for (j=0;j<10;++j){
      n=0;
      k=(*pfn)(sz_test1[i],sz_test2[j],n);
      n=3;
      k=(*pfn)(sz_test1[i],sz_test2[j],n);
      n=30;
      k=(*pfn)(sz_test1[i],sz_test2[j],n);
    }
  }
return;
}

void test_ft_nine(char * nm, P_FN_NINE pfn) {
  int i,j,k,n;
  char buf[64];
  char * pc;

  printf("Testing %s\n",nm);
  n=0;
  pc=(*pfn)(buf,' ',n);
  n=3;
  pc=(*pfn)(buf,'A',n);
  n=30;
  pc=(*pfn)(buf,'Z',n);
return;
}

int main(int argc, char * argv[], char * envp[]) {
  P_FN_ONE ft_one[NUM_FT_ONE]={p_fn_isspace,
			       p_fn_isalnum,
			       p_fn_isalpha,
			       p_fn_isascii,
			       p_fn_iscntrl,
			       p_fn_iscsym,
			       p_fn_iscsymf,
			       p_fn_isdigit,
			       p_fn_islower,
			       p_fn_isupper,
			       p_fn_isxdigit};
  char sz_ft_one[NUM_FT_ONE][16]={
                        "isspace",
			"isalnum",
			"isalpha",
			"isascii",
			"iscntrl",
			"iscsym",
			"iscsymf",
			"isdigit",
			"islower",
			"isupper",
			"isxdigit"};

  P_FN_TWO ft_two[NUM_FT_TWO]={
    (P_FN_TWO) p_fn_skipsp,
    (P_FN_TWO) p_fn_skiptosp,
    (P_FN_TWO) p_fn_skipspr,
    (P_FN_TWO) p_fn_skiptosr,
    (P_FN_TWO) p_fn_strlwr,
    (P_FN_TWO) p_fn_strupr};
  char sz_ft_two[NUM_FT_TWO][16]={
    "skipsp",
    "skiptosp",
    "skipspr",
    "skiptosr",
    "strlwr",
    "strupr"};

  P_FN_THREE ft_three[NUM_FT_THREE]={
    (P_FN_THREE) p_fn_strcpy,
    (P_FN_THREE) p_fn_strcat,
    (P_FN_THREE) p_fn_strstr};
  char sz_ft_three[NUM_FT_THREE][32]={
    "strcpy",
    "strcat",
    "strstr"};

  P_FN_FOUR ft_four[NUM_FT_FOUR]={
    (P_FN_FOUR) p_fn_strlen};
  char sz_ft_four[NUM_FT_FOUR][32]={
    "strlen"};

  P_FN_FIVE ft_five[NUM_FT_FIVE]={
    (P_FN_FIVE) p_fn_strchr,
    (P_FN_FIVE) p_fn_strrchr};
  char sz_ft_five[NUM_FT_FIVE][32]={
    "strchr",
    "strrchr"};

  P_FN_SIX ft_six[NUM_FT_SIX]={
    (P_FN_SIX) p_fn_strcmp,
    (P_FN_SIX) p_fn_stricmp};
    char sz_ft_six[NUM_FT_SIX][32]={
      "strcmp",
      "stricmp"};

    P_FN_SEVEN ft_seven[NUM_FT_SEVEN]={
      (P_FN_SEVEN) p_fn_strncpy,
      (P_FN_SEVEN) p_fn_strncat,
      (P_FN_SEVEN) p_fn_memmove};
    char sz_ft_seven[NUM_FT_SEVEN][32]={
      "strncpy",
      "strncat",
      "memmove"};

    P_FN_EIGHT ft_eight[NUM_FT_EIGHT]={
      (P_FN_EIGHT) p_fn_memcmp};
    char sz_ft_eight[NUM_FT_EIGHT][32]={
      "memcmp"};

    P_FN_NINE ft_nine[NUM_FT_NINE]={
      (P_FN_NINE) p_fn_memset};
    char sz_ft_nine[NUM_FT_NINE][32]={
      "memset"};

  int i;
  char ch;
  char sz_abc[2];

#if TEST_ALL==0
  goto t_ft_eight;
#endif

  // FT_ONE
 t_ft_one:
  for (i=0;i<NUM_FT_ONE;++i){
    test_ft_one(sz_ft_one[i],ft_one[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_TWO
 t_ft_two:
  for (i=0;i<NUM_FT_TWO;++i){
    test_ft_two(sz_ft_two[i],ft_two[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_THREE
 t_ft_three:
  for (i=0;i<NUM_FT_THREE;++i){
    test_ft_three(sz_ft_three[i],ft_three[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_FOUR
 t_ft_four:
  for (i=0;i<NUM_FT_FOUR;++i){
    test_ft_four(sz_ft_four[i],ft_four[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_FIVE
 t_ft_five:
  for (i=0;i<NUM_FT_FIVE;++i){
    test_ft_five(sz_ft_five[i],ft_five[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_SIX
 t_ft_six:
  for (i=0;i<NUM_FT_SIX;++i){
    test_ft_six(sz_ft_six[i],ft_six[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_SEVEN
 t_ft_seven:
  for (i=0;i<NUM_FT_SEVEN;++i){
    test_ft_seven(sz_ft_seven[i],ft_seven[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_EIGHT
 t_ft_eight:
  for (i=0;i<NUM_FT_EIGHT;++i){
    test_ft_eight(sz_ft_eight[i],ft_eight[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

  // FT_NINE
 t_ft_nine:
  for (i=0;i<NUM_FT_NINE;++i){
    test_ft_nine(sz_ft_nine[i],ft_nine[i]);
#if PAUSE==1
    printf("Hit enter to continue");
    ch=getchar();
#endif
    printf("\n");
  }
#if TEST_ALL==0
  goto t_exit;
#endif

 t_exit:
	 return 0;
}












