INCLUDE CLIBC_16.INC

; skiptosr
; char __near * __near skiptosr(const char __near * const);
; GIVEN:
;   p_str	near pointer, offset from ss
; RETURNS: (char __far *)
;   pointer	near pointer, offset from ss
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
_TEXT SEGMENT
skiptosr PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax

    mov si, [p_str] ; ds/ss:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
skiptosr ENDP

; __fastcall
;   BX	    p_str
; char __near * __fastcall __near skiptosr(const char __near * const);
@skiptosr PROC NEAR16 USES ds si dx
    mov ax, ss
    mov ds, ax

    mov si, bx ; ds/ss:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
@skiptosr ENDP
_TEXT ENDS
END
