INCLUDE CLIBC_16.INC


;strlwr() -- Convert string to lowercase
;char __near * __near strlwr(char __near * const);
; GIVEN;
;   p_str	near pointer, offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str)

_TEXT SEGMENT
strlwr PROC NEAR16 C uses es ds di si, p_str:NEAR16 PTR BYTE

	    mov ax, ss
	    mov ds, ax
	    mov es, ax

	    mov si, [p_str]	    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str

@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]
	    ret
strlwr ENDP

; __fastcall
;   bx	    p_str
;char __near * __fastcall __near strlwr(char __near * const);
@strlwr PROC NEAR16 USES ds es si di

	    mov si, bx		    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str
	    mov ax, ss
	    mov ds, ax
	    mov es, ax


@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx
	    ret
@strlwr ENDP
_TEXT ENDS
END
