INCLUDE CLIBC_16.INC

;strcat() -- Concatenate strings
; appends string2 to end of string1
;char __near * __near strcat(char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (destination) offset from ds
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1

_TEXT SEGMENT
strcat PROC NEAR16 C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat ENDP

; __fastcall
;   bx	    p_str1, (destination) offset from ds
;   ax	    p_str2, (source) offset from ds
;char __near * __fastcall __near strcat(char __near * const, const char __near * const);
@strcat PROC NEAR16 USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ds
	    mov es, ax

	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat ENDP

; GIVEN:
;   p_str1	near pointer, (destination) offset from ds
;   p_str2	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
;char __near * __fastcall __near strcat_sss(char __near * const, const char __near * const);
strcat_sss PROC NEAR16 C uses ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination

	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat_sss ENDP

; __fastcall
;   bx	    p_str1, (destination) offset from ds
;   ax	    p_str2, (source) offset from ss
;char __near * __fastcall __near strcat_sss(char __near * const, const char __near * const);
@strcat_sss PROC NEAR16 USES ds es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ds
	    mov es, ax

	    mov cx, ss
	    mov ds, cx

	    cmp ax, cx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat_sss ENDP

; GIVEN:
;   p_str1	near pointer, (destination) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
;char __near * __near strcat_dss(char __near * const, const char __near * const);
strcat_dss PROC NEAR16 C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov bx, ds

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination

	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat_dss ENDP

; __fastcall
;   bx	    p_str1, (destination) offset from ss
;   ax	    p_str2, (source) offset from ds
;char __near * __fastcall __near strcat_dss(char __near * const, const char __near * const);
@strcat_dss PROC NEAR16 USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ss
	    mov es, ax

	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat_dss ENDP
_TEXT ENDS
END
