INCLUDE CLIBC_16.INC

;strncat() -- Append strings, max length
;char __near * __near strncat(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
_TEXT SEGMENT
strncat PROC NEAR16 C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es:di = p_str1
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat ENDP

; __fastcall
;   bx	    p_str1, (dest) offset from ds
;   ax	    p_str2, (source) offset from ds
;   dx	    num
;char __near * __farcall __near strncat(char __near * const, const char __near * const, const int);
@strncat PROC NEAR16 USES es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ds
	    mov es, cx

	    cmp ax, bx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat ENDP

;strncat_sss() -- Append strings, max length
;char __near * __near strncat_sss(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
strncat_sss PROC NEAR16 C USES ds es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov bx, ds
	    mov es, bx

	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es:di = p_str1

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat_sss ENDP

; __fastcall
;   bx	    p_str1, (dest) offset from ds
;   ax	    p_str2, (source) offset from ss
;   dx	    num
;char __near * __farcall __near strncat_sss(char __near * const, const char __near * const, const int);
@strncat_sss PROC NEAR16 USES ds es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ds
	    mov es, cx

	    cmp bx, ax
	    jne @@cont
	    mov ax, ss
	    mov ds, ax
	    cmp ax, cx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat_sss ENDP

;strncat_dss() -- Append strings, max length
;char __near * __near strncat_dss(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ss (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
strncat_dss PROC NEAR16 C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ss
	    mov es, ax
	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es/ss:di = p_str1
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat_dss ENDP

; __fastcall
;   bx	    p_str1, (dest) offset from ss
;   ax	    p_str2, (source) offset from ds
;   dx	    num
;char __near * __farcall __near strncat_dss(char __near * const, const char __near * const, const int);
@strncat_dss PROC NEAR16 USES es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ss
	    mov es, cx
	    cmp bx, ax
	    jne @@cont
	    mov ax, ds
	    cmp ax, cx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat_dss ENDP
_TEXT ENDS
END
