INCLUDE CLIBC_16.INC

;strncpy() -- Copy n characters of a  string to another
;char __near * __near strncpy(char __near * const, const char __near * const, const size_t);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS:
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   str1 should be at least n+1 bytes
;   str1 is always null terminated

_TEXT SEGMENT
strncpy PROC NEAR16 C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ds
	    mov es, ax

	    mov di, [p_str1]	     ;es:DI = p_str1
	    mov si, [p_str2]	     ;ds:SI = p_str2
	    mov cx, [num]	     ;CX = max length

	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncpy ENDP

; __fastcall
;char __near * __fastcall __near strncpy(char __near * const, const char __near * const, const size_t);
;    bx    p_str1, (dest) offset from ds
;    ax    p_str2, (source) offset from ds
;    dx    num
@strncpy PROC NEAR16 USES es si di cx dx
	    mov di, bx		;es:di = p_str1
	    mov si, ax		;ds:si = p_str2
	    mov cx, dx		;cx = max length

	    mov ax, ds
	    mov es, ax


	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, bx
@@exit:
	    ret
@strncpy ENDP

;strncpy_sss() -- Copy n characters of a string to another
;char __near * __near strncpy_sss(char __near * const, const char __near * const, const size_t);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
;   num 	max number of characters to copy
;RETURNS:
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   str1 should be at least n+1 bytes
;   str1 is always null terminated
strncpy_sss PROC NEAR16 C USES ds es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov bx, ds
	    mov es, bx
	    mov ax, ss
	    mov ds, ax

	    mov di, [p_str1]	     ;es:DI = p_str1
	    mov si, [p_str2]	     ;ds:SI = p_str2
	    mov cx, [num]	     ;CX = max length

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncpy_sss ENDP

; __fastcall
;char __near * __fastcall __near strncpy_sss(char __near * const, const char __near * const, const size_t);
;    bx    p_str1, (dest) offset from ds
;    ax    p_str2, (source) offset from ss
;    dx    num
@strncpy_sss PROC NEAR16 USES ds es si di cx dx
	    mov di, bx		;es:di = p_str1
	    mov si, ax		;ds:si = p_str2
	    mov cx, dx		;cx = max length

	    mov dx, ds
	    mov es, dx
	    mov ax, ss
	    mov ds, ax


	    cmp ax, dx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, bx
@@exit:
	    ret
@strncpy_sss ENDP

;strncpy_dss() -- Copy n characters of a string to another
;char __near * __near strncpy_dss(char __near * const, const char __near * const, const size_t);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS:
;   pointer	near pointer, offset from ss (p_str1)
;NOTES:
;   str1 should be at least n+1 bytes
;   str1 is always null terminated
strncpy_dss PROC NEAR16 C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_str1]	     ;es:DI = p_str1
	    mov si, [p_str2]	     ;ds:SI = p_str2
	    mov cx, [num]	     ;CX = max length

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncpy_dss ENDP

; __fastcall
;char __near * __fastcall __near strncpy_dss(char __near * const, const char __near * const, const size_t);
;    bx    p_str1, (dest) offset from ss
;    ax    p_str2, (source) offset from ds
;    dx    num
@strncpy_dss PROC NEAR16 USES es si di cx dx
	    mov di, bx		;es:di = p_str1
	    mov si, ax		;ds:si = p_str2
	    mov cx, dx		;cx = max length

	    mov ax, ss
	    mov es, ax


	    mov dx, ds
	    cmp ax, dx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, bx
@@exit:
	    ret
@strncpy_dss ENDP
_TEXT ENDS
END
