INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_isalnum:FN_CALL PTR
p_fn_fc_isalnum P_FN_CALL @isalnum
_DATA ENDS

 ENDIF
ENDIF

;isalnum() - Alphanumeric ('A'-'Z','a'-'z','0'-'9')
;int fn_call isalnum(const int);
; RETURNS:
;   0	    if NOT a alphanumeric character
;   1	    if	   a alphanumeric character

CLIBC_16_CS SEGMENT
isalnum PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isalnum ENDP

; __fastcall
;   AX	    nchar
;int __fastcall fn_call isalnum(const int);
@isalnum PROC FN_CALL USES bx
    mov bl, al
    xor ax, ax
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isalnum ENDP
CLIBC_16_CS ENDS
END
