INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_iscsymf:FN_CALL PTR
p_fn_fc_iscsymf P_FN_CALL @iscsymf
_DATA ENDS

 ENDIF
ENDIF

;iscsymf() - Letter or underscore
;int fn_call iscsymf(const int);

; RETURNS:
;   0	    if not a letter or underscore
;   1	    if	   a letter or underscore

CLIBC_16_CS SEGMENT
iscsymf PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 'A' ; capital?
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore?
    je @@yes

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
iscsymf ENDP

; __fastcall
;   AX	    num
;int __fastcall fn_call iscsymf(const int);
@iscsymf PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'A' ; capital?
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore?
    je @@yes

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@iscsymf ENDP
CLIBC_16_CS ENDS
END
