INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_strcpy:FN_CALL PTR
p_fn_fc_strcpy LABEL FN_CALL PTR
	P_FN_CALL @strcpy
	P_FN_CALL @strcpy_sss
	P_FN_CALL @strcpy_dss
_DATA ENDS

 ENDIF
ENDIF

;strcpy() -- Copies string 2 to string 1, including null term char
;char __near * fn_call strcpy(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   Near Model Replacement

CLIBC_16_CS SEGMENT
strcpy PROC FN_CALL C USES si di es, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov di, [p_str1]	    ;es/ds:di = p_str1 = destination
	    mov si, [p_str2]	    ;ds:si = p_str2 = source

	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy ENDP

; __fastcall
; GIVEN:
;   BX		p_str1, offset from ds
;   AX		p_str2, offset from ds
; RETURNS:
;   AX		p_str1, offset from ds
;char __near * __fastcall fn_call strcpy(char const __near *, const char __near * const);
@strcpy PROC FN_CALL USES si di es
	    mov di, bx	    ;es/ss:di = p_str1 = destination
	    mov si, ax	    ;ds:si = p_str2 = source

	    mov ax, ds
	    mov es, ax

	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy ENDP

;strcpy_sss() -- Copies string 2 to string 1, including null term char
;	      -- source pointer (p_str2) offset from ss
;char __near * fn_call strcpy_sss(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ss
; RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   only ASSEMBLY FARSTACK models will be concerned with ss!=ds issues

strcpy_sss PROC FN_CALL C USES si di es ds, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    mov di, [p_str1]	    ;es:di = p_str1 = destination
	    mov si, [p_str2]	    ;ds:si = p_str2 = source

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy_sss ENDP

; __fastcall
; GIVEN:
;   BX		p_str1
;   AX		p_str2
; RETURNS:
;   AX		p_str1
;char __near * __fastcall fn_call strcpy_sss(char const __near *, const char __near * const);
@strcpy_sss PROC FN_CALL USES bx si di es ds
	    mov di, bx	    ;es:DI = p_str1 = destination
	    mov si, ax	    ;ds:SI = p_str2 = source

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    cmp ax, bx	    ; check to see if ds==es
	    jne @@cont
	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy_sss ENDP

;strcpy_dss() -- Copies string 2 to string 1, including null term char
;	      -- destination offset from ss
;char __near * fn_call strcpy_dss(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ss (p_str1)
; NOTES:
;   only ASSEMBLY FARSTACK models will be concerned with ss!=ds issues

strcpy_dss PROC FN_CALL C USES si di es, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov bx, ds

	    mov di, [p_str1]	    ;es:di = p_str1 = destination
	    mov si, [p_str2]	    ;ds:si = p_str2 = source

	    cmp ax, bx		    ; segments equal?
	    jne @@cont
	    cmp si, di		    ; pointers equal?
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy_dss ENDP

; __fastcall
; GIVEN:
;   BX		p_str1, offset from ss
;   AX		p_str2, offset from ds
; RETURNS:
;   AX		p_str1, offset from ss
;char __near * __fastcall fn_call dss_strcpy(char const __near *, const char __near * const);
@strcpy_dss PROC FN_CALL USES cx bx si di es
	    mov di, bx	    ;es:di = p_str1 = destination
	    mov si, ax	    ;ds:si = p_str2 = source

	    mov ax, ss
	    mov es, ax

	    mov cx, ds

	    cmp ax, cx	    ; check to see if ds==es
	    jne @@cont
	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy_dss ENDP
CLIBC_16_CS ENDS
END
