INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_stricmp:FN_CALL PTR
p_fn_fc_stricmp LABEL FN_CALL PTR
	P_FN_CALL @stricmp
	P_FN_CALL @stricmp_sss
	P_FN_CALL @stricmp_dss
_DATA ENDS

 ENDIF
ENDIF

; stricmp() -- Compare strings, case insensitive (lowercase)
;int fn_call stricmp(const char __near * const, const char __near * const);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ds
; RETURNS:
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
CLIBC_16_CS SEGMENT
stricmp PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov di,[p_str1]	    ;es/ss:di = p_str1
	    mov si,[p_str2]	    ;ds:si = p_str2

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
stricmp ENDP

; __farcall
;   bx	    p_str1, (dest) offset from ds
;   ax	    p_str2, (source) offset from ds
;int __farcall fn_call stricmp(const char __near * const, const char __near * const);
@stricmp PROC FN_CALL USES es si di cx dx

	    mov di, bx	    ;es/ss:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ds
	    mov es, ax


	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@stricmp ENDP

; stricmp_sss() -- Compare strings, case insensitive (lowercase)
;int fn_call stricmp_sss(const char __near * const, const char __near * const);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
; RETURNS:
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
stricmp_sss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    mov di,[p_str1]	    ;es/ss:di = p_str1
	    mov si,[p_str2]	    ;ds:si = p_str2

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
stricmp_sss ENDP

; __farcall
;   bx	    p_str1, (dest) offset from ds
;   ax	    p_str2, (source) offset from ss
;int __farcall fn_call stricmp_sss(const char __near * const, const char __near * const);
@stricmp_sss PROC FN_CALL USES ds es si di cx dx

	    mov di, bx	    ;es/ss:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ds
	    mov es, ax

	    mov cx, ss
	    mov ds, cx
	    cmp ax, cx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@stricmp_sss ENDP

; stricmp_dss() -- Compare strings, case insensitive (lowercase)
;int fn_call stricmp_dss(const char __near * const, const char __near * const);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS:
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
stricmp_dss PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax

	    mov di,[p_str1]	    ;es/ss:di = p_str1
	    mov si,[p_str2]	    ;ds:si = p_str2

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
stricmp_dss ENDP

; __farcall
;   bx	    p_str1, (dest) offset from ds
;   ax	    p_str2, (source) offset from ss
;int __farcall fn_call stricmp_dss(const char __near * const, const char __near * const);
@stricmp_dss PROC FN_CALL USES es si di cx dx

	    mov di, bx	    ;es/ss:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ss
	    mov es, ax


	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@stricmp_dss ENDP

CLIBC_16_CS ENDS
END
