INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_strlwr:FN_CALL PTR
p_fn_fc_strlwr LABEL FN_CALL PTR
	P_FN_CALL @strlwr
	P_FN_CALL @strlwr_sss
_DATA ENDS

 ENDIF
ENDIF

;strlwr() -- Convert string to lowercase
;char __near * fn_call strlwr(char __near * const);
; GIVEN;
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str)

CLIBC_16_CS SEGMENT
strlwr PROC FN_CALL C uses es di si, p_str:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, si		    ;es:di = p_str

@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]
	    ret
strlwr ENDP

; __fastcall
;   bx	    p_str, (source) offset from ds
;char __near * __fastcall fn_call strlwr(char __near * const);
@strlwr PROC FN_CALL USES es si di

	    mov si, bx		    ;ds:si = p_str
	    mov di, si		    ;es:di = p_str
	    mov ax, ds
	    mov es, ax


@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx
	    ret
@strlwr ENDP

;strlwr() -- Convert string to lowercase
;char __near * fn_call strlwr_sss(char __near * const);
; GIVEN;
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str)
strlwr_sss PROC FN_CALL C uses es ds di si, p_str:NEAR16 PTR BYTE

	    mov ax, ss
	    mov ds, ax
	    mov es, ax

	    mov si, [p_str]	    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str

@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]
	    ret
strlwr_sss ENDP

; __fastcall
;   bx	    p_str, (source) offset from ss
;char __near * __fastcall fn_call strlwr_sss(char __near * const);
@strlwr_sss PROC FN_CALL USES ds es si di

	    mov si, bx		    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str
	    mov ax, ss
	    mov ds, ax
	    mov es, ax


@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx
	    ret
@strlwr_sss ENDP
CLIBC_16_CS ENDS
END
