; iscsym
;   AAA=mis
;   BBB=005
;   F=
;   O=0
; str005.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_iscsym:FN_CALL PTR
p_fn_iscsym P_FN_CALL iscsym
EXTERNDEF C p_fn_fc_iscsym:FN_CALL PTR
p_fn_fc_iscsym P_FN_CALL @iscsym
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;iscsym() - Letter, underscore, digit
;int fn_call iscsym(const int);
;RETURNS:
;   0	if is NOT a c identifier character
;   1	if is	  a c identifier character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
iscsym PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A'     ; capital letter
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore
    je @@yes

    cmp bl, 'a'     ;lowercase letter
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
iscsym ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;iscsym() - Letter, underscore, digit
;int __fastcall fn_call iscsym(const int);
; __fastcall
;   AX		num
;RETURNS:
;   AX
;   0	if is NOT a c identifier character
;   1	if is	  a c identifier character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@iscsym PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A'     ; capital letter
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore
    je @@yes

    cmp bl, 'a'     ;lowercase letter
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@iscsym ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
