; strcpy
;   AAA=str
;   BBB=000
;   F=0
;   O=0
; str00000.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcpy:FN_CALL PTR
p_fn_strcpy P_FN_CALL strcpy
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcpy() -- Copies string 2 to string 1, including null term char
;char __near * fn_call strcpy(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   p_fn_strcpy
BEGIN_CODE_SEGMENT <STRING>
strcpy PROC FN_CALL C USES si di es, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov di, [p_str1]	    ;es/ds:di = p_str1 = destination
	    mov si, [p_str2]	    ;ds:si = p_str2 = source

	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy ENDP
END_CODE_SEGMENT <STRING>
END
