; @strcmp_dss
;   AAA=str
;   BBB=005
;   F=1
;   O=2
; str00512.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcmp_dss:FN_CALL PTR
p_fn_fc_strcmp_dss P_FN_CALL @strcmp_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcmp_dss() -- Compare strings
;int __fastcall fn_call strcmp(const char __near * const, char __near * const);
; __fastcall
;   BX	    p_str1, (dest) offset from ss
;   AX	    p_str2, (source) offset form ds
; RETURNS:
;   AX <0	if str1 < str2
;   AX 0	if str1 = str2 (identical)
;   AX >0	if str1 > str2
BEGIN_CODE_SEGMENT <STRING>
@strcmp_dss PROC FN_CALL USES es si di

	    mov di, bx	    ;es:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ss
	    mov es, ax

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@strcmp_dss ENDP
END_CODE_SEGMENT <STRING>
END
