; @strstr
;   AAA=str
;   BBB=007
;   F=1
;   O=0
; str00710.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strstr:FN_CALL PTR
p_fn_fc_strstr P_FN_CALL @strstr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strstr() -- Search p_str1 for substring p_str2
;char __near *	__fastcall fn_call strstr(const char __near * const, const char __near * const);
; __fastcall
; GIVEN:
;   BX	p_str1	near pointer, (dest) offset from ds
;   AX	p_str2	near pointer, (src) offset from ds
; RETURNS:
;   AX	near pointer, offset from ds, of substring
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)
BEGIN_CODE_SEGMENT <STRING>
@strstr PROC FN_CALL USES es si di bx cx dx

;   bx = p_str1 (si)
;   ax = p_str2 (di)
    mov cx, ds
    mov es, cx

    cmp ax, bx
    jne @@cont
    ; ax = bx= p_str1
    jmp @@exit	; pointers are equal, done

@@cont:
    ; bx=p_str1, ax=p_str2
    push ax
    push bx ; stk=p_str1, p_str2
    ; get # of bytes in p_str2 (substring,src)
    mov dx, bx	; dx=p_str1
    mov di, ax	; di=p_str2
    xor ax, ax
    mov cx, ax
    dec cx	; cx = -1, ax=0000
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = bytes(p_str2)
    ; ax=0000, di=p_str2(after 0), cx=bytes(p_str2), bx=bytes(p_str2), dx=p_str1
    ; stk=p_str1, p_str2

    ; bytes in p_str1 (search string,dest)
    mov di, dx	; di=p_str1
    mov cx, ax
    dec cx  ; cx=-1
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    mov dx, di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2), dx=di=p_str2(to 0)
    ; stk=p_str1, p_str2

    ; check to see if cx==1, if so, empty src string
    cmp cx, 1
    jg @F
    ; p_str2 is empty
    mov ax, dx
    pop bx
    pop bx ; clean up stack
    jmp @@exit
@@:
    ; check to see if substring(p_str2,src) is longer than search string(p_str1,dest)
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than string
    mov ax, dx
    pop bx
    pop bx ;clean up stack
    jmp @@exit
@@:
    ;sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    pop si	    ; ds:si = search string pointer, p_str1, dest
    pop di	    ; es:di = substring pointer, p_str2, src
    push dx	    ; dx = p_str2(at 0)
    mov dx, di
    ; ax=0000, bx=bytes(str_1) to check, cx=bytes(p_str2), dx=p_str2
    ; di=p_str2, si=p_str1
    ; stk=p_str2(at 0)
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of search string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	    jmp @@notfoundit	; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
	@@notfoundit:
	    ; not found
	    pop cx ; restore old counter
	    pop si ; restore old pointer
	    mov di, dx	; restore pointer to substring
	    mov al, es:[di]	; restore first char of substring
	    jmp @@notequal
;	    inc si
;	    dec bx
;	    jz @@done
;	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si, pointer to p_str1(match start), also ret val
	    pop cx  ; remove old pointer to zero
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax
@@exit:
    ret
@strstr ENDP
END_CODE_SEGMENT <STRING>
END
