; @strrchr
;   AAA=str
;   BBB=008
;   F=1
;   O=0
; str00810.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strrchr:FN_CALL PTR
p_fn_fc_strrchr P_FN_CALL @strrchr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strrchr() -- Search string for char, in reverse
;char __near * __fastcall fn_call strrchr(const char __near * const, const int chr);
; GIVEN:
; __fastcall
;   BX	    p_str, (source) offset from ds
;   AX	    chr
; RETURNS:
;   AX		near pointer, offset from ds
;		to '\0' if character not found
;		to character if found
BEGIN_CODE_SEGMENT <STRING>
@strrchr PROC FN_CALL USES si bx
	    mov si, bx	    ;ds:si = p_Str, source
			    ; ax = chr
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
@strrchr ENDP
END_CODE_SEGMENT <STRING>
END
