; stricmp_dss
;   AAA=str
;   BBB=009
;   F=0
;   O=2
; str00902.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_stricmp_dss:FN_CALL PTR
p_fn_stricmp_dss P_FN_CALL stricmp_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; stricmp_dss() -- Compare strings, case insensitive (lowercase)
;int fn_call stricmp_dss(const char __near * const, const char __near * const);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS:
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
BEGIN_CODE_SEGMENT <STRING>
stricmp_dss PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax

	    mov di,[p_str1]	    ;es/ss:di = p_str1
	    mov si,[p_str2]	    ;ds:si = p_str2

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
stricmp_dss ENDP
END_CODE_SEGMENT <STRING>
END
