; strncpy_dss
;   AAA=str
;   BBB=014
;   F=0
;   O=2
; str01402.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strncpy_dss:FN_CALL PTR
p_fn_strncpy_dss P_FN_CALL strncpy_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strncpy_dss() -- Copy n characters of a string to another
;char __near * fn_call strncpy_dss(char __near * const, const char __near * const, const size_t);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS:
;   pointer	near pointer, offset from ss (p_str1)
;NOTES:
;   str1 should be at least n+1 bytes
;   str1 is always null terminated
BEGIN_CODE_SEGMENT <STRING>
strncpy_dss PROC FN_CALL C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_str1]	     ;es:DI = p_str1
	    mov si, [p_str2]	     ;ds:SI = p_str2
	    mov cx, [num]	     ;CX = max length

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncpy_dss ENDP
END_CODE_SEGMENT <STRING>
END
