// LJTEST1.C -- Print a graphic image on the LaserJet
//
// If you compile with the macro DOSBIN defined, LJTEST1 will
// set the printer stream for DOS to binary mode. Otherwise,
// only the file will be set to binary mode.

#define DOSBIN

#ifdef DOSBIN
#include <dos.h>
union REGS regs;
#endif

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>

int main(void)
   {
   int i,j;
   
   if (setmode(fileno(stdprn),O_BINARY) == -1)
      {
      puts("Can't set printer to O_BINARY mode");
      exit(EXIT_FAILURE);
      }

#ifdef DOSBIN
   regs.x.dx = 0x20;				// Set binary mode
   regs.x.bx = fileno(stdprn);
   regs.x.ax = 0x4401;
   int86(0x21,&regs,&regs);
   if (regs.x.cflag)
      {
      printf("Error %04xH setting PRN device info",regs.x.ax);
      exit(EXIT_FAILURE);
      }
#endif

   // Put LaserJet in 75 dpi Graphics Mode
   fputs("\033*t75R",stdprn);
   
   // Set lef marging of graphics image
   fputs("\033*r0A",stdprn);
   
   // Write a "header line" of A5's
   fputs("\033*b32W",stdprn);
      for (i=0; i<16; i++)
         { fputc(0,stdprn); fputc(0xaa,stdprn); }

   // Write 16 rows of 16 bit patterns
   for (i=0; i<256; i+=16)
      {
      fputs("\033*b32W",stdprn);
      for (j=i; j<i+16; j++)
         {
         fputc(0,stdprn);
         fputc(j,stdprn);
         }
      }
   
   // Exit graphics mode on LaserJet
   fputs("\033*rB",stdprn);

   // Eject page on LaserJet
   fputc(12,stdprn);

   return EXIT_SUCCESS;
   }
