#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graph.h>

void main(void)
   {
   union REGS in_regs, out_regs;
   int row, col;
   int number_pressed, number_released;

   /* Clear the screen */
   _clearscreen(_GCLEARSCREEN);

   /* Initialize the mouse cursor */
   in_regs.x.ax = 0;
   int86(0x33, &in_regs, &out_regs);
   if (!out_regs.x.ax)
      {
      printf("Mouse could not be "
             "initialized.\n");
      exit(1);
      }
   printf("Mouse initialized.\n");

   /* Show the mouse cursor */
   in_regs.x.ax = 1;
   int86(0x33, &in_regs, &out_regs);

   /* Prompt user to move the cursor */
   row = 1;
   col = 1;
   printf("Press any key to move the "
          "mouse cursor to (1, 1).\n");
   getch();

   /* Move the mouse cursor */
   in_regs.x.dx = 8 * (row - 1);
   in_regs.x.cx = 8 * (col - 1);
   in_regs.x.ax = 4;
   int86(0x33, &in_regs, &out_regs);

   /* Clear the left button queue */
   in_regs.x.bx = 0;
   in_regs.x.ax = 5;
   int86(0x33, &in_regs, &out_regs);

   /* Tell user to press left button */
   printf("Press the left mouse button a number of ");
   printf("times, then any key.\n");
   getch();

   /* Read the left button queue */
   in_regs.x.bx = 0;
   in_regs.x.ax = 5;
   int86(0x33, &in_regs, &out_regs);

   /* Convert to text coordinates */
   row = out_regs.x.dx / 8 + 1;
   col = out_regs.x.cx / 8 + 1;

   /* Print the queue information */
   number_pressed = out_regs.x.bx;
   printf("You pressed it %d times.\n",
          number_pressed);
   printf("Last time at (%d, %d).\n",
          row, col);

   /* Clear the left release queue */
   in_regs.x.bx = 0;
   in_regs.x.ax = 6;
   int86(0x33, &in_regs, &out_regs);

   /* Prompt the user */
   printf("Press the left mouse button "
          "a few times, and then press "
          "any key.\n");
   getch();

   /* Read the release queue */
   in_regs.x.bx = 0;
   in_regs.x.ax = 6;
   int86(0x33, &in_regs, &out_regs);

   /* Convert to text position */
   row = out_regs.x.dx / 8 + 1;
   col = out_regs.x.cx / 8 + 1;

   /* Print the release queue info */
   number_released = out_regs.x.bx;
   printf("You released it %d times.\n",
           number_released);
   printf("Last time at (%d, %d).\n",
           row, col);

   /* END OF MOUSE2.C */
   puts("Press any key to exit");
   getch();
   in_regs.x.ax = 2;
   int86(0x33, &in_regs, &out_regs);
   }
