/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** mem.h :      Creation and destruction of arrays  	                 **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#ifndef _MEM_FUNC
#define _MEM_FUNC

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "cmplx.h"


#define TEST_ALLOC(x) null_alloc((char *)(x))
#define XFREE(x) Xfree_b((char **)(x))
#define _INITIALISE    0
#define _NONINITIALISE 1

typedef struct _MEMM {
    int		       dim;
    char            ***ad;
    int                type;
    int		       prof;
} memm;

int             cmpt_mem,
                ind_mem;

typedef	  int		(*i_fonc)();
typedef   double	(*d_fonc)();
typedef   fcomplex	(*fc_fonc)();
typedef   dcomplex	(*dc_fonc)();
typedef   fpolaire	(*fp_fonc)();
typedef   dpolaire	(*dp_fonc)();

typedef struct T_FONC {
    i_fonc	F_i;
    d_fonc	F_d;
    fc_fonc	F_fc;
    dc_fonc	F_dc;
    fp_fonc	F_fp;
    dp_fonc	F_dp;
} T_fonc;

typedef struct CC_FONC {
    d_fonc	CF_d;
    d_fonc      PF_d;
} CC_fonc;

extern T_fonc T_add; 
extern T_fonc T_sub;
extern T_fonc T_mult;
extern T_fonc T_inv; 
extern T_fonc T_Rmul; 
extern T_fonc R_cnst;
extern T_fonc C_mul;
extern T_fonc C_cnst;
extern T_fonc Rpol_cnst; 
extern T_fonc Thpol_cnst;
extern T_fonc T_id;
extern T_fonc C_conjg;
extern T_fonc C_Complex;
extern T_fonc C_Polaire;
extern CC_fonc CC_Reel;
extern CC_fonc CC_R;
extern CC_fonc CC_Imag;
extern CC_fonc CC_Th;

      


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Prototypes des fonctions
----------------------------------------------------------------------
--------------------------------------------------------------------*/
/*
 *   mem.c
 */
memm	       *memm_alloc(int *, int, int);
memm           *_M(char **);
char           *addr_eff(memm *);
char           *addr_eff_b(memm *);
void		Xfree(memm *);
void		Xfree_b(char **);
int		longueur(memm *M);
int		compare_tab(memm *, memm *);
int		compare_dim(memm *, memm *);
int            *int_alloc1(int);
int	      **int_alloc2(int, int);
int	     ***int_alloc3(int, int, int);
int	    ****int_alloc4(int, int, int, int);
float          *float_alloc1(int);
float	      **float_alloc2(int, int);
float	     ***float_alloc3(int, int, int);
float	    ****float_alloc4(int, int, int, int);
double            *double_alloc1(int);
double	      **double_alloc2(int, int);
double	     ***double_alloc3(int, int, int);
double	    ****double_alloc4(int, int, int, int);
fcomplex       *fcomplex_alloc1(int);
fcomplex      **fcomplex_alloc2(int, int);
fcomplex     ***fcomplex_alloc3(int, int, int);
fcomplex    ****fcomplex_alloc4(int, int, int, int);
dcomplex       *dcomplex_alloc1(int);
dcomplex      **dcomplex_alloc2(int, int);
dcomplex     ***dcomplex_alloc3(int, int, int);
dcomplex    ****dcomplex_alloc4(int, int, int, int);
fpolaire       *fpolaire_alloc1(int);
fpolaire      **fpolaire_alloc2(int, int);
fpolaire     ***fpolaire_alloc3(int, int, int);
fpolaire    ****fpolaire_alloc4(int, int, int, int);
dpolaire       *dpolaire_alloc1(int);
dpolaire      **dpolaire_alloc2(int, int);
dpolaire     ***dpolaire_alloc3(int, int, int);
dpolaire    ****dpolaire_alloc4(int, int, int, int);
void		manip1_tab(memm *, memm *, memm *, T_fonc *,
		double, dcomplex, int, CC_fonc*);
void		ajoute_tab(memm *, memm *, memm *);
void		soustrait_tab(memm *, memm *, memm *);
void		multiplie_tab(memm *, memm *, memm *);
void		Rmul_tab(memm *, double, memm *);
void		Cmul_tab(memm *, dcomplex, memm *);
void		Conjg_tab(memm *, memm *);
void		Module_tab(memm *, memm *);
void		Phase_tab(memm *, memm *);
void		copie_tab(memm *, memm *);
void		reel_tab(memm *, memm *);
void		imag_tab(memm *, memm *);
void		Polaire_tab(memm *, memm *, memm *);
void		Complex_tab(memm *, memm *, memm *);
void		cnst_tab(memm *, double);
void		Ccnst_tab(memm *, dcomplex);
void		RPolcnst_tab(memm *, double);
void		ThPolcnst_tab(memm *, double);
memm           *_M(char **);
int		svg_tab(FILE *, char *, int);
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/




#endif
