/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** names.c : Names of the functions corresponding to the commands,       **
**	     in the same order, and names of the functions recognized    **
**           by the Expression Evaluator                                 **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "interp.h"

pfi             proc[] =
{
    temps,
    close_file_cmd,
    delcom,
    deldon,
    delprog_cmd,
    delres,
    echo_cmd,
    echo_float_cmd,
    echo_int_cmd,
    editeur,
    fin_mon_cmd,
    eval_cmd,
    exit_cmd,
    flush_cmd,
    greetb_cmd,
    hist_cmd,
    init_var_cmd,
    is_cmd,
    load_cmd,
    bouclex,
    bouclex_f,
    mon_cmd,
    num_com,
    proglist_cmd,
    question_cmd,
    fread_cmd,
    repetex,
    shell_cmd,
    si_cmd,
    silence_cmd,
    time_cmd,
    undef_cmd,
    var_list_cmd,
    file_cmd,
};


FUNCTION Funcs[] =
{
   /* name, funtion to call */
   { "sin",     1,    sin },		/* 0    */
   { "cos",     1,    cos },		/* 1    */
   { "tan",     1,    tan },		/* 2    */
   { "asin",    1,    asin },		/* 3    */
   { "acos",    1,    acos },		/* 4    */
   { "atan",    1,    atan },		/* 5    */
   { "sinh",    1,    sinh },		/* 6    */
   { "cosh",    1,    cosh },		/* 7    */
   { "tanh",    1,    tanh },		/* 8    */
   { "exp",     1,    exp },		/* 9    */
   { "log",     1,    log },		/* 10   */
   { "log10",   1,    log10 },		/* 11   */
   { "sqrt",    1,    sqrt },		/* 12   */
   { "floor",   1,    floor },		/* 13   */
   { "ceil",    1,    ceil },		/* 14   */
   { "abs",     1,    fabs },		/* 15   */
   { "hypot",   2,    hypot },		/* 16   */
   { "deg",     1,    deg },		/* 17   */
   { "rad",     1,    rad },		/* 18   */
   { 0 }				/* 19   */
};


int    _NBFONC=19;
