///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//////////////
//////////////  IPORT.H - header file for IPORT Library v1.01
//////////////  written by Alexander Sobolev ( mailto:sdols@mail.ru )
//////////////


#ifndef _sd_transporter_header
#define _sd_transporter_header


#ifdef __cplusplus
extern "C" {
#endif

#define TRANSPORTER_API __declspec( dllimport)

#include <winsock.h>
#include <objbase.h>
#include <malloc.h>

/*

    Some important definitions

*/

typedef unsigned int sock_t;
typedef int ( ( *TRANSPORTER_CALLBACK_TYPE) ( void * ) );

enum TRANSPORT_TYPE
    {
    TRANS_UDP,          // plain UDP
    TRANS_TCP,          // plain TCP
    TRANS_TCP_REMOVE    // TCP. 1 input package per connection.( useful for HTTP connections ).
    };

#define MAX_SESSIONS    128     // no more than 128 sessions active at once
#define MAX_SOCK_BUF    4096    // do not process input packages of more than 4096 bytes
#define HOST_LENGTH     255     // maximum length of the IP host name is 255 bytes

enum PACKAGE_STATUS
{
    PS_FREE,
    PS_FULL
};


/*

        INTERFACE DECLARATIONS

*/

#undef INTERFACE
#define INTERFACE IIpConnection

DECLARE_INTERFACE(IIpConnection)
{
public:
        STDMETHOD_ ( int, GetID ) () PURE;
        STDMETHOD_ ( char*, GetData ) () PURE;
        STDMETHOD_ ( char*, GetHost) () PURE;
        STDMETHOD_ ( int, GetDataSize ) () PURE;
        STDMETHOD_ ( sock_t, GetDescriptor ) () PURE;

        STDMETHOD_ ( int, RecvPKT) ( char* out_pkt, int& out_size , timeval* timeout) PURE;
        STDMETHOD_ ( int, SendPKT) ( const char* pkt, const int size ) PURE;
        STDMETHOD_ ( int, SendSynchPKT ) (char* in_pkt, int in_size, char* out_pkt, int& out_size , timeval* timeout ) PURE;

        STDMETHOD_ ( int, Connect ) ( const char* host, const int port ) PURE;
        STDMETHOD_ ( void, Disconnect ) () PURE;
        STDMETHOD_ ( void, Release ) () PURE;

        STDMETHOD_ ( int, SetTarget ) ( const char*, const int ) PURE;
        STDMETHOD_ ( void, SendDatagram ) ( char* dgram, int size ) PURE;
};

#undef INTERFACE
#define INTERFACE IIpService

DECLARE_INTERFACE(IIpService)
{
public:

        STDMETHOD_ ( bool, Alive ) () PURE;
        STDMETHOD_ ( void, Release ) () PURE;
        STDMETHOD_ ( IIpConnection*, GetConnectionList ) () PURE;
        STDMETHOD_ ( int, CloseConnection) ( int ) PURE;
};

/*

            DLL EXPORTS

*/

unsigned long TRANSPORTER_API resolve_addr( const char *host);

int     TRANSPORTER_API IP_OPEN();
void    TRANSPORTER_API IP_CLOSE();

int     TRANSPORTER_API BeginService( const TRANSPORT_TYPE type, int port, TRANSPORTER_CALLBACK_TYPE lpCallBack, TRANSPORTER_CALLBACK_TYPE lpAcceptCallBack, TRANSPORTER_CALLBACK_TYPE lpDisconnectCallBack, IIpService** IDaemon);
void    TRANSPORTER_API FinishService( IIpService *IDaemon );              // Slays the daemon and all it's threads
int     TRANSPORTER_API OpenConnection(const char* host, const int port, const TRANSPORT_TYPE type, TRANSPORTER_CALLBACK_TYPE lpMsgCallback, TRANSPORTER_CALLBACK_TYPE lpDisconnectCallback, IIpConnection** IConnection );
void    TRANSPORTER_API CloseConnection ( IIpConnection* IConnection );


#ifdef __cplusplus
};
#endif

#endif
