/*
   VGA18
   (c) 1994 D.G. Sureau
   Library for VGA screen mode 18
   Copy forbidden

   Librairie pour le mode ecran VGA 18
   Copie interdite
*/


extern int  XL18;
extern int  YT18;
extern int  XR18;
extern int  YB18;
extern char XBL;
extern char XBR;

extern char PENCOL18;
extern char PALETTE;
extern unsigned int VGASCREEN18;

#define SCRADR (char*) 0xA0000000L

extern long *SPVECTOR;
extern char COLOR16;
extern char BPcode;

/*
   SETPIXC
   Put a pixel into window only
   Place un pixel dans la fenetre seulement
*/


void setpixc(int x,int y);

/*
   GETSPADR
   Return a sprite address
   Retourne l'adresse d'un sprite
*/

char *getspadr18(int ns);

/*
   SETALLVGA
   Set values of the 16 colors
   Affecte des valeurs aux 16 couleurs
*/

void setallvga(unsigned char *pal);

/*
   PRINT18
   Put a string using the standard font
   Ecriture d'une chaine de caracteres
   avec la fonte standard.

   x = 0..79
   y = 0..29
   t = string / chaine
 */

void print18(int x, int y,char *t);

/*
   WINDOW18
   Set the graphical window, that sets the following variables:
   XL18 left     XR18 right
   YT18 top      YB18 bottom

   XBL, XBR  left and right bytes

   Delimite la fenetre graphique, les limites sont affectees a:
   XL18 gauche     XR18 droite
   YT18 haut       YB18 bas

   XBL, XBR octets gauche et droite
*/

void window18(int wleft, int wbottom, int wright, int wtop);

/*
   CLR18
   Clear the screen with a color
   Efface l'ecran dans la couleur donnee
*/

void cls18(char color);

/*
   PIXUNPACK
   Subroutine used to display VRT picture
   Routine utilisee par l'affichage d'image VRT
*/

int picunpack(char *BUF);


/*
   GETBPSPRITE
   Get a block of screen
   Make a BP sprite

   Sauvegarde d'une part de l'cran
   Cre un sprite BP

     xl,yt           xr,yt
       ----------------
       |              |
       ----------------
     xl,yb           xr,yb
*/



void getBPsprite(int xl,int yb,int xr,int yt,char *BUFFER);

/*
   BPSPRITE
   Draw a BP sprite
   Pixel coordinates
   No clipping

   Affiche un sprite BP
   Coordonnees en pixels
   Sans fentre
*/


void BPsprite(int x,int y,char *spriteadr);

/*
   FASTBPSPRITE
   Draw a BP sprite
   No boundary
   No clipping

   Affiche un sprite BP
   Coordonnees en octets
   Sans clipping

   x = 0..79
*/


void fastBPsprite(int x,int y,char *spriteadr);

/*
   BPSPRITEC
   Draw a BP sprite with pixels h. coordinates
   Window clipping

   Affiche un sprite BP avec des coordonnees h. en pixels
   Dans la fenetre

   x = 0..639
 */


void BPspritec(int x,int y,char *spriteadr);

/*
   FASTBPSPRITEC
   Draw a BP sprite
   Clipping inside the window
   No boundary: x = 0..79

   Affiche un sprite BP
   Dans la fenetre
   Coordonnees h. en octets
*/

void fastBPspritec(int x,int y,char *spriteadr);


/*
   SP256
   Draw a 256 color sprite
   No clipping

   Affiche un sprite de format 256
   Sans fenetre
*/

void sp256(int x,int y,char *spriteadr);


/*
   SP256C
   Draw a 256 color sprite
   Clipping inside the window

   Affiche un sprite 256
   Dans la fenetre
*/


void sp256c(int x,int y,char *spriteadr);


/*
   CSP256
   Draw a 256 color sprite
   Copy mode (background no masked)
   No clipping

   Affiche un sprite 256
   Mode copie (le fond non masque)
   Sans fenetre
*/

void csp256(int x,int y,char *spriteadr);

/*
   CSP256C
   Draw a 256 color sprite
   Copy mode (background no masked)
   Clipping inside the window

   Affiche un sprite 256
   Mode copie (le fond non masque)
   Dans la fenetre
*/

void csp256c(int x,int y,char *spriteadr);


/*
   ICON18
   Draw an icon
   (color 9 is the mask)

   Affiche une icone
   (la couleur 9 est transparente)
*/

void icon18(int x,int y,char *spriteadr);


/*
   MSPRITE
   Put a MS sprite
   No clipping

   Affiche un sprite MS
   Sans clipping
*/

void msprite(int x,int y,char *memptr);


